VERSION 5.00
Object = "{C0A58BC3-1600-4C2C-8DDB-2DD7FDE5CA63}#1.0#0"; "vbalIml200_75B4A91C.ocx"
Object = "{3040B150-CC4C-4122-A5EC-0512605147B9}#48.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmOptMult 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Option Multiselect Demo"
   ClientHeight    =   7020
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7395
   Icon            =   "OptMult.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7020
   ScaleWidth      =   7395
   StartUpPosition =   2  'CenterScreen
   Begin iGrid250_75B4A91C.iGrid grdMenu 
      Height          =   6255
      Left            =   120
      TabIndex        =   0
      Top             =   360
      Width           =   7155
      _ExtentX        =   12621
      _ExtentY        =   11033
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin vbalIml200_75B4A91C.vbalImageList vbalImageList1 
      Left            =   6840
      Top             =   0
      _ExtentX        =   953
      _ExtentY        =   953
      IconSizeX       =   32
      IconSizeY       =   32
      ColourDepth     =   32
      Size            =   52260
      Images          =   "OptMult.frx":0442
      KeyCount        =   15
      Keys            =   ""
   End
   Begin VB.Label lblTotal 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      Caption         =   "Total: $0.00"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   5910
      TabIndex        =   2
      Top             =   6720
      Width           =   1050
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Please, hold down the CTRL key while selecting required options:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   120
      TabIndex        =   1
      Top             =   60
      Width           =   5610
   End
End
Attribute VB_Name = "frmOptMult"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const CELL_BACK_COLOR = &HF3E9E2
Private Const HIGH_BACK_COLOR = &HC8C8FF
Private Const OPTION_COLOR = vbBlack
Private Const DETAIL_COLOR = &H880000

Dim m_ItemFont As StdFont
Dim m_DetailFont As StdFont

Private Sub Form_Load()
   Dim iRow As Long

   ' Preparing fonts for custom draw cells
   Set m_ItemFont = New StdFont
   With m_ItemFont
      .Name = "MS Sans Serif"
      .Size = 8
      .Bold = True
   End With
   Set m_DetailFont = New StdFont
   With m_DetailFont
      .Name = "Arial"
      .Size = 8
   End With
   
   With grdMenu
      .Redraw = False
      
      .ImageList = vbalImageList1
      .RowMode = True
      .Editable = False
      .Header.Visible = False
      .GridLines = igGridLinesHorizontal
      .FocusRect = False
      .GridLineColor = vbBlack
      .BackColor = vbWhite
      .ForeColor = OPTION_COLOR
      .HighlightForeColor = OPTION_COLOR
      .HighlightBackColor = HIGH_BACK_COLOR
      .MultiSelect = True
      
      With .AddCol(sKey:="Icon", bIncludeInSelect:=False, lWidth:=50)
         .oBackColor = CELL_BACK_COLOR
         .iIndent = 20
      End With
      With .AddCol(sKey:="Item") ' will contain multiline option name
         .eTextFlags = igTextWordBreak
         Set .oFont = m_ItemFont
         .iIndent = 4
      End With
      With .AddCol(sKey:="Price") ' will contain option price
         Set .oFont = m_ItemFont
         .eTextFlags = igTextRight
         .sFmtString = "$0.00"
      End With
      With .AddCol(sKey:="Detail", bRowTextCol:=True) ' will contain option detail
         .eTextFlags = igTextWordBreak
         Set .oFont = m_DetailFont
         .iIndent = 2
         .oForeColor = DETAIL_COLOR
      End With
      
      pPopulate
      
      .AutoWidthCol "Icon"
      .AutoWidthCol "Price"
      pAdjustView
      
      .Redraw = True
   End With
   
   lblTotal.Caption = "Total: " & fsFormatCurrency(0)
End Sub

Private Sub pPopulate()
   Const ROW_COUNT = 15

   Dim iRow As Long, j As Long, k As Long
   Dim sText As String
   
   With grdMenu
      .RowCount = ROW_COUNT
      For iRow = 1 To ROW_COUNT
         .CellIcon(iRow, "Icon") = iRow - 1
         
         .CellValue(iRow, "Price") = Round(Rnd * 20 + 0.5, 2)
         
         k = Int(Rnd() * 5) + 1: sText = ""
         For j = 1 To k
            sText = sText & "Long, long, long row text for the row #" & iRow & ". "
         Next
         .CellValue(iRow, "Detail") = sText
         
         k = Int(Rnd() * 3): sText = " Option " & iRow
         For j = 1 To k
            sText = sText & vbCrLf & "Line " & j & " for this option"
         Next
         .CellValue(iRow, "Item") = sText
      Next
   End With
End Sub

Private Sub grdMenu_CellSelectionChange(ByVal lRow As Long, ByVal lCol As Long, ByVal bSelected As Boolean)
   Dim iRow As Long
   Dim cTotal As Currency
   
   For iRow = 1 To grdMenu.RowCount
      If grdMenu.CellSelected(iRow, "Item") Then
         cTotal = cTotal + grdMenu.CellValue(iRow, "Price")
      End If
   Next
   
   lblTotal.Caption = "Total: " & fsFormatCurrency(cTotal)
End Sub

Private Function fsFormatCurrency(vValue) As String
   fsFormatCurrency = "$" + Format$(vValue, "0.00")
End Function

Private Sub grdMenu_ScrollBarThicknessChanged(ByVal eBar As iGrid250_75B4A91C.EScrollBar, ByVal lValue As Long)
   ' this event works when you change scroll bar width
   ' in Windows Display Properties dialog
   If eBar = igScrollBarV Then
      grdMenu.Redraw = False
      pAdjustView
      grdMenu.Redraw = True
   End If
End Sub

Private Sub pAdjustView()
   Dim iRow As Long
   
   With grdMenu
      .ColWidth("Item") = grdMenu.Width / Screen.TwipsPerPixelX - _
         .ColWidth("Icon") - .ColWidth("Price") - .VScrollBar.Thickness - 4
      
      For iRow = 1 To .RowCount
         .AutoHeightRow iRow
      Next
   End With
End Sub
