' Zeal Progress Bar Control
' Version 1.2
' Copyright (c) 2000-2002 Hai Li, Zeal SoftStudio
' http://www.zealsoft.com (English)
' http://zealsoft.nease.net (Chinese)
' support@zealsoft.com
'
' This is a CARDWARE. If you want to use it, please send
' a postcard(not e-mail) to the author. The address is
'     Hai Li(Zeal ProgressBar)
'     No. 1607 Unit 133
'     Beijing Institute of Tech.
'     Beijing 100081
'     China

Imports System.ComponentModel

Public Enum OrientationType
    zOrientationHorizontal
    zOrientationVertical
End Enum

<ToolboxBitmap(GetType(ZPrgBar.ProgressBar), "progressbar.bmp"), _
Description("ProgressBar component")> _
Public Class ProgressBar
    Inherits System.Windows.Forms.UserControl

    'Property Variables:
    Dim m_Orientation As OrientationType = OrientationType.zOrientationHorizontal
    Dim m_Value As Single = 50
    Dim m_Min As Single = 0
    Dim m_Max As Single = 100
    Dim m_BarText As String = "%"

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        ForeColor = Color.Blue
    End Sub

    'UserControl1 overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        '
        'ProgressBar
        '
        Me.Name = "ProgressBar"
        Me.Size = New System.Drawing.Size(240, 40)

    End Sub

#End Region

    Protected Overrides Sub OnPaint(ByVal e As System.Windows.Forms.PaintEventArgs)
        Dim br As New SolidBrush(ForeColor)
        Dim fPercent As Single
        Dim sString As String
        Dim sizeText As SizeF

        ' Caculate the percent
        fPercent = (m_Value - m_Min) / (m_Max - m_Min)

        ' Set the string to be displayed
        sString = CInt(fPercent * 100).ToString() + m_BarText
        sizeText = e.Graphics.MeasureString(sString, Font)

        ' Draw the border
        ControlPaint.DrawBorder3D(e.Graphics, 0, 0, Width, Height, Border3DStyle.Sunken)

        ' Fill the rectangle
        If m_Orientation = OrientationType.zOrientationHorizontal Then
            e.Graphics.FillRectangle(br, 2, 2, CInt(fPercent * (Width - 4)), Height - 4)
        Else
            e.Graphics.FillRectangle(br, 2, 2 + CInt((1 - fPercent) * (Height - 4)), Width - 4, CInt(fPercent * (Height - 4)))
        End If

        ' Draw the left/bottom part
        Dim clipRect As RectangleF
        clipRect.X = 0
        If m_Orientation = OrientationType.zOrientationHorizontal Then
            clipRect.Width = (Width - 4) * fPercent
            clipRect.Y = 0
            clipRect.Height = Height
        Else
            clipRect.Width = Width
            clipRect.Y = (Height - 4) * (1 - fPercent)
            clipRect.Height = Height - clipRect.Y - 2
        End If
        ' Set clipping region of graphics to rectangle.
        e.Graphics.SetClip(clipRect)
        br.Color = BackColor
        e.Graphics.DrawString(sString, Font, br, _
            (Width - sizeText.Width) / 2, _
            (Height - sizeText.Height) / 2)

        ' Draw the right/top part
        If m_Orientation = OrientationType.zOrientationHorizontal Then
            clipRect.X = clipRect.Width + 1
            clipRect.Width = Width - clipRect.X
        Else
            clipRect.Y = 0
            clipRect.Height = Height - clipRect.Height
        End If
        ' Set clipping region of graphics to rectangle.
        e.Graphics.SetClip(clipRect)
        br.Color = ForeColor
        e.Graphics.DrawString(sString, Font, br, _
            (Width - sizeText.Width) / 2, _
            (Height - sizeText.Height) / 2)
    End Sub

    <Description("Returns/sets a number that specifies the value of the ProgressBar control.")> _
    Public Property Value() As Single
        Get
            Value = m_Value
        End Get
        Set(ByVal Value As Single)
            m_Value = Value
            Refresh()
        End Set
    End Property

    <Description("Returns or sets the ProgressBar control's minimum value.")> _
    Public Property Min() As Single
        Get
            Min = m_Min
        End Get
        Set(ByVal Value As Single)
            m_Min = Value
            Refresh()
        End Set
    End Property

    <Description("Returns or sets the ProgressBar control's maximum value.")> _
    Public Property Max() As Single
        Get
            Max = m_Max
        End Get
        Set(ByVal Value As Single)
            m_Max = Value
            Refresh()
        End Set
    End Property

    <Category("Appearance"), _
    Description("Indicates the orientation (horizontal or vertical) of the object.")> _
    Public Property Orientation() As OrientationType
        Get
            Orientation = m_Orientation
        End Get
        Set(ByVal Value As OrientationType)
            If m_Orientation <> Value Then
                m_Orientation = Value
                Refresh()
            End If
        End Set
    End Property

    <Category("Appearance"), _
    Description("Returns the text of the ProgressBar control.")> _
         Public Property BarText() As String
        Get
            BarText = m_BarText
        End Get
        Set(ByVal Value As String)
            m_BarText = Value
            Refresh()
        End Set
    End Property
End Class
