// UItoComDoc.cpp : implementation of the CUItoComDoc class
//

#include "stdafx.h"
#include "UItoCom.h"

#include "UItoComDoc.h"
#include "DlgProgress.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUItoComDoc

IMPLEMENT_DYNCREATE(CUItoComDoc, CDocument)

BEGIN_MESSAGE_MAP(CUItoComDoc, CDocument)
	//{{AFX_MSG_MAP(CUItoComDoc)
	ON_UPDATE_COMMAND_UI(ID_VECTORIZE_IN_NEW_THREAD, OnUpdateVectorizeInNewThread)
	ON_COMMAND(ID_OPEN_RASTER_IMAGE, OnOpenRasterImage)
	ON_UPDATE_COMMAND_UI(ID_MIRROW_VERTICALLY, OnUpdateMirrowVertically)
	ON_COMMAND(ID_MIRROW_VERTICALLY, OnMirrowVertically)
	ON_UPDATE_COMMAND_UI(ID_ROTATE_LEFT, OnUpdateRotateLeft)
	ON_UPDATE_COMMAND_UI(ID_CLEAN, OnUpdateClean)
	ON_UPDATE_COMMAND_UI(ID_CONNECT, OnUpdateConnect)
	ON_UPDATE_COMMAND_UI(ID_FILL_HOLES, OnUpdateFillHoles)
	ON_UPDATE_COMMAND_UI(ID_FILL_SMALL_HOLES, OnUpdateFillSmallHoles)
	ON_UPDATE_COMMAND_UI(ID_NEGATE, OnUpdateNegate)
	ON_UPDATE_COMMAND_UI(ID_THICKEN, OnUpdateThicken)
	ON_UPDATE_COMMAND_UI(ID_THIN, OnUpdateThin)
	ON_UPDATE_COMMAND_UI(IR_ROTATE_RIGHT, OnUpdateRotateRight)
	ON_COMMAND(ID_CLEAN, OnClean)
	ON_COMMAND(ID_CONNECT, OnConnect)
	ON_COMMAND(ID_FILL_HOLES, OnFillHoles)
	ON_COMMAND(ID_FILL_SMALL_HOLES, OnFillSmallHoles)
	ON_COMMAND(ID_NEGATE, OnNegate)
	ON_COMMAND(ID_ROTATE_LEFT, OnRotateLeft)
	ON_COMMAND(ID_THICKEN, OnThicken)
	ON_COMMAND(ID_THIN, OnThin)
	ON_COMMAND(IR_ROTATE_RIGHT, OnRotateRight)
	ON_UPDATE_COMMAND_UI(SAVE_AS_BMP, OnUpdateAsBmp)
	ON_UPDATE_COMMAND_UI(ID_SAVE_AS_TIF, OnUpdateSaveAsTif)
	ON_COMMAND(ID_SAVE_AS_TIF, OnSaveAsTif)
	ON_COMMAND(SAVE_AS_BMP, OnAsBmp)
	ON_UPDATE_COMMAND_UI(ID_VECTORIZE, OnUpdateVectorize)
	ON_COMMAND(ID_VECTORIZE, OnVectorize)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUItoComDoc construction/destruction

Ivecim * g_pIvecim = NULL;
CUItoComDoc::CUItoComDoc()
{
	m_hBmp = NULL;
	m_pIvecim = NULL;
	m_pixelPerMeter = 0;
	if (FAILED(CoInitialize(NULL)))
	{
		AfxMessageBox("COM library init failed");
		return;
	}
	m_pIvecim = new Ivecim;
	if ( m_pIvecim )
	{//"Vecom.vecim.1"
		BOOL ret = m_pIvecim->CreateDispatch(_T("Vecom.vecim.1"));
		if (!ret)
			AfxMessageBox("CreateDispatch() function failed");
	}
	else
	{
		AfxMessageBox("Allocation of Com object failed");
		exit(1);
	}
	g_pIvecim = m_pIvecim;
}

CUItoComDoc::~CUItoComDoc()
{
	if ( m_hBmp && m_pIvecim)
			m_pIvecim->DelObject((unsigned long)m_hBmp);

	if ( m_pIvecim ) 
		delete m_pIvecim;
	CoUninitialize( );
}

BOOL CUItoComDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CUItoComDoc diagnostics

#ifdef _DEBUG
void CUItoComDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CUItoComDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CUItoComDoc commands

void CUItoComDoc::OnUpdateVectorizeInNewThread(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

 

void CUItoComDoc::OnOpenRasterImage() 
{
	if ( m_hBmp ) 
	{
		m_pIvecim->DelObject((unsigned long)m_hBmp);
		m_hBmp = NULL;
	}

	CString Sfilter = "All supported|*.bmp;*.jpg;*.png;*.tif;*.pcx;*.tga;|BITMAP (*.bmp)|*.bmp|JPEG Images (*.jpg)|*.jpg| PNG Images (*.png)|*.png|";  
	Sfilter += " TIF (*.tif)|*.tif| PCX (*.pcx)|*.pcx| TGA (*.tga)|*.tga||";
	CFileDialog dlg( TRUE  , NULL, NULL, 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, Sfilter);
	int retVal = dlg.DoModal();
	if ( retVal != IDOK) 
		return;
	CString Sfn = dlg.GetPathName( );

	long res = m_pIvecim->Request();
	
	long ppm;
	m_hBmp = (HBITMAP)m_pIvecim->OpenRaster( Sfn, &ppm);
	m_pixelPerMeter	 = ppm;
	UpdateAllViews(NULL);		
}

HBITMAP CUItoComDoc::GetDIB()
{
	return m_hBmp;
}

void CUItoComDoc::OnUpdateMirrowVertically(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnMirrowVertically() 
{
	BOOL ret = m_pIvecim->MirrorVertically((unsigned long)m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}


void CUItoComDoc::OnUpdateRotateLeft(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnUpdateClean(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnUpdateConnect(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnUpdateFillHoles(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnUpdateFillSmallHoles(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnUpdateNegate(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnUpdateThicken(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnUpdateThin(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnUpdateRotateRight(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnClean() 
{
	BOOL ret = m_pIvecim->Clean((unsigned long)m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoComDoc::OnConnect() 
{
	BOOL ret = m_pIvecim->Connect((unsigned long)m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);
}

void CUItoComDoc::OnFillHoles() 
{
	BOOL ret = m_pIvecim->FillHoles((unsigned long)m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoComDoc::OnFillSmallHoles() 
{
	BOOL ret = m_pIvecim->FillSmallHoles((unsigned long)m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoComDoc::OnNegate() 
{
	BOOL ret = m_pIvecim->Negate((unsigned long)m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoComDoc::OnRotateLeft() 
{ 
	long ppm = (long)m_pixelPerMeter;
	HBITMAP hBmp = 
		(HBITMAP)m_pIvecim->RotateLeft((unsigned long)m_hBmp,ppm);
	ASSERT( hBmp );
	m_pIvecim->DelObject((unsigned long)m_hBmp);
	m_hBmp = hBmp;
	UpdateAllViews(NULL);	
}

void CUItoComDoc::OnThicken() 
{
	BOOL ret = m_pIvecim->Thicken((unsigned long)m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoComDoc::OnThin() 
{
	BOOL ret = m_pIvecim->Thin((unsigned long)m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoComDoc::OnRotateRight() 
{
	long ppm = (long)m_pixelPerMeter;
	HBITMAP hBmp = 
		(HBITMAP)m_pIvecim->RotateRight((unsigned long)m_hBmp,ppm);
	ASSERT( hBmp );
	m_pIvecim->DelObject((unsigned long)m_hBmp);
	m_hBmp = hBmp;
	UpdateAllViews(NULL);		
}

void CUItoComDoc::OnUpdateAsBmp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnUpdateSaveAsTif(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoComDoc::OnSaveAsTif() 
{
	CString Simg;
	CString Sfilter = "Tif (*.tif)|*.tif||";  	
	CFileDialog dlg( FALSE  , NULL, Simg, 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, Sfilter);
	int retVal = dlg.DoModal();		
	if ( retVal != IDOK) 
		return;

	CString SfilePath = dlg.GetPathName( );		
	char ext  [_MAX_EXT];
	_splitpath( SfilePath,NULL, NULL, NULL, ext );	
	_strlwr( ext );

	if ( strlen( ext ) == 0 )
		SfilePath += ".tif";
	
	BOOL ret =	m_pIvecim->SaveRaster(SfilePath, (unsigned long)m_hBmp, 
		m_pixelPerMeter);
	ASSERT( ret );
	
}

void CUItoComDoc::OnAsBmp() 
{
	CString Simg;
	CString Sfilter = "Bmp (*.bmp)|*.bmp||";  	
	CFileDialog dlg( FALSE  , NULL, Simg, 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, Sfilter);
	int retVal = dlg.DoModal();		
	if ( retVal != IDOK) 
		return;

	CString SfilePath = dlg.GetPathName( );		
	char ext  [_MAX_EXT];
	_splitpath( SfilePath,NULL, NULL, NULL, ext );	
	_strlwr( ext );

	if ( strlen( ext ) == 0 )
		SfilePath += ".bmp";
	
	BOOL ret =	m_pIvecim->SaveRaster( SfilePath,  (unsigned long)m_hBmp,
		m_pixelPerMeter);
	ASSERT( ret );	
}

int secuCallBackBuildIn(int i){
	
	return 0;
}

UINT ThreadProc( LPVOID pParam )
{
	ThreadParams* pThreadParams = (ThreadParams*)pParam;
	unsigned long hBmp = (unsigned long)pThreadParams->m_hBmp;
	int pixelPerMeter = pThreadParams->m_pixelPerMeter;
	char* setting = pThreadParams->m_settings;   
	
	if ( g_pIvecim == NULL )		return 1;

	
	BOOL ret = g_pIvecim->Vectorize( hBmp,pixelPerMeter, 
		setting, NULL);

	ASSERT( ret );
	
	if ( !ret )
		return 2;

    return 0;   // thread completed successfully
}

void CUItoComDoc::VectorizeInNewThread()
{
	// Read settings	
	BOOL ret = readSettings( m_settings, BUFFERLEN);
	if ( !ret )
		return;
	
	// Now create a new thread and do the vectorization 	
	m_threadParams.m_hBmp = m_hBmp;
	m_threadParams.m_pixelPerMeter = m_pixelPerMeter;
	m_threadParams.m_settings = m_settings;
	CWinThread* pThread = AfxBeginThread(
		ThreadProc,
		& m_threadParams,
		THREAD_PRIORITY_BELOW_NORMAL
		);	
}

BOOL CUItoComDoc::readSettings(char *buffer, int buffSize)
{
	// Read the txt file with parameters.
	// In a custom application this string can be generated on the fly
	TCHAR szLongPathName[_MAX_PATH];
	GetModuleFileName(AfxGetInstanceHandle(), szLongPathName, _MAX_PATH);
	char  drive[_MAX_DRIVE];
	char  dir[_MAX_DIR];
	HBITMAP hBmp = NULL;
	_splitpath( szLongPathName, drive, dir, NULL, NULL );
	TCHAR path[_MAX_PATH];
	_makepath( path, drive, dir, "settings", ".txt" );

	CFile file;
	TRY
	{
		BOOL ret = file.Open(path, CFile::modeRead );
		if (ret)
		{
			int bytesRead = 0;
			bytesRead =	file.Read(buffer,buffSize-1);
			buffer[ bytesRead + 1 ] = 0;
		}
	}
	CATCH (CFileException, e)
	{
		e->ReportError();
		return FALSE;			
	}
	END_CATCH

	return TRUE;
}

Ivecim* CUItoComDoc::GetVecom()
{
	return m_pIvecim;
}

void CUItoComDoc::OnUpdateVectorize(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}


DlgProgress* pDlgProgress = NULL;
BOOL callBackProgress(int progress, const char* operationName )
{
	if ( pDlgProgress == NULL )
		return TRUE;

	pDlgProgress->SetProgress(progress);
	pDlgProgress->SetOperationName(operationName, TRUE);

	return TRUE;
}

void CUItoComDoc::OnVectorize() 
{
	// Read settings
	BOOL ret = readSettings( m_settings, BUFFERLEN);
	if ( !ret )
		return;

	DlgProgress  dlg;
	ret = dlg.Create(DlgProgress::IDD);
	ASSERT(ret);
	dlg.ShowWindow(SW_SHOW);
	if ( ret )	
		pDlgProgress = &dlg;	

	// Now call the vectorization function	
	ret = m_pIvecim->Vectorize((unsigned long)m_hBmp, 
		m_pixelPerMeter, m_settings, (unsigned long)callBackProgress );
	ASSERT( ret );

	pDlgProgress = NULL;
	dlg.DestroyWindow();	
}
