// UItoSDKDoc.cpp : implementation of the CUItoSDKDoc class
//

#include "stdafx.h"
#include "UItoSDK.h"
#include "UItoSDKDoc.h"
#include "DlgProgress.h"

#include "../../../include/fio.h"
#include "../../../include/imgs.h"
#include "Bmp.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUItoSDKDoc

IMPLEMENT_DYNCREATE(CUItoSDKDoc, CDocument)

BEGIN_MESSAGE_MAP(CUItoSDKDoc, CDocument)
	//{{AFX_MSG_MAP(CUItoSDKDoc)
	ON_COMMAND(ID_OPEN_RASTER_IMAGE, OnOpenRasterImage)
	ON_COMMAND(SAVE_AS_BMP, OnSaveAsBmp)
	ON_COMMAND(ID_SAVE_AS_TIF, OnSaveAsTif)
	ON_UPDATE_COMMAND_UI(SAVE_AS_BMP, OnUpdateAsBmp)
	ON_UPDATE_COMMAND_UI(ID_SAVE_AS_TIF, OnUpdateSaveAsTif)
	ON_COMMAND(ID_MIRROW_VERTICALLY, OnMirrowVertically)
	ON_UPDATE_COMMAND_UI(ID_MIRROW_VERTICALLY, OnUpdateMirrowVertically)
	ON_COMMAND(ID_ROTATE_LEFT, OnRotateLeft)
	ON_UPDATE_COMMAND_UI(ID_ROTATE_LEFT, OnUpdateRotateLeft)
	ON_COMMAND(IR_ROTATE_RIGHT, OnRotateRight)
	ON_UPDATE_COMMAND_UI(IR_ROTATE_RIGHT, OnUpdateRotateRight)
	ON_COMMAND(ID_NEGATE, OnNegate)
	ON_UPDATE_COMMAND_UI(ID_NEGATE, OnUpdateNegate)
	ON_COMMAND(ID_FILL_SMALL_HOLES, OnFillSmallHoles)
	ON_UPDATE_COMMAND_UI(ID_FILL_SMALL_HOLES, OnUpdateFillSmallHoles)
	ON_COMMAND(ID_FILL_HOLES, OnFillHoles)
	ON_UPDATE_COMMAND_UI(ID_FILL_HOLES, OnUpdateFillHoles)
	ON_COMMAND(ID_CONNECT, OnConnect)
	ON_UPDATE_COMMAND_UI(ID_CONNECT, OnUpdateConnect)
	ON_COMMAND(ID_CLEAN, OnClean)
	ON_UPDATE_COMMAND_UI(ID_CLEAN, OnUpdateClean)
	ON_COMMAND(ID_THIN, OnThin)
	ON_UPDATE_COMMAND_UI(ID_THIN, OnUpdateThin)
	ON_COMMAND(ID_THICKEN, OnThicken)
	ON_UPDATE_COMMAND_UI(ID_THICKEN, OnUpdateThicken)
	ON_COMMAND(ID_VECTORIZE, OnVectorize)
	ON_UPDATE_COMMAND_UI(ID_VECTORIZE, OnUpdateVectorize)
	ON_UPDATE_COMMAND_UI(ID_VECTORIZE_IN_NEW_THREAD, OnUpdateVectorizeInNewThread)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUItoSDKDoc construction/destruction


CUItoSDKDoc::CUItoSDKDoc()
{
	m_hBmp = NULL;
	m_pixelPerMeter = 0;	
}

CUItoSDKDoc::~CUItoSDKDoc()
{
	if ( m_hBmp ) 
		DeleteObject(m_hBmp);
}


/////////////////////////////////////////////////////////////////////////////
// CUItoSDKDoc serialization


/////////////////////////////////////////////////////////////////////////////
// CUItoSDKDoc diagnostics

#ifdef _DEBUG
void CUItoSDKDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CUItoSDKDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CUItoSDKDoc commands

void CUItoSDKDoc::OnOpenRasterImage() 
{
	if ( m_hBmp ) 
	{
		DeleteObject(m_hBmp);
		m_hBmp = NULL;
	}

	CString Sfilter = "All supported|*.bmp;*.jpg;*.png;*.tif;*.pcx;*.tga;|BITMAP (*.bmp)|*.bmp|JPEG Images (*.jpg)|*.jpg| PNG Images (*.png)|*.png|";  
	Sfilter += " TIF (*.tif)|*.tif| PCX (*.pcx)|*.pcx| TGA (*.tga)|*.tga||";
	CFileDialog dlg( TRUE  , NULL, NULL, 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, Sfilter);
	int retVal = dlg.DoModal();
	if ( retVal != IDOK) 
		return;
	CString Sfn = dlg.GetPathName( );

	CString SfilePath = dlg.GetPathName( );		
	char ext  [_MAX_EXT];
	_splitpath( SfilePath,NULL, NULL, NULL, ext );	
	_strlwr( ext );

	if ( strcmp( ext, ".bmp") == 0 )
		m_hBmp = Bmp::LoadBmpAsDibSec1(m_pixelPerMeter, Sfn);
	else
		m_hBmp = fio_openRaster(m_pixelPerMeter, Sfn);	
	UpdateAllViews(NULL);	
}

void CUItoSDKDoc::OnSaveAsBmp() 
{
	CString Simg;
	CString Sfilter = "Bmp (*.bmp)|*.bmp||";  	
	CFileDialog dlg( FALSE  , NULL, Simg, 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, Sfilter);
	int retVal = dlg.DoModal();		
	if ( retVal != IDOK) 
		return;

	CString SfilePath = dlg.GetPathName( );		
	char ext  [_MAX_EXT];
	_splitpath( SfilePath,NULL, NULL, NULL, ext );	
	_strlwr( ext );

	if ( strlen( ext ) == 0 )
		SfilePath += ".bmp";
	
	BOOL ret =	fio_saveRaster( m_hBmp,m_pixelPerMeter, SfilePath );
	ASSERT( ret );
}

void CUItoSDKDoc::OnSaveAsTif() 
{
	CString Simg;
	CString Sfilter = "Tif (*.tif)|*.tif||";  	
	CFileDialog dlg( FALSE  , NULL, Simg, 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, Sfilter);
	int retVal = dlg.DoModal();		
	if ( retVal != IDOK) 
		return;

	CString SfilePath = dlg.GetPathName( );		
	char ext  [_MAX_EXT];
	_splitpath( SfilePath,NULL, NULL, NULL, ext );	
	_strlwr( ext );

	if ( strlen( ext ) == 0 )
		SfilePath += ".tif";
	
	BOOL ret =	fio_saveRaster( m_hBmp, 
		m_pixelPerMeter, SfilePath );
	ASSERT( ret );
	
}

void CUItoSDKDoc::OnUpdateAsBmp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnUpdateSaveAsTif(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

HBITMAP CUItoSDKDoc::GetDIB()
{
	return m_hBmp;
}

void CUItoSDKDoc::OnMirrowVertically() 
{
	BOOL ret = imgs_mirrorVertically(m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);
}

void CUItoSDKDoc::OnUpdateMirrowVertically(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );
	
}

void CUItoSDKDoc::OnRotateLeft() 
{
	HBITMAP hBmp = imgs_rotateLeft(m_hBmp,m_pixelPerMeter);
	ASSERT( hBmp );
	::DeleteObject(m_hBmp);
	m_hBmp = hBmp;
	UpdateAllViews(NULL);
}

void CUItoSDKDoc::OnUpdateRotateLeft(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnRotateRight() 
{
	HBITMAP hBmp = imgs_rotateRight(m_hBmp,m_pixelPerMeter);
	ASSERT( hBmp );
	::DeleteObject(m_hBmp);
	m_hBmp = hBmp;
	UpdateAllViews(NULL);
	
}

void CUItoSDKDoc::OnUpdateRotateRight(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnNegate() 
{
	BOOL ret = imgs_negate(m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoSDKDoc::OnUpdateNegate(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnFillSmallHoles() 
{
	BOOL ret = imgs_fillSmallHoles(m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);
	
}

void CUItoSDKDoc::OnUpdateFillSmallHoles(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnFillHoles() 
{
	BOOL ret = imgs_fillHoles(m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoSDKDoc::OnUpdateFillHoles(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnConnect() 
{
	BOOL ret = imgs_connect(m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);
}

void CUItoSDKDoc::OnUpdateConnect(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnClean() 
{
	BOOL ret = imgs_clean(m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);
}

void CUItoSDKDoc::OnUpdateClean(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnThin() 
{
	BOOL ret = imgs_thin(m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoSDKDoc::OnUpdateThin(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnThicken() 
{
	BOOL ret = imgs_thicken(m_hBmp);
	ASSERT( ret );
	UpdateAllViews(NULL);	
}

void CUItoSDKDoc::OnUpdateThicken(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}


DlgProgress* pDlgProgress = NULL;
BOOL callBackProgress(int progress, const char* operationName )
{
	if ( pDlgProgress == NULL )
		return TRUE;

	pDlgProgress->SetProgress(progress);
	pDlgProgress->SetOperationName(operationName);

	return TRUE;
}


// The vectorization in the thread of the process
void CUItoSDKDoc::OnVectorize() 
{	
	
	// Read settings
	BOOL ret = readSettings( m_settings, BUFFERLEN);
	if ( !ret )
		return;

	DlgProgress  dlg;
	ret = dlg.Create(DlgProgress::IDD);
	ASSERT(ret);
	dlg.ShowWindow(SW_SHOW);
	if ( ret )	
		pDlgProgress = &dlg;	

	// Now call the vectorization function	
	ret = vec_vectorize(m_hBmp,m_pixelPerMeter, 
		m_settings, callBackProgress);

	ASSERT( ret );
	pDlgProgress = NULL;
	dlg.DestroyWindow();	
}


void CUItoSDKDoc::OnUpdateVectorize(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}

void CUItoSDKDoc::OnUpdateVectorizeInNewThread(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(	m_hBmp != NULL );	
}



UINT ThreadProc( LPVOID pParam )
{
	ThreadParams* pThreadParams = (ThreadParams*)pParam;
	HBITMAP hBmp = pThreadParams->m_hBmp;
	int pixelPerMeter = pThreadParams->m_pixelPerMeter;
	char* setting = pThreadParams->m_settings;   
	
	
    BOOL ret = vec_vectorize(hBmp,pixelPerMeter, 
		setting);
	
	if ( !ret )
		return 1;

    return 0;   // thread completed successfully
}


// The vectorization in a new thread
void CUItoSDKDoc::VectorizeInNewThread() 
{
	// Read settings	
	BOOL ret = readSettings( m_settings, BUFFERLEN);
	if ( !ret )
		return;
	
	// Now create a new thread and do the vectorization 	
	m_threadParams.m_hBmp = m_hBmp;
	m_threadParams.m_pixelPerMeter = m_pixelPerMeter;
	m_threadParams.m_settings = m_settings;
	CWinThread* pThread = AfxBeginThread(
		ThreadProc,
		& m_threadParams,
		THREAD_PRIORITY_BELOW_NORMAL
		);		
}


BOOL CUItoSDKDoc::readSettings(char *buffer, int buffSize)
{
	// Read the txt file with parameters.
	// In a custom application this string can be generated on the fly
	TCHAR szLongPathName[_MAX_PATH];
	GetModuleFileName(AfxGetInstanceHandle(), szLongPathName, _MAX_PATH);
	char  drive[_MAX_DRIVE];
	char  dir[_MAX_DIR];
	HBITMAP hBmp = NULL;
	_splitpath( szLongPathName, drive, dir, NULL, NULL );
	TCHAR path[_MAX_PATH];
	_makepath( path, drive, dir, "settings", ".txt" );

	CFile file;
	TRY
	{
		BOOL ret = file.Open(path, CFile::modeRead );
		if (ret)
		{
			int bytesRead = 0;
			bytesRead =	file.Read(buffer,buffSize-1);
			buffer[ bytesRead + 1 ] = 0;
		}
	}
	CATCH (CFileException, e)
	{
		e->ReportError();
		return FALSE;			
	}
	END_CATCH

	return TRUE;
}




