<%! 

static DateFormat dateFormat=DateFormat.getDateInstance(DateFormat.SHORT);

static final String getUsersText(boolean showOnlySelf, int[] suppressedUserIds, boolean isAssignedByUsers, User user, boolean listSuppressed)
{
	String ret="";
	StringBuffer buffer=null;
	if (showOnlySelf)
	{
		ret="<font class=\"filteredFieldFont\">self ("+user.getFullname()+")</font>";
	}
	else
	{
		if (suppressedUserIds==null || suppressedUserIds.length==0)
		{
			ret="not filtered";
		}
		else
		{
			buffer=new StringBuffer(suppressedUserIds.length*20);
			for (int i=0; i<suppressedUserIds.length; i++)
			{
				User thisUser=Manager.selectUserById(suppressedUserIds[i]);
				if (i>0)
				{
					if (i<suppressedUserIds.length-1)
					{
						if (listSuppressed)
						{
							buffer.append(", ");
						}
						else
						{
							buffer.append("<BR>");
						}

					}
					else
					{
						if (listSuppressed)
						{
							buffer.append(" and ");
						}
						else
						{
							buffer.append("<BR>");
						}
					}
				}
				buffer.append((listSuppressed?"'":"&nbsp;&nbsp;&nbsp;&middot; ")+thisUser.getFullname()+(listSuppressed?"'":""));
			}
			if (listSuppressed)
			{
				ret="<font class=\"filteredFieldFont\">all users <a href=\"#\" title=\"all users except "+buffer.toString()+"\" onclick=\"ListManager.showSuppressedNames('"+GeneralUtils.stringReplace(buffer.toString(),'\'',"\\\'")+"',"+isAssignedByUsers+"); return false\">except...</a></font>";
			}
			else
			{
				ret="<font class=\"filteredFieldFont\">all users except:<BR>"+buffer.toString()+"</font>";
			}
		}
		
	}
	return ret;
}

static final String getProjectText(int[] suppressedProjectIds, boolean listSuppressed)
{
	String ret="";
	StringBuffer buffer=null;

	if (suppressedProjectIds==null || suppressedProjectIds.length==0)
	{
		ret="not filtered";
	}
	else
	{
		buffer=new StringBuffer(suppressedProjectIds.length*20);
		for (int i=0; i<suppressedProjectIds.length; i++)
		{
			Project thisProject=Manager.selectProjectById(suppressedProjectIds[i]);
			if (i>0)
			{
				if (i<suppressedProjectIds.length-1)
				{
					if (listSuppressed)
					{
						buffer.append(", ");
					}
					else
					{
						buffer.append("<BR>");
					}
					
				}
				else
				{
					if (listSuppressed)
					{
						buffer.append(" and ");
					}
					else
					{
						buffer.append("<BR>");
					}
				}
			}
			buffer.append((listSuppressed?"'":"&nbsp;&nbsp;&nbsp;&middot; ")+thisProject.getName()+(listSuppressed?"'":""));
		}
		if (listSuppressed)
		{
			ret="<font class=\"filteredFieldFont\">all projects <a href=\"#\" title=\"all projects except "+buffer.toString()+"\" onclick=\"ListManager.showSuppressedProjectsOrInstances('"+GeneralUtils.stringReplace(buffer.toString(),'\'',"\\\'")+"',true); return false\">except...</a></font>";
		}
		else
		{
			ret="<font class=\"filteredFieldFont\">all projects except:<BR>"+buffer.toString()+"</a></font>";
		}
	}

	return ret;
}

static final String getInstanceText(int[] suppressedInstanceIds, boolean listSuppressed)
{
	String ret="";
	StringBuffer buffer=null;

	if (suppressedInstanceIds==null || suppressedInstanceIds.length==0)
	{
		ret="not filtered";
	}
	else
	{
		buffer=new StringBuffer(suppressedInstanceIds.length*20);
		for (int i=0; i<suppressedInstanceIds.length; i++)
		{
			Instance thisInstance=Manager.selectInstanceById(suppressedInstanceIds[i]);
			if (i>0)
			{
				if (i<suppressedInstanceIds.length-1)
				{
					if (listSuppressed)
					{
						buffer.append(", ");
					}
					else
					{
						buffer.append("<BR>");
					}
					
				}
				else
				{
					if (listSuppressed)
					{
						buffer.append(" and ");
					}
					else
					{
						buffer.append("<BR>");
					}
				}
			}
			buffer.append((listSuppressed?"'":"&nbsp;&nbsp;&nbsp;&middot; ")+thisInstance.getName()+(listSuppressed?"'":""));
		}
		if (listSuppressed)
		{
			ret="<font class=\"filteredFieldFont\">all instances <a href=\"#\" title=\"all instances except "+buffer.toString()+"\" onclick=\"ListManager.showSuppressedProjectsOrInstances('"+GeneralUtils.stringReplace(buffer.toString(),'\'',"\\\'")+"',false); return false\">except...</a></font>";
		}
		else
		{
			ret="<font class=\"filteredFieldFont\">all instances except:<BR>"+buffer.toString()+"</font>";
		}
	}

	return ret;
}

static final String getDateText(Date min, Date max)
{
	String ret="";
	if 
	(
		min.getTime()==IssueFilter.NO_MINIMUM_DATE.getTime() && 
		max.getTime()==IssueFilter.NO_MAXIMUM_DATE.getTime()
	)
	{
		ret="not filtered";
	}
	
	else if
	(
		min.getTime()!=IssueFilter.NO_MINIMUM_DATE.getTime() && 
		max.getTime()!=IssueFilter.NO_MAXIMUM_DATE.getTime()
	)
	{
		ret="<font class=\"filteredFieldFont\">"+dateFormat.format(min)+"-"+dateFormat.format(max)+"</font>";
	}
	
	// we're this far so we know that either the min or max is unspecified, so we're talking about either
	// "before xx/xx/xx" or "after xx/xx/xx":
	else if (min.getTime()==IssueFilter.NO_MINIMUM_DATE.getTime())
	{
		ret="<font class=\"filteredFieldFont\">before "+dateFormat.format(max)+"</font>";
	}
	else
	{
		ret="<font class=\"filteredFieldFont\">after "+dateFormat.format(min)+"</font>";
	}
	
	return ret;
}

%>




 
 <div id=filterInfo> 
 <div id=filterInfoHeader <%=(!(currentSubsectionName.equals(WorkRollConstants.SUBSECTION_ISSUES_PRINTABLE)) || filter!=null?"":" style=\"display:none;\"")%>>
 <table width=<%=filterTableWidth%> border=0 cellspacing=0 cellpadding=0>
 <tr>
 <td style="color:#000000; font-family:arial,helvetica; font-size:11px; font-weight:bold;"><%
 if (filter!=null)
 {
 	%>The list is filtered<%=(currentSubsectionName.equals(WorkRollConstants.SUBSECTION_ISSUES_PRINTABLE))?"":HelpManager.helpLink("filter","F2F2E1",request)%> to display the <script>
 	document.write(top.numIssues)
 	</script> <%=isActiveIssues?"active (non-closed)":"closed"%> issues that match the criteria below.<%
 }
 else
 {
 	%>The list is not filtered<%=(currentSubsectionName.equals(WorkRollConstants.SUBSECTION_ISSUES_PRINTABLE))?"":HelpManager.helpLink("filter","F2F2E1",request)%>; all <script>
 	document.write(top.numIssues)
 	</script> <%=isActiveIssues?"active (non-closed)":"closed"%> issues are displayed.<%
 }
 
 %><BR></td>
 <td align=right style="color:#444434; font-family:arial,helvetica; font-size:11px;"><B><%
 if (!(currentSubsectionName.equals(WorkRollConstants.SUBSECTION_ISSUES_PRINTABLE)))
 {
	 if (filter!=null)
	 {
		%><a href=# onclick="applyFilter(); return false">modify this filter</a> | <a href=# onclick="removeFilter(); return false;">remove this filter</a><%
	 }
	 else
	 {
		%><a href=# onclick="applyFilter(); return false">apply a filter</a></B><%
	 }
 }
 %>&nbsp;&nbsp;<BR></td>
 </tr>
 </table>
 </div>
 <%
 
 StringBuffer filterInfoOutStr=new StringBuffer(5000);
 
 String assignedByText=null;
 String assignedToText=null;
 String statusText=null;
 String priorityText=null;
 String openedText=null;
 String dueText=null;
 String projText=null;
 String instText=null;
 
 if (filter!=null)
 {
 	boolean showOnlyAssignedBySelf=filter.isShowOnlyAssignedBySelf();
 	boolean showOnlyAssignedToSelf=filter.isShowOnlyAssignedToSelf();
 	int[] suppressedByUserIds=filter.getSuppressAssignedByUserIds();
 	int[] suppressedToUserIds=filter.getSuppressAssignedToUserIds();
 	int[] suppressedProjectIds=filter.getSuppressProjectIds();
 	int[] suppressedInstanceIds=filter.getSuppressInstanceIds();
 	int lowestPriority=filter.getLowestPriority();
 	int statuses=filter.getStatuses();
 	Date openMin=filter.getEarliestOpenDate();
 	Date openMax=filter.getLatestOpenDate();
 	Date dueMin=filter.getEarliestDueDate();
 	Date dueMax=filter.getLatestDueDate();
 	
 	boolean listSuppressed=(isActiveListFooter && controller.getClient().isExp() && controller.getClient().isWin());
 	assignedByText=getUsersText(showOnlyAssignedBySelf,suppressedByUserIds,true,controller.getSessionInfo().getUser(), listSuppressed);
 	assignedToText=getUsersText(showOnlyAssignedToSelf,suppressedToUserIds,false,controller.getSessionInfo().getUser(), listSuppressed);
 	
 	if (statuses==IssueFilter.OPEN_ONLY)
 	{
 		statusText="<font class=\"filteredFieldFont\">open only</font>";
 	}
 	else if (statuses==IssueFilter.RESOLVED_ONLY)
 	{
 		statusText="<font class=\"filteredFieldFont\">resolved only</font>";
 	}
 	else if (statuses==IssueFilter.OPEN_AND_RESOLVED)
 	{
 		statusText="not filtered";
 	}
 	
 	if (lowestPriority==AbstractIssue.PRIORITY_VERY_LOW)
 	{
 		priorityText="not filtered";
 	}
 	else if (lowestPriority==AbstractIssue.PRIORITY_LOW)
 	{
 		priorityText="<font class=\"filteredFieldFont\">low and above</font>";
 	}
 	else if (lowestPriority==AbstractIssue.PRIORITY_NORMAL)
 	{
 		priorityText="<font class=\"filteredFieldFont\">normal and above</font>";
 	}
 	else if (lowestPriority==AbstractIssue.PRIORITY_HIGH)
 	{
 		priorityText="<font class=\"filteredFieldFont\">high and above</font>";
 	}
 	else if (lowestPriority==AbstractIssue.PRIORITY_EMERGENCY)
 	{
 		priorityText="<font class=\"filteredFieldFont\">emergency only</font>";
 	}
 	
 	openedText=getDateText(openMin,openMax);
 	dueText=getDateText(dueMin,dueMax);
 	
 	projText=getProjectText(suppressedProjectIds, listSuppressed);
 	instText=getInstanceText(suppressedInstanceIds, listSuppressed);
 }

 if (filter!=null)
 {
	filterInfoOutStr.append("<div id=filterInfoText>");
	filterInfoOutStr.append("<table border=0 cellspacing=0 cellpadding=0 width="+filterTableWidth+" >");
	filterInfoOutStr.append("<tr valign=top>");
	filterInfoOutStr.append("<td xwidth=25% nowrap class=filterDetailFont><i>Assigned by:</i> "+assignedByText+"<BR></td>");
	filterInfoOutStr.append("<td xwidth=25% nowrap class=filterDetailFont><i>Assigned to:</i> "+assignedToText+"<BR></td>");
	filterInfoOutStr.append("<td xwidth=25% nowrap class=filterDetailFont><i>Status:</i> "+statusText+"<BR></td>");
	filterInfoOutStr.append("<td xwidth=25% nowrap class=filterDetailFont><i>Priority:</i> "+priorityText+"<BR></td>");
	filterInfoOutStr.append("</tr>");
	if (!isActiveListFooter)
	{
		filterInfoOutStr.append("<tr><td>"+HtmlUtils.spacer(8, 1, request)+"<BR></td></tr>");
	}
	filterInfoOutStr.append("<tr valign=top>");
	filterInfoOutStr.append("<td class=filterDetailFont><i>Opened:</i> "+openedText+"<BR></td>");
	filterInfoOutStr.append("<td class=filterDetailFont><i>Due:</i> "+dueText+"<BR></td>");
	filterInfoOutStr.append("<td class=filterDetailFont><i>Project:</i> "+projText+"<BR></td>");
	filterInfoOutStr.append("<td class=filterDetailFont><i>Instance:</i> "+instText+"<BR></td>");
	filterInfoOutStr.append("</tr>");
	filterInfoOutStr.append("</table>");
	filterInfoOutStr.append("</div>");
 }
 
 out.println(filterInfoOutStr.toString());
 
 %>
 </div>
  

