/*  Copyright 1983 by the Massachusetts Institute of Technology  */

/* DCtcp.h */

/*
#include <ip.h>
#include <timer.h>
*/

/* Definitions for Alto TCP translation */

typedef	long	seq_t;			/* sequence numbers */

typedef	union	seq_no	{
		seq_t	a;
		struct	{
			unsigned   l;
			unsigned   h;
		}	p;
};

struct	tcp	{			/* a tcp header */
	unshort	tc_srcp;		/* source port */
	unshort	tc_dstp;		/* dest port */
	seq_t	tc_seq;			/* sequence number */
	seq_t	tc_ack;			/* acknowledgement number */
	unsigned	tc_uu1 : 4;		/* unused */
	unsigned	tc_thl : 4;		/* tcp header length */
	unsigned	tc_fin : 1;		/* fin bit */
	unsigned	tc_syn : 1;		/* syn bit */
	unsigned	tc_rst : 1;		/* reset bit */
	unsigned	tc_psh : 1;		/* push bit */
	unsigned	tc_fack : 1;		/* ack valid */
	unsigned	tc_furg : 1;		/* urgent ptr. valid */
	unsigned	tc_uu2 : 2;		/* unused */
	unshort	tc_win;			/* window */
	unshort	tc_cksum;		/* checksum */
	unshort	tc_urg;			/* urgent pointer */
	};

/* TCP psuedo-header structure, used for checksumming */
struct	tcpph	{			/* psuedo-header */
	in_name	tp_src;			/* source addr */
	in_name	tp_dst;			/* dest addr */
	char	tp_zero;		/* always 0 */
	char	tp_pro;			/* protocol */
	int	tp_len;			/* length */
	};


#define	SEQ_GT(a, b)	(((a) - (b)) > 0)
#define	SEQ_GE(a, b)	(((a) - (b) >= 0)
#define	SEQ_EQ(a, b)	((a) == (b))
#define	SEQ_NE(a, b)	((a) != (b))
#define	SEQ_LE(a, b)	(((a) - (b)) <= 0)
#define	SEQ_LT(a, b)	(((a) - (b)) < 0)


#define	TCPPROT		6		/* tcp protocol number */
#define TCPMAXWIND	4096		/* maximum tcp window that this 
					   implemnetation supports */
#define	TCPSIZE		sizeof(struct tcp)

/* tcp connection states */
/* CLOSED,LISTEN,SYNSENT,ESTAB,TIMEWAIT same as in tcp spec */
/* The numbering here is important, since this test:  conn_state >= SIMUL
 * is used to determine if a FIN has been seen */
#define CLOSED		0	/* nothing has happenned             */
#define	LISTEN		1	/* passive open listen state */
#define SYNSENT		2	/* connection requested              */
#define SYNRCVD		3
#define ESTAB		4	/* connection established            */
#define FINSENT		5	/* local user wishes to close        */
				/* same as FIN-WAIT-1 in tcp spec    */
#define FINACKED	6	/* local user's close request acked  */
				/* same as FIN-WAIT-2 in tcp spec    */
#define SIMUL		7	/* local user and foreign host wish to close*/
				/* same as CLOSING in tcp spec       */
#define FINRCVD		8 	/* foreign host wishes to close      */
				/* same as CLOSE-WAIT in tcp spec    */
#define R_AND_S		9 	/* frgn close req rcvd, local close req sent*/
				/* same as LAST-ACK in tcp spec      */
#define TIMEWAIT	10	/* last ack is being sent            */

#define NOT_YET(a, b)	((a) < (b))

