<?php
// ! Support file only, run AjaxTable.html instead !
// This file is used as both Data_Url and Upload_Url
// Generates data for TreeGrid when no data received or saves received changes to database
// Single file, without using TreeGridFramework.php

// --- Database switching ---
require_once("IncDbTxt.php");                 // Routines to connect to database via text file database
$db = new Database("Database");               // Database in folder "Database"

header("Content-Type: text/xml; charset=utf-8"); 

// --- Generating layout ---
$rs = $db->Query("SELECT MIN(Week),MAX(Week) FROM TableData");
$min = floor($rs->Get(0));
$max = floor($rs->Get(1));
$Cols=""; $CSum=""; $DRes=""; $DDef="";

for($i=$min;$i<$max;$i++){
   $Week = "W" . $i;
   $Cols = $Cols . "<C Name='" . $Week . "' Type='Float'/>";   // Column definitions
   if($CSum!="") $CSum .= "+";
   $CSum = $CSum . $Week;                               // Right fixed result column formula
   $DRes = $DRes . $Week . "Formula='sum()' ";          // Tree result row formulas
   $DDef = $DDef . $Week . "='0' ";                     // Default values for data rows
   }         
// --------------------------------------------------------------------------
?><Grid>
   <Cfg id='ResourceGrid' MainCol='Project' MaxHeight='1' ShowDeleted="0" DateStrings='1' 
      IdNames='Project' AppendId='1' FullId='1' IdChars='0123456789' NumberId='1' LastId='1' IdCompare='4'/>
   <LeftCols>
      <C Name='id' CanEdit='0'/>
      <C Name='Project' Width='250' Type='Text'/>
   </LeftCols>
   <Cols><?php echo $Cols;?>
   </Cols>
   <RightCols>
      <C Name='Sum' Width='50' Type='Float' Formula='<?php echo $CSum;?>'/>
   </RightCols>
   <Def>
      <D Name='R' Project='New resource' CDef='' <?php echo $DDef;?>/>
      <D Name='Node' Project='New project' CDef='R' Calculated='1' SumFormula='sum()' <?php echo $DRes;?> ProjectHtmlPrefix='&lt;B>' ProjectHtmlPostfix='&lt;/B>'/>
   </Def>
   <Header CDef='Node' id='id (debug)' Project='Project / resource'/>
   <Foot>
      <I Kind='User' RelHeight='100' Class='GFillRow'/>
      <I Def='Node' Project='Total results' ProjectCanEdit='0'/>
   </Foot>
</Grid>