(*--------------------------------------------------------------------------*)
(*                   PowTen --- Calculate power of ten                      *)
(*--------------------------------------------------------------------------*)

FUNCTION PowTen( Power : INTEGER ) : REAL;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Function:  PowTen                                                    *)
(*                                                                          *)
(*     Purpose:   Calculates power of ten (integer powers only)             *)
(*                                                                          *)
(*     Calling Sequence:                                                    *)
(*                                                                          *)
(*        Powval := PowTen( Power: INTEGER ) : REAL;                        *)
(*                                                                          *)
(*           Power  --- power of ten desired (must be integer)              *)
(*                                                                          *)
(*           Powval --- resultant power of ten value                        *)
(*                                                                          *)
(*     Calls:  None                                                         *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   Temp   : REAL;
   I      : INTEGER;
   AbsPow : INTEGER;
   X      : REAL;

BEGIN (* PowTen *)

   X     := 10.0;

   IF Power < 0 THEN
      BEGIN
         Power := -Power;
         X     := 0.1;
      END;

   Temp := 1.0;

   WHILE( Power > 0 ) DO
      BEGIN

         WHILE ( NOT ODD( Power ) ) DO
            BEGIN
               Power := Power DIV 2;
               X     := X * X;
            END;

         Power := Power - 1;
         Temp  := Temp  * X;

      END;

   PowTen := Temp;

END   (* PowTen *);

