Program Illustrating_the_Toolkit;
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{        This is the main demonstration program in Technojocks Turbo         }
{        Toolkit. The compiled version is in DemoTTT.Exe.                    }
{                                                                            }
{        Please distribute the toolkit to anyone and everyone -- but         }
{        all the files must be distributed together and they should          }
{        not be altered. Enough Crap!                                        }
{                                                                            }
{              Bitches, gripes, thanks, kisses, donations to                 }
{                                                                            }
{                        Bob Ainsbury,                                       }
{                        Technojock,                                         }
{                        P.O. Box 2197,                                      }
{                        Houston TX 77252                                    }
{                                                                            }
{                "In the software business since Tuesday"                    }
{                                                                            }
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Uses CRT, FastTTT, DOS, WinTTT, KeyTTT, MenuTTT, IOTTT, PullTTT, DirTTT, MiscTTT;
var
   Main_Choice,Choice,Error : integer;
   M1 : Menu_record;
   Ch : char;
Const
   Author = 'Bob Ainsbury, Technojock';

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{          T H E     M A I N    M E N U    P R O C E D U R E S                }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Procedure Define_Menu1;
begin
    With M1 do
    begin
        Heading1 := 'TechnoJocks Turbo Toolkit';
        Heading2 := 'Main Menu';
        Topic[1] := '   The Toolkit explained';
        Topic[2] := '   FastTTT Unit';
        Topic[3] := '   WinTTT Unit';
        Topic[4] := '   Menu Procedures';
        Topic[5] := '   IOTTT Unit';
        Topic[6] := '   DirTTT Unit';
        Topic[7] := '   Print documentation';
        Topic[8] := '   Toolkit Unit Summary';
        Topic[9] := '   Quit to DOS';
        TotalPicks := 9;
        PicksPerLine := 1;            {one column of choices}
        Addprefix := 3;               {add function key prefixes}
        TopleftXY[1] := 0;            {system will center menu}
        TopleftXY[2] := 3;            {Y coordinate}
        Boxtype := 5;                 {fancy box}
        If BaseOfScreen = $B800 then
        begin
            Colors[1] := white;           {hi forground}
            Colors[2] := red;            {hi background}
            Colors[3] := lightgray;             {lo foreground}
            Colors[4] := blue;       {lo background}
            Colors[5] := lightcyan;            {box color}
        end
        else
        begin
            Colors[1] := white;           {hi forground}
            Colors[2] := black;            {hi background}
            Colors[3] := black;             {lo foreground}
            Colors[4] := lightgray;       {lo background}
            Colors[5] := white;            {box color}
        end;
        AllowEsc := false;            {inactivate the escape key}
        Margins := 5;
end;  {with M1 do}
end; {Define_Menu1}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                              O P T I O N      1                             }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Procedure Toolkit_Explained;
const
X1 = 1;
Y1 = 1;
X2 = 80;
Y2 = 24;
var
C1,C2,C3 : byte;
begin
    If BaseOfScreen = $B800 then
    begin
        C1 := Lightgreen;
        C2 := black;
        C3 := yellow;
    end
    else
    begin
        C1 := white;
        C2 := black;
        C3 := white;
    end;
    Savescreen(1);
    FBox(X1,Y1,X2,Y2,C1,C2,4);
    OffCursor;
    WriteCenter(Y1,C1,C2,' THE TOOLKIT EXPLAINED ');
    WriteAT(X1+3,Y1+2,C3,C2,
    'TechnoJocks Turbo Toolkit is a collection of procedures and functions');
    WriteAT(X1+3,Y1+3,C3,C2,
    'for Turbo Pascal programmers. It will reduce the time taken to write');
    WriteAT(X1+3,Y1+4,C3,C2,
    'applications and is designed for novice and expert programmer alike.');
    WriteAT(X1+3,Y1+6,C3,C2,
    'The real purpose of the Toolkit is to provide easy-to-implement procedures');
    WriteAT(X1+3,Y1+7,C3,C2,
    'that free the programmer from the more tedious and repetitive programming');
    WriteAT(X1+3,Y1+8,C3,C2,
    'chores, such as windows, menus, user input, string formatting, directory');
    WriteAT(X1+3,Y1+9,C3,C2,
    'listings, mouse support etc.');
    WriteAT(X1+3,Y1+11,C3,C2,
   'The Toolkit is being used by many programmers and corporations throughout');
   WriteAT(X1+3,Y1+12,C3,C2,
   'the world. There are TechnoJock Turboholics in Norway, U.K., Japan, Africa');
   WriteAT(X1+3,Y1+13,C3,C2,
   'and all over the USA. Bob is a member of the Association of ShareWare');
   WriteAT(X1+3,Y1+14,C3,C2,
   'Professionals.');
   WriteAT(X1+3,Y1+16,C3,C2,
   'If you use the Toolkit please register your copy and support it''s further');
   WriteAT(X1+3,Y1+17,C3,C2,
   'development. Full registration is $29.95 and this includes 150 page typeset');
      WriteAT(X1+3,Y1+18,C3,C2,
   'Manual - full time students may register for $9.95');

WriteAT(X1+17,Y1+20,C1,C2,
   'Enjoy.....');
   WriteAT(X1+28,Y1+22,white,C2,
   'Bob Ainsbury, TechnoJock, Houston.');
   WriteAT(X2-20,Y2,C1,C2,' press any key ... ');
   Ch := GetKey;
   RestoreScreen(1);
   DisposeScreen(1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                              O P T I O N      2                             }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Procedure Explain_Fastwrite;
const
X1 = 1;
Y1 = 1;
X2 = 80;
Y2 = 25;
C1 = white;
C2 = yellow;
C3 = black;
Max_Picks = 14;

      Procedure MainText;
      begin
      Box(X1,Y1,X2,Y2,C2,C3,1);
      Horizline(3,77,19,red,black,1);
      WriteCenter(Y1+1,C2,C3,'FastTTT Unit');
      WriteAT(X1+5,Y1+3,C1,C3,
      'The FastTTT unit contains a host of procedures for updating the');
      WriteAT(X1+5,Y1+4,C1,C3,
      'screen, at speeds exceeding an Izuzu.');
      WriteAT(X1+5,Y1+6,C1,C3,
      'The latest version of Turbo Pascal has some significantly improved');
      WriteAT(X1+5,Y1+7,C1,C3,
      'screen writing procedures. But the FastTTT unit is much faster still,');
      WriteAT(X1+5,Y1+8,C1,C3,
      'especially on systems that are prone to snow.');
      WriteAT(X1+5,Y1+10,C1,C3,
      'The procedures are designed to work on IBM systems and 100% compatibles.');
      WriteAT(X1+5,Y1+11,C1,C3,
      'Listed below are some of the main Fastwrit procedures, move the cursor');
      WriteAT(X1+5,Y1+12,C1,C3,
      'to see a fuller description. Press [End] or [Esc] to return to the menu.');
      end;  {sub proc Main_text}

      Procedure WriteOption(Pick,F,B:integer);
      const
      Lineone = 15;
      LeftTab = 6;
      Tab = 18;
      begin
      Case Pick of
      1 : WriteAT(LeftTab,Lineone,F,B,             '    Box          ');
      2 : WriteAT(LeftTab+Tab,Lineone,F,B,         '    HorizLine    ');
      3 : WriteAT(LeftTab+2*Tab,LineOne,F,B,       '    VertLine     ');
      4 : WriteAT(LeftTab+3*Tab,LineOne,F,B,       '    WriteAT      ');
      5 : WriteAT(LeftTab,LineOne+1,F,B,           '    ClearText    ');
      6 : WriteAT(LeftTab+Tab,LineOne+1,F,B,       '    WriteCenter  ');
      7 : WriteAT(LeftTab+2*Tab,LineOne+1,F,B,     '    WriteBetween ');
      8 : WriteAT(LeftTab+3*Tab,LineOne+1,F,B,     '    WriteVert    ');
      9 : WriteAT(LeftTab,Lineone+2,F,B,           '    FBox         ');
      10: WriteAt(LeftTab+tab,LineOne+2,F,B,       '    GrowFBox     ');
      11: WriteAt(LeftTab+2*tab,LineOne+2,F,B,     '    ClearLine    ');
      12: WriteAt(LeftTab+3*Tab,LineOne+2,F,B,     '    Attr         ');
      13: WriteAT(LeftTab,Lineone+3,F,B,           '    FastWrite    ');
      14: WriteAt(LeftTab+tab,LineOne+3,F,B,       '    PlainWrite   ');
      end; {case}
      end; {WriteOption}

      Procedure Hilite(Pick:integer);
      begin
      WriteOption(Pick,White,red);
      end;   {HiLite}

      Procedure LoLite(Pick:integer);
      begin
      WriteOption(Pick,Lightgray,C3);
      end;   {LoLite}

      Procedure DisplayDescription(Pick : integer);
      const
      X = 7;
      Y = 20;
      C = yellow;
      begin
      case Pick of
      1 : begin
           WriteAT(X,Y,C,black,  'Syntax :  Box(X1,Y1,X2,Y2,F,B,boxtype : integer);                   ');
           WriteAT(X,Y+2,C,black,'Purpose : Draws a rectangular box on the screen in foreground color ');
           WriteAT(X,Y+3,C,black,'          F and background color B. The boxtype indicates what line ');
           WriteAT(X,Y+4,C,black,'          type to use i.e. single, double or combined.              ');
          end;
      2 : begin
           WriteAT(X,Y,C,black,  'Syntax :  HorizLine(X1,X2,Y,F,B,LineType:integer);                  ');
           WriteAT(X,Y+2,C,black,'Purpose : Draws a horizontal line on the screen in foreground color ');
           WriteAT(X,Y+3,C,black,'          F and background color B. The linetype indicates what line');
           WriteAT(X,Y+4,C,black,'          type to use i.e. single or double.                        ');
          end;
      3 : begin
           WriteAT(X,Y,C,black,  'Syntax :  VertLine(X,Y1,Y2,F,B,LineType:integer);                   ');
           WriteAT(X,Y+2,C,black,'Purpose : Draws a vertical line on the screen in foreground color F ');
           WriteAT(X,Y+3,C,black,'          and background color B. The linetype indicates what line  ');
           WriteAT(X,Y+4,C,black,'          type to use i.e. single or double.                        ');
          end;
      4 : begin
           WriteAT(X,Y,C,black,  'Syntax :  WriteAT(X,Y,F,B:integer;ST:string80);                     ');
           WriteAT(X,Y+2,C,black,'Purpose : Writes the string St very quickly on the screen starting  ');
           WriteAT(X,Y+3,C,black,'          at (X,Y) in foreground color F and background color B. The');
           WriteAT(X,Y+4,C,black,'          string may be concatenated e.g. ''Techno''+''Jock''.          ');
          end;
      5 : begin
           WriteAT(X,Y,C,black,  'Syntax :  ClearText(X1,Y1,X2,Y2,F,B:integer);                       ');
           WriteAT(X,Y+2,C,black,'Purpose : Clears the characters for a rectangular area on the screen');
           WriteAT(X,Y+3,C,black,'          and displays background color B. The attribute for the    ');
           WriteAT(X,Y+4,C,black,'          foreground is set to F. Unaffected by Window setting.     ');
          end;
      6 : begin
           WriteAT(X,Y,C,black,  'Syntax :  WriteCenter(Lineno,F,B:integer;ST:string80);              ');
           WriteAT(X,Y+2,C,black,'Purpose : Writes the string ST very quickly on the screen in the    ');
           WriteAT(X,Y+3,C,black,'          center of line Lineno in foreground color F and back-     ');
           WriteAT(X,Y+4,C,black,'          ground color B. The string may be concatenated.           ');
          end;
      7 : begin
           WriteAT(X,Y,C,black,  'Syntax :  WriteBetween(X1,X2,Y,F,B:integer;ST:string80);            ');
           WriteAT(X,Y+2,C,black,'Purpose : Writes the string ST very quickly on the screen centered  ');
           WriteAT(X,Y+3,C,black,'          between X1 and X2 on line Y, in foreground F and back-    ');
           WriteAT(X,Y+4,C,black,'          ground color B. The string may be concatenated.           ');
          end;
      8 : begin
           WriteAT(X,Y,C,black,  'Syntax :  WriteVert(X,Y,F,B;ST:string80);                           ');
           WriteAT(X,Y+2,C,black,'Purpose : Writes the string ST vertically on the screen starting at ');
           WriteAT(X,Y+3,C,black,'          coordinate (X,Y) and continuing down the screen, in fore- ');
           WriteAT(X,Y+4,C,black,'          ground color F and background color B.                    ');
          end;
      9 : begin
           WriteAT(X,Y,C,black,  'Syntax :  FBox(X1,Y1,X2,Y2,F,B,Boxtype:Integer);                 ');
           WriteAT(X,Y+2,C,black,'Purpose : Draws a rectangular box on the screen in foreground color');
           WriteAT(X,Y+3,C,black,'          F and background color B. The boxtype indicates the line');
           WriteAT(X,Y+4,C,black,'          style. This is similar to Box except the box is cleared.');
          end;
      10: begin
           WriteAT(X,Y,C,black,  'Syntax :  GrowFBox(X1,Y1,X2,Y2,F,B,Boxtype:Integer);             ');
           WriteAT(X,Y+2,C,black,'Purpose : Draws a rectangular box on the screen in foreground color');
           WriteAT(X,Y+3,C,black,'          F and background color B. The boxtype indicates the line');
           WriteAT(X,Y+4,C,black,'          style. This is similar to FBox except the box explodes.');
          end;
      11: begin
           WriteAT(X,Y,C,black,  'Syntax :  ClearLine(Y,F,B:integer);                               ');
           WriteAT(X,Y+2,C,black,'Purpose : All text on screen line Y is cleared. The actual display  ');
           WriteAT(X,Y+3,C,black,'          color of the line will be set to B.                       ');
           WriteAT(X,Y+4,C,black,'                                                                    ');
          end;
      12: begin
           WriteAT(X,Y,C,black,  'Syntax :  Attr(F,B):byte;                                           ');
           WriteAT(X,Y+2,C,black,'Purpose : Combines the foreground color F with the background       ');
           WriteAT(X,Y+3,C,black,'          color B and returns the resulting attribute byte.         ');
           WriteAT(X,Y+4,C,black,'                                                                    ');
          end;
      13: begin
           WriteAT(X,Y,C,black,  'Syntax :  Fastwrite(X,Y,F,B : byte; Str : string);                  ');
           WriteAT(X,Y+2,C,black,'Purpose : This is the core procedure used by the others in the      ');
           WriteAT(X,Y+3,C,black,'          Toolkit. String Str is wriiten on the screen in foreground');
           WriteAT(X,Y+4,C,black,'          F & background B at location (X,Y) el quicko.             ');
          end;
      14: begin
           WriteAT(X,Y,C,black,  'Syntax :  PlainWrite(X,Y:byte; Str: string);                        ');
           WriteAT(X,Y+2,C,black,'Purpose : This is even quicker than FastWrite but it uses the       ');
           WriteAT(X,Y+3,C,black,'          default color attibute already assigned.                  ');
           WriteAT(X,Y+4,C,black,'                                                                    ');
          end;
      end; {case}
      end; {DisplayDescription}

      Procedure Keystroke;
      const
          CursorUp = #200;
          CursorDown = #208;
          CursorLeft = #203;
          CursorRight = #205;
          EndKey = #207;
      var
      Allover : boolean;
      I,CurrentPick : integer;
      begin
          Allover := false;
          CurrentPick := 1;
          For I := 1 to Max_Picks do
              LoLite(I);
          HiLite(CurrentPick);
          Repeat
              Ch := getkey;
              Case upcase(Ch) of
              CursorUp :      If CurrentPick > 4 then
                              begin
                                  LoLite(CurrentPick);
                                  CurrentPick := CurrentPick - 4;
                                  HiLite(CurrentPick);
                              end;
              CursorDown :    If CurrentPick <= Max_Picks - 4 then
                              begin
                                  LoLite(CurrentPick);
                                  CurrentPick := CurrentPick + 4;
                                  HiLite(CurrentPick);
                              end;
             ' ',
             CursorRight :   begin
                                 LoLite(CurrentPick);
                                 If CurrentPick < Max_Picks then
                                     CurrentPick := CurrentPick + 1
                                 else
                                     CurrentPick := 1;
                                 HiLite(CurrentPick);
                             end;
            CursorLeft :    begin
                                LoLite(CurrentPick);
                                If CurrentPick > 1 then
                                   CurrentPick := CurrentPick - 1
                                else
                                   CurrentPick := Max_Picks;
                                HiLite(CurrentPick);
                            end;
            #027,
            EndKey :        Allover := true;
            end; {case}
            DisplayDescription(CurrentPick);
      Until Allover;
      end;  {Keystroke}


begin       {Explain_Fastwrite}
    SaveScreen(1);
    Clrscr;
    OffCursor;
    MainText;
    DisplayDescription(1);
    Keystroke;
    RestoreScreen(1);
    DisposeScreen(1);
end;  {proc Explain_Fastwrite}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                              O P T I O N      3                             }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Procedure Explain_Windows;
var
   I : integer;
   c1,c2,c3,c4,c5,c6: byte;

begin
    If BaseOfScreen = $B800 then
    begin
        C1 := yellow;
        C2 := green;
        C3 := white;
        C4 := white;
        C5 := red;
        C6 := magenta;
    end
    else
    begin
        C1 := black;
        C2 := lightgray;
        C3 := white;
        C4 := white;
        C5 := black;
        C6 := black;
    end;
    Savescreen(1);
    OffCursor;
    ClrScr;
    MkWin(1,1,35,14,c1,c2,2);
    WriteBetween(1,35,2,C1,c2,'Window.TTT');
    WriteAt(3,4,c3,c2,'The Window procedures provide');
    WriteAT(3,5,c3,c2,'tools for easily writing flash');
    WriteAT(3,6,c3,c2,'up window routines. ');
    WriteAT(3,8,c3,c2,'They also include procedures');
    WriteAT(3,9,c3,c2,'for saving and restoring screen');
    WriteAT(3,10,c3,c2,'images.');
    WriteAT(3,13,c3,c2,'... press any key.');
    DelayKey(4000);
    Mkwin(34,7,66,20,c4,c5,3);
    WriteAT(36,9,c4,c5, 'The windows can be placed any');
    WriteAT(36,10,c4,c5,'where on the screen and both');
    WriteAT(36,11,c4,c5,'the border style and colors ');
    WriteAT(36,12,c4,c5,'can be easily altered.');
    DelayKey(3000);
    Mkwin(20,13,68,25,c4,c6,1);
    WriteAT(22,15,c4,c6,'The WinTTT unit includes a host of Windowing ');
    WriteAT(22,16,c4,c6,'procedures, and a collection of fancy screen ');
    WriteAT(22,17,c4,c6,'restoring and sliding procedures.            ');
    WriteAT(22,19,c4,c6,'There are three smaller demo programs on the ');
    WriteAT(22,20,c4,c6,'distribution disk that further illustrate the');
    WriteAT(22,21,c4,c6,'power of this unit: WinDem, ScrnDem & SaveDem');
    WriteAT(22,22,c4,c6,'.pas.                                       ');
    WriteAT(22,24,c4,c6,'Press any key to see some screen manipulation');
    Ch := getkey;
    Rmwin;
    Delay(300);
    Rmwin;
    Delay(300);
    Rmwin;
    Delay(300);
    Rmwin;
    SlideRestoreScreen(1,left);
    SlideRestoreScreen(1,up);
    SlideRestoreScreen(1,right);
    DisposeScreen(1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                              O P T I O N      4                             }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Procedure PullDemo;
var
TheMenu : MenuDesc;   {Array holding the menu definitions}

       Procedure Define_Demo_Menu;
       begin
           Fillchar(Themenu,sizeof(Themenu),#0);
           TheMenu[1] := '\File';      {menu definition for pull down menu}
           TheMenu[2] := 'Load        ';
           TheMenu[3] := 'New         ';
           TheMenu[4] := 'Save        ';
           TheMenu[5] := 'Write to    ';
           TheMenu[6] := 'Directory   ';
           TheMenu[7] := 'Change dir  ';
           TheMenu[8] := 'OS shell    ';
           TheMenu[9] := 'Quit        ';

           TheMenu[10] :=  '\Edit ';

           TheMenu[11] :=  '\Run ';

           TheMenu[12] := '\Compile     ';
           TheMenu[13] := 'Make         ';
           TheMenu[14] := 'Build        ';
           TheMenu[15] := 'Destination  ';
           TheMenu[16] := 'Find Error   ';
           TheMenu[17] := 'Primary file ';
           TheMenu[18] := 'Find         ';
           TheMenu[19] := 'find/Replace ';
           TheMenu[20] := 'find Next    ';
           TheMenu[21] := 'Get Info     ';

           TheMenu[22] := '\Options';
           TheMenu[23] := 'Compiler    ';
           TheMenu[24] := 'Environment ';
           TheMenu[25] := 'Directories ';
           TheMenu[26] := 'Parameters  ';
           TheMenu[27] := 'Load Options';
           TheMenu[28] := 'Save Options';
           TheMenu[29] := '\\';

      end; {Proc Define demo menu}

      Procedure Fill_Screen_With_Junk;
      var I,J : integer;
      begin
          ClrScr;
          Fillscreen(1,1,80,23,15,0,chr(001));
          Writecenter(15,lightgray,black,' Use the cursor keys... recognize the menu? ');
      end;

var
 Major,Minor : byte;
 Ch : char;

begin
    Define_Demo_Menu;
    Fill_Screen_With_Junk;
    Major := 1;
    Minor := 1;
    With PM do
    begin
        Style := 0;  {0 no border, 1 single border, 2 double border}
        TopX :=  1;
        TopY := 2;
        ScreenNo := 3;
        Gap :=  5;
        RemoveMenu := false;
    end; {With}
    Pull_Menu(TheMenu,Major,Minor);
    GotoXY(1,20);
    If Major = 0 then
       writeln('You escaped ')
    else
       writeln('You selected main menu ',Major,' and sub-topic ',Minor,' ');
    Writeln('The menu can also be displayed with single or double borders!');
    writeln;
    Writeln('Press any key to return to main menu.......');
    Ch := Readkey;
end;


Procedure Explain_Menu;
var
  P,code : integer;
  C1,C2,C3: byte;

    Procedure Instructions(Number:integer);
    begin
        P := 1;
        Case Number of
        1 : begin
                WriteAT(9,23,white,black,
                'This is a mock up of the Main menu but changed to two picks per line,');
                WriteAT(9,24,white,black,
                'and moved to the left. Play with the cursor and select an option.    ');
            end;
        2 : begin
                WriteAT(9,23,white,black,
                'Now the menu has been changed back to one pick per line and the      ');
                WriteAT(9,24,white,black,
                'prefix has changed to a letter. Press a letter or move & Enter.      ');
            end;
        3 : begin
                WriteAT(9,23,white,black,
                'Last one I promise! Now the prefix is a number and we''ve changed    ');
                WriteAT(9,24,white,black,
                'the colors. Select an option and press Enter.                        ');
            end;
    end; {case}
    end; {sub proc Instructions}

begin
    If BaseOfScreen = $B800 then
    begin
        C1 := lightred;
        C2 := red;
    end
    else
    begin
        C1 := lightgray;
        C2 := lightgray;
    end;
    Savescreen(1);
    Clrscr;
    OffCursor;
    Box(1,1,80,25,C1,black,1);
    WriteCenter(3,c1,black,'The MenuTTT Unit');
    WriteAT(3,5,white,black,
    'The Toolkit contains two menu units: one for pull down menus and the other ');
    WriteAT(3,6,white,black,
    'for single boxed menus. Menus area big chore and seem to be something we all');
    WriteAT(3,7,white,black,
    'leave to the end of the development. BUT a friendly and consistent interface');
    WriteAT(3,8,white,black,
    'is fundamental to the acceptance of a program. Menu.TTT is a must.');
    WriteAT(3,10,white,black,
    'The main menu of this demo program is constructed using MenuTTT. All you have');
    WriteAT(3,11,white,black,
    'to do is define a menu record and call the procedure DisplayMenu -- thats    ');
    WriteAT(3,12,white,black,
    'right, there is only one procedure.');
    WriteAT(3,14,white,black,
    'In the menu record you detail the following : a heading, the number of picks,');
    WriteAT(3,15,white,black,
    'the menu text for each pick, the number of picks on a line (typically 1),    ');
    WriteAT(3,16,white,black,
    'the box location and the desired colors, you also indicate whether the Esc   ');
    WriteAT(3,17,white,black,
    'key is enabled. That is all there is to it.');
    WriteAT(3,19,white,black,
    'The menu procedure includes extensive error checking and wherever possible   ');
    WriteAT(3,20,white,black,
    'if an invalid value is found the system will correct. For example if the box ');
    WriteAT(3,21,white,black,
    'will not fit on the screen the procedure will shift it so that it does fit.  ');
    WriteAt(3,23,c1,black,
   'To illustrate how easy it is to modify and change menus, lets display the ');
   WriteAt(3,24,c1,black,
   'main menu a few different ways by simply changing the menu record.        ');
   WriteAt(60,25,c1,black,' press any key .... ');
   Ch := getkey;
   Clrscr;
   Offcursor;
   Box(1,22,80,25,c1,black,1);
   With M1 do
   begin
       PicksPerLine := 2;
       TopleftXY[1] := 1;
   end;
   Instructions(1);
   Displaymenu(M1,false,P,code);
   With M1 do
   begin
       PicksPerLine := 1;
       TopleftXY[1] := 55;
       TopleftXY[2] := 6;
       Addprefix := 2;
   end;
   Instructions(2);
   Displaymenu(M1,false,P,code);
   With M1 do
   begin
       TopleftXY[1] := 15;
       TopleftXY[2] := 5;
       Addprefix := 1;
       If baseOfSCreen = $B800 then
       begin
           Colors[1] := yellow;
           Colors[2] := green;
           Colors[3] := lightgreen;
           Colors[4] := red;
           Colors[5] := white;
       end;
   end;
   Instructions(3);
   Displaymenu(M1,false,P,code);
   Mkwin(5,10,70,17,white,c2,2);
   Offcursor;
   WriteAT(15,12,white,c2,'All these modifications were effected by making');
   WriteAT(15,13,white,c2,'simple changes to the menu record.             ');
   WriteAT(15,15,white,c2,'Now lets check out the pull menu option.       ');
   WriteAT(50,17,white,c2,' press any key .... ');
   Define_Menu1;           {set it all back to normal}
   Ch := getkey;
   Rmwin;
   PullDemo;
   RestoreScreen(1);
   DisposeScreen(1);
   Offcursor;
end;
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                              O P T I O N      5                             }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{$F+}
Procedure Help_EditKeys(Ch:Char; Fieldid : integer;var ReturnStr: string);
var C1,C2,c3 : byte;
begin
    If BaseOfScreen = $b800 then
    begin
        C1 := lightcyan;
        C2 := white;
        C3 := blue;
    end
    else
    begin
        C1 := white;
        C2 := black;
        C3 := lightgray;
    end;
    If Ch <> #187 then exit;
    Mkwin(40,1,80,25,C1,c3,2);
    WriteBetween(40,80,2,C1,c3,'IO Editing Keys');
    WriteAT(42,3,c2,c3,'The operative edit keys are defined');
    WriteAT(42,4,c2,c3,'in IOTTT.pas. They may be modified to');
    WriteAT(42,5,c2,c3,'suit your needs. The defaults are:  ');
    WriteAT(42,7,c2,c3, 'Move Up      '+chr(024));
    WriteAT(42,8,c2,c3, 'Move Down    '+chr(025));
    WriteAT(42,9,c2,c3,'Move Right   Ctrl -'+chr(016)+', Tab or Enter');
    WriteAT(42,10,c2,c3,'Move Left    Ctrl '+chr(017)+'- or ShiftTab');
    WriteAT(42,12,c2,c3,'Insert       Press [Ins] to toggle');
    WriteAT(42,14,c2,c3,'Del Char     [Del]  or  [Backspace]');
    WriteAT(42,15,c2,c3,'Del Field    Alt-D');
    WriteAT(42,16,c2,c3,'Del Global   Alt-E');
    WriteAT(42,18,c2,c3,'Update       [End]');
    WriteAT(42,19,c2,c3,'Abort        [Esc]');
    WriteAT(42,21,c2,c3,'Note the abort key can be disabled,');
    WriteAT(42,22,c2,c3,'as it is in this example. Just press');
    WriteAT(42,23,c2,c3,'[End] to finish the example.');
    Ch := getkey;
    Rmwin;
end;
{$F-}

Procedure Explain_IO;

     Procedure Display_Text;
     var C1,C2 : byte;
     begin
         If BaseOfScreen = $b800 then
         begin
             C1 := yellow;
             C2 := lightgreen;
         end
         else
         begin
             C1 := lightgray;
             C2 := white;
         end;
         Clrscr;
         Box(1,1,80,11,C1,black,3);
  WriteCenter(2,C1,black,'The IOTTT Unit');
  WriteAT(3,4,c2,black,
  'One of the (few) short comings of Turbo Pascal is its very limited support');
  WriteAT(3,5,c2,black,
  'for screen input that gives the user a chance to move around the screen and');
  WriteAT(3,6,c2,black,
  'and edit the input. Thats why I developed the IOTTT unit.');
  WriteAT(3,8,c2,black,
  'These IO procedures allow you to display input fields with format controls');
  WriteAT(3,9,c2,black,
  'e.g. all capitals or only numbers. There are many features to the Kit. The');
  WriteAT(3,10,c2,black,
  'example below illustrates some of the power of this easy to use Kit.');
  end;

  Procedure IO_Example;
  var
  s1,s2,s3,s4,s5,s6:string;
  retcode : integer;
  begin
  Box(3,13,78,25,white,black,1);
  Horizline(4,77,15,white,black,1);
  Textcolor(white);
  GotoXY(3,15);write(chr(195));
  GotoXY(78,15);write(chr(180));
  Textcolor(lightred);
  GotoXY(20,14);write(chr(004));
  GotoXY(57,14);write(chr(004));
  GotoXY(22,14);write(chr(004));
  GotoXY(59,14);write(chr(004));
  Textcolor(yellow);
  GotoXY(21,14);write(chr(004));
  GotoXY(58,14);write(chr(004));
  Offcursor;
  WriteCenter(14,Lightgray,black,'Technojocks Inventory Control');
  WriteAt(22,17,white,black,'Catalogue/Part Number');
  WriteAT(10,19,white,black,'Description');
  WriteAT(10,21,white,black,'Quantity');
  WriteAT(50,21,white,black,'Units');
  WriteAT(10,23,white,black,'Shelf');
  WriteAT(50,23,white,black,'Bin No.');
  WriteAT(66,16,white,black,'F1 for HELP');
  S1 := '';
  S2 := '';
  S3 := '';
  S4 := '';
  S5 := '';
  S6 := '0001';
  IO_Setfields(6);
  IO_Soundbeeper(false);
  IO_Allowesc(true);
  IO_UserHook := @Help_Editkeys;
  IO_DefineStr(1,   6,2,6,2,    45,17,  S1,'(####-###)/ ##');
  IO_DefineStr(2,   1,3,1,3,    23,19,  S2,replicate(50,'*'));
  IO_DefineSTR(3,   2,4,2,4,    23,21,  S3,'#####');
  IO_DefineStr(4,   3,5,3,5,    60,21,  S4,'!!!!!!!!!!!!!');
  IO_DefineStr(5,   4,6,4,6,    23,23,  S5,'@@ / @');
  IO_DefineStr(6,   5,1,5,1,    60,23,  S6,'####');
  IO_DefineMsg(1,   13,25, 'Enter the TTT catalogue number (letters not accepted)');
  IO_DefineMsg(2,   15,25, 'Enter the item description from the Purchase Order');
  IO_DefineMsg(4,   25,25, '(note: Units converted to capitals)');
  IO_DefineMsg(5,   20,25, 'Only letters and punctuation chars allowed');
  IO_DefineMsg(6,   20,25, 'Check details and press [End] to update');
  OnCursor;
  IO_Edit(Retcode);
  OffCursor;
  IO_ResetFields;
  end;
begin
SaveScreen(1);
Display_Text;
IO_Example;
RestoreScreen(1);
DisposeScreen(1);
end;
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                              O P T I O N      6                             }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Procedure Explain_Dir;

Var
 StartPath, Path, Mask, Chosen_File : string;
 Ch : char;
 C1,C2,C3 : byte;
begin
    If BaseOfScreen = $b800 then
    begin
        C1 := Yellow;
        C2 := lightgray;
        C3 := blue;
    end
    else
    begin
        C1 := white;
        C2 := black;
        C3 := lightgray;
    end;
    SaveScreen(1);
    ClrScr;
    FBox(1,1,80,10,C1,c3,2);
    WriteCenter(2,C1,C3,'The DirTTT Unit');
    WriteAT(5,3,c2,c3,
    ' The DirTTT unit provides a single procedure for displaying a directory');
    WriteAT(5,4,c2,c3,
    ' in a Sidekick-like dialogue box. You can optionally display the file');
    WriteAT(5,5,c2,c3,
    ' details of the currently selected field, and allow the users to change');
    WriteAT(5,6,c2,c3,
    ' directories. Only files matching a specified file mask will be shown.');
    WriteAT(5,8,c2,c3,
    ' In the example below ''*.*'' is the mask, use the cursor keys to change');
    WriteAT(5,9,c2,c3,
    ' selections, and select a directory to change to that directory.');

    GetDir(0,StartPath);
    Path := StartPath;
    Mask := '*.*';
    With D do
    begin
        Cols := 5;
        Rows := 8;
        TopY := 13;
        AllowEsc := false;
    end;
    Chosen_File := Display_Directory(Path,Mask);
    GotoXy(1,25);
    If Chosen_File = #027 then
        Write('You escaped')
    else
        Write('You selected file ',Chosen_File);
   Write('   Press any key to return to the menu');
   {$I-}
   ChDir(StartPath);
   {$I+}
   Ch := Getkey;
   RestoreScreen(1);
   DisposeScreen(1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                              O P T I O N      7                             }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Procedure Printout;
begin
Mkwin(10,8,70,18,white,red,1);
Offcursor;
WriteAT(15,10,white,red,'The documentation is compressed in a file Manual.exe.');
WriteAT(15,11,white,red,'Execute this file and the file Manual.TTT will self  ');
WriteAT(15,12,white,red,'extract. The manual contains no formatting chars, &');
WriteAT(15,13,white,red,'is 80 characters wide by 66 lines per page.');
WriteAT(15,15,white,red,'At the DOS prompt type Print Manual.TTT. Be warned');
WriteAT(15,16,white,red,'the documentation is good but it''s more than 100 pages.');
WriteAT(50,18,white,red,' press any key .... ');
Ch := getkey;
Rmwin;
end;
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                              O P T I O N      8                             }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
Procedure Unit_Summary;
const
X1 = 40;
Y1 = 5;
X2 = 80;
Y2 = 25;
var
C1,C2,C3,C4 : byte;



begin
    If BaseOfScreen = $b800 then
    begin
        C1 := white;
        C2 := lightgray;
        C3 := yellow;
        C4 := blue;
    end
    else
    begin
        C1 := white;
        C2 := black;
        C3 := white;
        C4 := lightgray;
    end;
    SaveScreen(1);
    Fbox(1,1,80,24,C1,C4,1);
    WriteCenter(2,C3,C4,'A Summary of the Toolkit Units');
    WriteAT(3,4,c3,c4,'FastTTT  ');
    WriteAT(12,4,c2,c4,'Ultra fast Screen writing routines including box drawing');
    WriteAT(3,6,c3,c4,'WinTTT  ');
    WriteAT(12,6,c2,c4,'Windowing routines together with screen moves, copies & saves');
    WriteAT(3,8,c3,c4,'MenuTTT  ');
    WriteAT(12,8,c2,c4,'Advanced, but easy to use, menu unit with auto-centering etc.');
    WriteAT(3,10,c3,c4,'KeyTTT  ');
    WriteAT(12,10,c2,c4,'Full keyboard control and a host of mouse related procedures');
    WriteAT(3,12,c3,c4,'IOTTT  ');
    WriteAT(12,12,c2,c4,'Form or full screen input procedues, with control of input');
    WriteAT(3,14,c3,c4,'StrngTTT');
    WriteAT(12,14,c2,c4,'Suite of fast string handling procs, including word manipulation');
    WriteAT(3,16,c3,c4,'PullTTT');
    WriteAT(12,16,c2,c4,'Easy to use procedure for displaying Pull down menus');
    WriteAT(3,18,c3,c4,'DirTTT');
    WriteAT(12,18,c2,c4,'Sidekick-like directory listing procedures');
    WriteAT(3,20,c3,c4,'ReadTTT');
    WriteAT(12,20,c2,c4,'Single line input control providing user with full editing');
    WriteAT(3,22,c3,c4,'MiscTTT');
    WriteAT(12,22,c2,c4,'A pot pourri of miscellaneous procedures and functions');
    WriteAT(50,23,c2,c4,'Press any key to continue....');
    Offcursor;
    Ch := getkey;
    SlideRestoreScreen(1,Up);
    DisposeScreen(1);
end;

Procedure Initialise;
begin
    Clrscr;
    Box(25,1,55,4,white,black,1);
    WriteBetween(25,55,2,lightgray,black,'Technojocks Turbo Toolkit');
    WriteBetween(25,55,3,lightgray,black,'V4.0');
    WriteCenter(6,white,black,'"In the software business since Tuesday"');
    WriteAT(5,8,white,black,'This program demonstrates the power of TechnoJocks Turbo Toolkit for');
    WriteAT(5,9,white,black,'Borlands Turbo Pascal v4.0 (IBM and compatibles).');
    WriteAT(5,11,white,black,'The Toolkit is a professional ShareWare product and if you use the');
    WriteAt(5,12,white,black,'Toolkit you must register it. Included in the source code is a file');
    WriteAt(5,13,white,black,'Register.doc, print this file and submit it together with registration');
    WriteAt(5,14,white,black,'fee of:');
    WriteAt(10,16,white,black,' $29.95 for Full registration with 150 page typeset manual');
    WriteAt(10,17,white,black,' $9.95  for full time Student registration');
    WriteAt(5,19,white,black,'to:');
    WriteAt(30,21,white,black,'Bob Ainsbury');
    WriteAt(30,22,white,black,'Technojock');
    WriteAt(30,23,white,black,'P.O. Box 2197');
    WriteAT(30,24,white,black,'Houston, TX 77252');
    WriteAT(55,25,white+blink,black,'Press any key to continue');
    Ch := getkey;
    Clrscr;
    FillScreen(1,1,80,24,white,black,chr(176));
    OffCursor;
    WriteCenter(25,lightgray,black,'Technojocks Turbo Toolkit v4.0 ');
    Main_Choice := 1;
    Define_Menu1;
end;

Procedure Finish;
begin
 ClrScr;
 OnCursor;
 write('TechnoJocks Turbo Toolkit');
 Halt;
end;

begin     {main program}
Initialise;
repeat
     DisplayMenu(M1,false,Main_choice,Error);
     Case Main_Choice of
     1 :Toolkit_Explained;
     2 :Explain_Fastwrite;
     3 :Explain_Windows;
     4 :Explain_Menu;
     5 :Explain_IO;
     6 :Explain_Dir;
     7 :PrintOut;
     8 :Unit_Summary;
     9 :Finish;
     end;  {case}
until true = false;  {a very very very long time !}
end.

