#include <stdio.h>
#include <bios.h>
#include <dos.h>

void hwt_init(void);  /* In hwtimer.asm */
void hwt_fin(void);
unsigned long hw_time(void);

/* The PC timer0 counter is driven at 1.19318 MHz, period 0.8380965 us

   256*period = 214.5527 us  <<< This is hw_time()'s resolution

   65536*period = 54.925491ms, BIOS clock ticks at 18.206482 Hz */

#define HWT_TICK  0.2145527  /* ms per tick */

void main()
{
   int n, j, t;
   unsigned long tt,ltt, btd;
   float ft;

   hwt_init();  /* Hook timer interrupts */
   ltt = 0L;
   for (n = 0; n != 20; ++n) {
      printf("%4d: ", n);
      for (j = 0; j != 10; ++j) {
	 tt = hw_time();
	 ft = (float)(tt-ltt) * HWT_TICK;
	 ltt = tt;
	 printf("%7.1f", ft);
	 for (t = 0; t != 5000; ++t) btd = tt * 1234L;
	 }
      printf("\n");
      }
   hwt_fin();  /* Restore BIOS timer interrupt handling */
   }