(*  :Title:	LaPlace Transform Supporting Routines  *)

(*  :Authors:	Brian Evans, James McClellan  *)

(*  :Summary:	*)

(*  :Context:	SignalProcessing`Analog`LSupport`  *)

(*  :PackageVersion:  2.4	*)

(*
    :Copyright:	Copyright 1990-1991 by Brian L. Evans
		Georgia Tech Research Corporation

	Permission to use, copy, modify, and distribute this software
	and its documentation for any purpose and without fee is
	hereby granted, provided that the above copyright notice
	appear in all copies and that both that copyright notice and
	this permission notice appear in supporting documentation,
	and that the name of the Georgia Tech Research Corporation,
	Georgia Tech, or Georgia Institute of Technology not be used
	in advertising or publicity pertaining to distribution of the
	software without specific, written prior permission.  Georgia
	Tech makes no representations about the suitability of this
	software for any purpose.  It is provided "as is" without
	express or implied warranty.
 *)

(*  :History:	began --  February, 1990 (adapted from "ZSupport.m")	*)

(*  :Keywords:	Laplace transform, region of convergence	*)

(*  :Source:	*)

(*  :Warning:	*)

(*  :Mathematica Version:  1.2 or 2.0  *)

(*  :Limitation:  *)

(*  :Discussion:  *)

(*
    :Functions:	InvalidLTransformQ
		InvalidInvLTransformQ
		LForm
		LMultiDROC
		LTransformQ
		MakeLObject
 *)


If [ TrueQ[ $VersionNumber >= 2.0 ],
     Off[ General::spell ];
     Off[ General::spell1 ] ];


(*  B E G I N     P A C K A G E  *)

BeginPackage[ "SignalProcessing`Analog`LSupport`",
	      "SignalProcessing`Support`TransSupport`",
	      "SignalProcessing`Support`ROC`",
	      "SignalProcessing`Support`SigProc`",
	      "SignalProcessing`Support`SupCode`" ]


(*  U S A G E     I N F O R M A T I O N  *)

InvalidLTransformQ::usage =
	"InvalidLTransformQ[trans] returns True if the forward Laplace \
	transform rule base did not successfully finish the transform."

InvalidInvLTransformQ::usage =
	"InvalidInvLTransformQ[trans] returns True if the inverse Laplace \
	transform rule base did not successfully finish the transform."

LForm::usage =
	"LForm[transform] returns True if the transform is a valid \
	Laplace transform with a head of Transform or List."

LMultiDROC::usage =
	"LMultiDROC[old-Laplace-transform, new-Laplace-transform] \
	combines the transform functions, regions of convergence, and \
	the transform variables in order to produce a multidimensional \
	transform."

LTransformQ::usage =
	"LTransformQ[x] returns True if the datum x is of the form \
	LTransData[X, rm, rp, s], where X is the LaPlace transform, \
	rm is the Rminus component of the region of convergence, \
	rp is the Rplus component of the region of convergence, and \
	s is the variable(s) in the LaPlace transform."

MakeLObject::usage =
	"MakeLObject[l] and MakeLObject[l, slist] convert the LaPlace \
	transform information in list l into the standard object form \
	LTransData[x, Rminus[rm], Rplus[rp], LVariables[slist]]. \
	Here x is the LaPlace transform, rm is the lower bound on the \
	strip of convergence, rp is the upper bound on the strip of \
	convergence, and slist is the list of LaPlace variables used \
	in the transform."

(*  E N D     U S A G E     I N F O R M A T I O N  *)


Begin["`Private`"]


(*  E X T E N D     B U I L T - I N     R O U T I N E S  *)

(*  Denominator  *)
LTransData/: Denominator[LTransData[fun_, a__]] := Denominator[fun]

(*  Expand  *)
LTransData/: Expand[LTransData[fun_, a__]] := LTransData[Expand[fun], a]

(*  ExpandAll  *)
LTransData/: ExpandAll[LTransData[fun_, a__]] := LTransData[ExpandAll[fun], a]

(*  Factor  *)
LTransData/: Factor[LTransData[fun_, a__]] := LTransData[Factor[fun], a]

(*  Numerator  *)
LTransData/: Numerator[LTransData[fun_, a__]] := Numerator[fun]

(*  Simplify  *)
LTransData/: Simplify[LTransData[fun_, a__]] := LTransData[Simplify[fun], a] 

(*  Together  *)
LTransData/: Together[LTransData[fun_, a__]] := LTransData[Together[fun], a]


(*  R E G I O N     O F     C O N V E R G E N C E  *)

(*  LMultiDROC  *)
LMultiDROC[lexpr_?LTransformQ, oldl_?LTransformQ] :=
	MakeLObject[ {	TheFunction[lexpr],
			Append[ ToList[ GetRMinus[oldl]  ], GetRMinus[lexpr] ],
			Append[ ToList[ GetRPlus[oldl]   ], GetRPlus[lexpr] ] },
		     Append[ ToList[LVariables[oldl]], LVariables[lexpr] ] ]


(*  O T H E R     S U P P O R T I N G     R O U T I N E S  *)

(*  InvalidLTransformQ  *)
invalidl[x_] := If [ SameQ[Head[x], head], flag = True ];
InvalidLTransformQ[x_] :=
	Block [	{},
		head = SignalProcessing`Analog`LaPlace`Private`MyLaPlace;
		Scan[invalidl, x, Infinity];
		flag ]

(*  InvalidInvLTransformQ  *)
invalidinvl[x_] := If [ SameQ[Head[x], head], flag = True ];
InvalidInvLTransformQ[x_] :=
	Block [	{},
		head = SignalProcessing`Analog`InvLaPlace`Private`MyInvLaPlace;
		Scan[invalidl, x, Infinity];
		flag ]

(*  LForm  *)
LForm[Transform[x_, rm_, rp_]] := True
LForm[List[x_, rm_, rp_]] := True

(*  LTransformQ  *)
LTransformQ[x_] := SameQ[Head[x], LTransData]

(*  LVariables  *)
LTransData/: LVariables[LTransData[f_, rm_, rp_, s_]] := LVariables[s]
LVariables[LVariables[s_]] := s

(*  MakeLObject  *)
MakeLObject[LTransData[x_, rm_, rp_, s_]] :=
	LTransData[x, rm, Rplus[ GetRPlus[rp] ], s]
MakeLObject[x_List] :=
	LTransData[ x[[1]], Rminus[ x[[2]] ], Rplus[ InfCheck[x[[3]]] ] ]
MakeLObject[x_, s_] :=
	LTransData[ x[[1]], Rminus[ x[[2]] ],
		    Rplus[ InfCheck[x[[3]]] ], LVariables[ s ] ] /;
	LForm[x]

Format[ MakeLObject[a__] ] := "-Incomplete Laplace Transform-"

(*  TheFunction  *)
LTransData/: TheFunction[LTransData[x_, rm_, rp_, rest___]] := x


(*  E N D     P A C K A G E  *)

End[]
EndPackage[]

If [ TrueQ[ $VersionNumber >= 2.0 ],
     On[ General::spell ];
     On[ General::spell1 ] ];


(*  H E L P     I N F O R M A T I O N  *)

Block [	{newfuns},
	newfuns =
	  { InvalidLTransformQ,	InvalidInvLTransformQ,	LForm,
	    LMultiDROC,		LTransformQ,		LVariables,
	    MakeLObject };
	Combine[ SPfunctions, newfuns ];
	Apply[ Protect, newfuns ] ]


(*  E N D I N G     M E S S A G E  *)

Print[ "Supporting routines and objects for the Laplace transform are loaded." ]
Null
