(*  :Title:	Expression Manipulation Routines for DFT/DTFT Forms  *)

(*  :Authors:	Wally McClure, Brian Evans, James McClellan  *)

(*
    :Summary:	When loaded into Mathematica, this file will allow 
		for certain transformations from one form to another.
 *)

(*  :Context:	SignalProcessing`Digital`DSupport`  *)

(*  :PackageVersion:  2.4	*)

(*
    :Copyright:	Copyright 1989-1991 by Brian L. Evans
		Georgia Tech Research Corporation

	Permission to use, copy, modify, and distribute this software
	and its documentation for any purpose and without fee is
	hereby granted, provided that the above copyright notice
	appear in all copies and that both that copyright notice and
	this permission notice appear in supporting documentation,
	and that the name of the Georgia Tech Research Corporation,
	Georgia Tech, or Georgia Institute of Technology not be used
	in advertising or publicity pertaining to distribution of the
	software without specific, written prior permission.  Georgia
	Tech makes no representations about the suitability of this
	software for any purpose.  It is provided "as is" without
	express or implied warranty.
 *)

(*
     :History:	Date Begun -- November 11, 1989
		Made into package --  March 22, 1990
		Support for analog and digital FT's --  September, 1990
		Simplified number of rewrite rules --  February, 1991
 *)

(*  :Keywords:	trigonometry, simplification rules	*)

(*  :Source:	*)

(*  :Warning:	*)

(*  :Mathematica Version:  1.2 or 2.0  *)

(*  :Limitation:  *)

(*
    :Discussion:  These are extended simplification rules
 *)

(*  :Functions:	  TrigSimplify		*)


If [ TrueQ[ $VersionNumber >= 2.0 ],
     Off[ General::spell ];
     Off[ General::spell1 ] ];


(*  B E G I N     P A C K A G E  *)


BeginPackage[ "SignalProcessing`Digital`DSupport`",
	      "SignalProcessing`Support`SupCode`" ]


(*  U S A G E     I N F O R M A T I O N  *)

FourierSimplify::usage =
	"FourierSimplify[x] applies exponential to trigonometric rewrite \
	rules to expression x."

FVariables::usage =
	"FVariables is a data tag for the transform variables in a \
	Fourier transform."

(*  E N D     U S A G E     I N F O R M A T I O N  *)


Begin[ "`Private`" ]


(*  FourierSimplify  *)

simplify[a_. Exp[ Complex[0, b_] w_. ] + a_. Exp[ Complex[0, c_] w_. ] + x_.] :=
	2 a Cos[Abs[b] w] + simplify[x] /;
	( b == -c )
simplify[a_. Exp[ Complex[0, b_] w_. ] + d_. Exp[ Complex[0, c_] w_. ] + x_.] :=
	2 a Sin[b w] + simplify[x] /;
	( b == -c ) && ( a == -d )
simplify[d_ - d_. Exp[ Complex[0, b_] c_. ]] :=
	-2 I d Exp[ I b c / 2 ] Sin[ b c / 2 ]
simplify[d_. Exp[ Complex[0, b_] c_. ] - d_] :=
	2 I d Exp[ I b c / 2 ] Sin[ b c / 2 ]
simplify[x_] := x

FourierSimplify[ func_ ] := MapAll[ simplify, func /. SPSimplificationRules ]


(*  E N D     P A C K A G E   *)

End[]
EndPackage[]

If [ TrueQ[ $VersionNumber >= 2.0 ],
     On[ General::spell ];
     On[ General::spell1 ] ];


(*  H E L P     I N F O R M A T I O N  *)

Combine[ SPfunctions, { TrigSimplify } ]
Protect[ TrigSimplify ]


(*  E N D I N G     M E S S A G E  *)

Print["The supporting functions are loaded for symbolic Fourier transforms."]
Null
