/*******************************************************************/
/*  CPXDEFS.inc                                                    */
/*  Version 2.1m                                                   */
/*                                                                 */
/*  Copyright (c) 1989, 1990, 1991, 1992, 1993                     */
/*  CPLEX Optimization, Inc.                                       */
/*  All Rights Reserved                                            */
/*                                                                 */
/*  Last modified 22 February 1993, MCF                            */
/*******************************************************************/


#ifdef  SYSVAX
#define PROTOTYPE_MIN
#endif

#ifdef  SYSSUN3
#define PROTOTYPE_MIN
#define void      int
#endif

#ifdef  SYSAPOLLO
#define PROTOTYPE_MIN
#endif

#ifdef  SYSAIX
#define PROTOTYPE_MAX
#endif

#ifdef  SYSXENIX
#define PROTOTYPE_MIN
#endif

#ifdef  SYSHP
#define PROTOTYPE_MIN
#endif

#ifdef  SYS386
#define PROTOTYPE_MIN
#endif

#ifdef  SYSHC386
#define PROTOTYPE_MAX
#endif

#ifdef  SYSSEQUENT
#define PROTOTYPE_MIN
#endif

#ifdef  SYSSVS386
#define PROTOTYPE_MIN
#endif

#ifdef  SYSDFN
#define void      int
#define PROTOTYPE_MIN
#endif

#ifdef  SYSPG860
#define PROTOTYPE_MAX
#endif

#ifdef  SYSU6050
#define PROTOTYPE_MIN
#endif

#ifdef  SYSU6070
#define PROTOTYPE_MIN
#endif

#ifdef  SYSU6065
#define PROTOTYPE_MAX
#endif

#ifdef  SYS1167
pragma on(1167);
#define PROTOTYPE_MIN
#endif

#ifdef  SYSHC1167
pragma on(1167);
#define PROTOTYPE_MAX
#endif

#ifdef  SYS486
pragma on(486);
#define PROTOTYPE_MIN
#endif

#ifdef  SYSHC486
pragma on(486);
#define PROTOTYPE_MAX
#endif

#ifdef  SYSSPARC
#define PROTOTYPE_MIN
#endif

#ifdef  SYSAVIION
#define PROTOTYPE_MIN
#endif

#ifdef  SYSMIPS
#define PROTOTYPE_MAX
#endif

#ifdef  SYSDECSTATION
#define PROTOTYPE_MAX
#endif

#ifdef  SYSALPHA
#define PROTOTYPE_MIN
#endif

#ifdef  SYSI860
#define PROTOTYPE_MIN
#endif

#ifdef  SYSSILICON
#define PROTOTYPE_MAX
#endif

#ifdef  SYSTITAN
#define PROTOTYPE_MAX
#endif

#ifdef  SYS3090
#define PROTOTYPE_MAX
#endif

#ifdef  SYS2200
#define PROTOTYPE_MAX
#endif

#ifdef  SYSCM5
#define PROTOTYPE_MIN
#endif

#ifdef  SYSCONVEX
#define PROTOTYPE_MIN
#endif

#ifdef  SYSRS6000
#define PROTOTYPE_MAX
#endif

#ifdef  SYSCRAY
#define PROTOTYPE_MIN
#endif

/* It seems necessary to have the include for <stdio.h> after the
   1167 pragma, when that pragma is active. <stdio.h> is include here
   so that the 'FILE' type is defined */

#include <stdio.h>

/* INFBOUND:  any bound bigger than this is treated as infinity */

#define INFBOUND            1.0E+20

/* Values returned for 'stat' by solution () */

#define  CPX_OPTIMAL               1
#define  CPX_INFEASIBLE            2
#define  CPX_UNBOUNDED             3
#define  CPX_OBJ_LIM               4
#define  CPX_IT_LIM_FEAS           5
#define  CPX_IT_LIM_INFEAS         6
#define  CPX_TIME_LIM_FEAS         7
#define  CPX_TIME_LIM_INFEAS       8
#define  CPX_NON_OPT_FEAS          9
#define  CPX_NON_OPT_INFEAS       10
#define  CPX_OPTIMAL_INFEAS       11

/* Pricing options */

#define  CPX_PPRIIND_PARTIAL     -1
#define  CPX_PPRIIND_AUTO         0
#define  CPX_PPRIIND_DEVEX        1
#define  CPX_PPRIIND_STEEP        2
#define  CPX_PPRIIND_STEEPQSTART  3
#define  CPX_PPRIIND_FULL         4

#define  CPX_DPRIIND_AUTO         0
#define  CPX_DPRIIND_FULL         1
#define  CPX_DPRIIND_STEEP        2
#define  CPX_DPRIIND_FULLSTEEP    3
#define  CPX_DPRIIND_STEEPQSTART  4

/* Values returned by getmethod () */

#define  CPXALG_NONE               0
#define  CPXALG_PRIMAL             1
#define  CPXALG_DUAL               2
#define  CPXALG_PIVOTIN            3

/* NETOPT return values */

#define CPX_NETOPTIMAL        -1
#define CPX_NETINFEASIBLE     -2
#define CPX_NETUNBOUNDED      -3
#define CPX_NETIMBALANCE      -4
#define CPX_NETUNBOUNDED_INF  -5

/* Extra rim vector types used in 'etype'/'rimtype' array */

#define EXTRANROW            1
#define EXTRARHS             2
#define EXTRARNG             3
#define EXTRABDL             4
#define EXTRABDU             5

/* Variable types for ctype array */

#define CONTINUOUS          'C'
#define BINARY              'B'
#define INTEGER             'I'

/* Values for sostype */
 
#define SOS1                '1'
#define SOS2                '2'
 
/* MIP Problem status codes */

#define  CPXMIP_OPTIMAL          101
#define  CPXMIP_OPTIMAL_TOL      102
#define  CPXMIP_INFEASIBLE       103
#define  CPXMIP_SOL_LIM          104
#define  CPXMIP_NODE_LIM_FEAS    105
#define  CPXMIP_NODE_LIM_INFEAS  106
#define  CPXMIP_TIME_LIM_FEAS    107
#define  CPXMIP_TIME_LIM_INFEAS  108
#define  CPXMIP_FAIL_FEAS        109
#define  CPXMIP_FAIL_INFEAS      110
#define  CPXMIP_MEM_LIM_FEAS     111
#define  CPXMIP_MEM_LIM_INFEAS   112

/* Problem Types */

#define  CPXPROB_LP         0
#define  CPXPROB_MIP        1
#define  CPXPROB_RELAX      2
#define  CPXPROB_FIX        3
#define  CPXPROB_SUBLP      4

/* structure types */

struct cpxlp;
struct cpxchannel;
typedef struct cpxlp  *CPXLPptr;

/* I/O channels */

extern struct cpxchannel *cpxerror;      /* errors                 */
extern struct cpxchannel *cpxwarning;    /* warnings               */
extern struct cpxchannel *cpxresults;    /* informational messages */
extern struct cpxchannel *cpxlog;        /* logfile only           */

/* Argument checking enabled */

#ifdef  PROTOTYPE_MAX

/***********************************
 * CPLEX Callable Library Routines *
 ***********************************/

/* dualopt.c */

int
   dualopt (CPXLPptr);

/* netopt.c */

int
   netopt (CPXLPptr);

/* opt.c */

int
   optimize (CPXLPptr);

/* pivotin.c */

int
   pivotin (CPXLPptr, int *, int);

/* load.c */

CPXLPptr
   loadprob   (char *, int, int, int, int, double *, double *,
               char *, int *, int *, int *, double *, double *,
               double *, double *, int *, int *, int *, int *,
               int *, double *, char *, char *, char *, char *,
               char *, char **, char *, char **, char *, char **,
               char *, int, int, int, int, int, unsigned, unsigned,
               unsigned);

void
   unloadprob (CPXLPptr*),
   freeprob   (CPXLPptr*);

/* lpread.c */

int
   lpread (char *, int *, int *, int *, double **, double **,
           char **, int **, int **, int **, double **, double **,
           double **, char **, char **, char ***, char **,
           char ***, char **, int *, int *, int *, unsigned *,
           unsigned *),

   lpmread (char *, int *, int *, int *, double **, double **,
            char **, int **, int **, int **, double **, double **,
            double **, char **, char **, char ***, char **,
            char ***, char **, int *, int *, int *, unsigned *,
            unsigned *, char **);

/* lpwrite.c */

int
   lpwrite   (CPXLPptr, char *),
   lprewrite (CPXLPptr, char *);

/* mbaserw.c */

int
   mbaseread  (char *, int, int, char **, char **, int *, int *),
   msbaseread (char *, int, int, char **, char **, int *, int *,
               double **, double **),
   mbasewrite (CPXLPptr, char *);

/* message.c */

void
   delchannel        (struct cpxchannel **),
   disconnectchannel (struct cpxchannel *),
   flushchannel      (struct cpxchannel *);

int
   cpxmsg            (struct cpxchannel *, char *, ...),
   addfpdest         (struct cpxchannel *, FILE *),
   delfpdest         (struct cpxchannel *, FILE *),
   addfuncdest       (struct cpxchannel *, void *,
                      void (*)(void *, char *)),
   delfuncdest       (struct cpxchannel *, void *,
                      void (*)(void *, char *));

struct cpxchannel *
   addchannel        (void);

/* mipload.c */

CPXLPptr
   loadmprob (char *, int, int, int, int, double *, double *,
              char *, int *, int *, int *, double *, double *,
              double *, double *, int *, int *, int *, int *,
              int *, double *, char *, char *, char *, char *,
              char *, char **, char *, char **, char *, char **,
              char *, int, int, int, int, int, unsigned, unsigned,
              unsigned, char *);

int
   loadsos (CPXLPptr, int, int, char *, int *, int *, int *,
            double *),
   loadorder (CPXLPptr, int, int *, int *, int *);

/* mipopt.c */

int
   mipoptimize (CPXLPptr);

/* mipordrd.c */

int
   ordread (char *, int, char **, int *, int *, int *, int *);

/* mipquery.c */

int
   getctype    (CPXLPptr, char *, int, int),
   getprtype   (CPXLPptr),
   getbinc     (CPXLPptr),
   getintc     (CPXLPptr),
   getitcm     (CPXLPptr),
   getbobjval  (CPXLPptr, double *),
   getcutoff   (CPXLPptr, double *),
   getndc      (CPXLPptr),
   getndleft   (CPXLPptr),
   getndint    (CPXLPptr);

/* mipsol.c */

int
   getstat    (CPXLPptr),
   getmx      (CPXLPptr, double *, int, int),
   getmobjval (CPXLPptr, double *);

/* mipsosrw.c */

int
   sosread    (char *, int, char **, int *, int *, char **, int **,
               int **, int **, double **),
   soswrite   (CPXLPptr, char *);


/* miptrerw.c */

int
   treeread  (CPXLPptr, char *),
   treewrite (CPXLPptr, char *);

/* mipuset.c */

void
   getbttol     (double *),
   getbrdir     (int *),
   getcutlo     (double *),
   getcutup     (double *),
   getepagap    (double *),
   getepgap     (double *),
   getepint     (double *),
   getmifo      (int *),
   getmint      (int *),
   getndlim     (int *),
   getndsel     (int *),
   getobjdif    (double *),
   getordind    (int *),
   getmslim     (int *),
   getsosind    (int *),
   getsubalg    (int *),
   gettrelim    (double *),
   getvarsel    (int *);

int
   setbttol     (double, double *, double *),
   setbrdir     (int, int *, int *),
   setcutlo     (double, double *, double *),
   setcutup     (double, double *, double *),
   setepagap    (double, double *, double *),
   setepgap     (double, double *, double *),
   setepint     (double, double *, double *),
   setmifo      (int, int *, int *),
   setmint      (int, int *, int *),
   setndlim     (int, int *, int *),
   setndsel     (int, int *, int *),
   setobjdif    (double, double *, double *),
   setordind    (int),
   setmslim     (int, int *, int *),
   setsosind    (int),
   setsubalg    (int, int *, int *),
   settrelim    (double, double *, double *),
   setvarsel    (int, int *, int *);

/* mpsread.c */

int
   mpsread (char *, int *, int *, int *, int *, double **,
            double **, char **, int **, int **, int **,
            double **, double **, double **, double **, int **,
            int **, int **, int **, int **, double **,
            char **, char **, char **, char **, char **,
            char ***, char **, char ***, char **, char ***,
            char **, int *, int *, int *, int *, int *,
            unsigned *, unsigned *, unsigned *),

   mpsmread (char *, int *, int *, int *, int *, double **,
             double **, char **, int **, int **, int **,
             double **, double **, double **, double **, int **,
             int **, int **, int **, int **, double **,
             char **, char **, char **, char **, char **,
             char ***, char **, char ***, char **, char ***,
             char **, int *, int *, int *, int *, int *,
             unsigned *, unsigned *, unsigned *, char **,
             int *, int *, char **, int **, int **, double **);

/* mpsrevis.c */

int
   mpsrevise (CPXLPptr, char *);

/* mpswrite.c */

int
   mpswrite   (CPXLPptr, char *),
   mpsrewrite (CPXLPptr, char *),
   dualwrite  (CPXLPptr, char *, double *);

/* oddutil.c */

int
   loadbase   (CPXLPptr, int *, int *),
   loadsbase  (CPXLPptr, int *, int *, double *, double *,
               double *, double *),
   loaddnorms (CPXLPptr, double *, int *, int),
   loadpnorms (CPXLPptr, double *, double *, int);

/* presolve.c */

int
   preslvwrite (CPXLPptr, char *);

/* query.c */

int
   getprobname (CPXLPptr, char *),
   getmac      (CPXLPptr),
   getmar      (CPXLPptr),
   getmat      (CPXLPptr),
   getmae      (CPXLPptr),
   getnr       (CPXLPptr),
   getnrnz     (CPXLPptr),
   getenz      (CPXLPptr),
   getobjsen   (CPXLPptr),
   getobj      (CPXLPptr, double *, int, int),
   getrhs      (CPXLPptr, double *, int, int),
   getsense    (CPXLPptr, char *, int, int),
   getcols     (CPXLPptr, int *, int *, int *, double *, int,
                int *, int, int),
   getrows     (CPXLPptr, int *, int *, int *, double *, int,
                int *, int, int),
   getnrows    (CPXLPptr, int *, int *, int *, double *, int,
                int *, int, int),
   getextra    (CPXLPptr, int *, int *, int *, double *, int,
                int *, int, int),
   getbdl      (CPXLPptr, double *, int, int),
   getbdu      (CPXLPptr, double *, int, int),
   getrngval   (CPXLPptr, double *, int, int),
   getnrind    (CPXLPptr, int *, int, int),
   getetype    (CPXLPptr, int *, int, int),
   getdataname (CPXLPptr, char *),
   getobjname  (CPXLPptr, char *),
   getrhsname  (CPXLPptr, char *),
   getrngname  (CPXLPptr, char *),
   getbndname  (CPXLPptr, char *),
   getcname    (CPXLPptr, char **, char *, int, int *, int,
                int),
   getrname    (CPXLPptr, char **, char *, int, int *, int,
                int),
   getename    (CPXLPptr, char **, char *, int, int *, int,
                int),
   getmacsz    (CPXLPptr),
   getmarsz    (CPXLPptr),
   getmatsz    (CPXLPptr),
   getmaesz    (CPXLPptr),
   getenzsz    (CPXLPptr),
   getbase     (CPXLPptr, int *, int *),
   getdnorms   (CPXLPptr, double *, int *, int *),
   getpnorms   (CPXLPptr, double *, double *, int *),
   getitc      (CPXLPptr),
   getitci     (CPXLPptr),
   getgrad     (CPXLPptr, int, int *, double *),
   getcoef     (CPXLPptr, int, int, double *),
   getbhead    (CPXLPptr, int *, double *),
   binvcol     (CPXLPptr, int, double *),
   binvacol    (CPXLPptr, int, double *),
   binvrow     (CPXLPptr, int, double *),
   binvarow    (CPXLPptr, int, double *),
   ftran       (CPXLPptr, double *),
   btran       (CPXLPptr, double *),
   getsbcnt    (CPXLPptr),
   getijdiv    (CPXLPptr, int *, int *),
   getijrow    (CPXLPptr, int, int, int *),
   getweight   (CPXLPptr, int, int *, int *, double *,
                double *, int);

unsigned
   getcstorsz  (CPXLPptr),
   getrstorsz  (CPXLPptr),
   getestorsz  (CPXLPptr);

double
   getkappa    (CPXLPptr);

/* savread.c */

int
   savread (char *, int *, int *, int *, int *, double **,
            double **, char **, int **, int **, int **,
            double **, double **, double **, double **, int **,
            int **, int **, int **, int **, double **,
            char **, char **, char **, char **, char **,
            char ***, char **, char ***, char **, char ***,
            char **, int *, int *, int *, int *, int *,
             unsigned *, unsigned *, unsigned *, int **, int **),
   savmread (char *, int *, int *, int *, int *, double **,
             double **, char **, int **, int **, int **,
             double **, double **, double **, double **, int **,
             int **, int **, int **, int **, double **,
             char **, char **, char **, char **, char **,
             char ***, char **, char ***, char **, char ***,
             char **, int *, int *, int *, int *, int *,
             unsigned *, unsigned *, unsigned *, char **,
             int *, int *, char **, int **, int **, int **,
             double **, int **, int **);

/* savwrite.c */

int
   savwrite (CPXLPptr, char *);

/* sensit.c */

int
   rhssa  (CPXLPptr, int, int, double *, double *),
   objsa  (CPXLPptr, int, int, double *, double *),
   zobjsa (CPXLPptr, int, int, double *, double *, double *);

/* solution.c */

int
   solution  (CPXLPptr, int *, double *, double *, double *,
              double *, double *),
   getmethod (CPXLPptr),
   getobjval (CPXLPptr, double *),
   getx      (CPXLPptr, double *, int, int),
   getpi     (CPXLPptr, double *, int, int),
   getslack  (CPXLPptr, double *, int, int),
   getdj     (CPXLPptr, double *, int, int);

/* solwrite.c */

int
   txtsolwrite (CPXLPptr, char *),
   binsolwrite (CPXLPptr, char *),
   solwrite    (CPXLPptr, void (*) (CPXLPptr),
                void (*) (void), void (*) (void),
                void (*) (char, int, char *, char *, double,
                          double, double, double, double),
                void (*) (void));

/* uchange.c */

void
   chgobjsen  (CPXLPptr, int);

int
   addrows    (CPXLPptr, int, int, int, double *, char *,
               int *, int *, double *, char **, char **),
   faddrows   (CPXLPptr, int, int, int, double *, char *,
               int *, int *, double *, char **, char **),
   delrows    (CPXLPptr, int, int),
   delsetrows (CPXLPptr, int *),
   addcols    (CPXLPptr, int, int, double *, int *, int *,
               double *, double *, double *, char **),
   delcols    (CPXLPptr, int, int),
   delsetcols (CPXLPptr, int *),
   chgcoef    (CPXLPptr, int, int, double),
   chgbds     (CPXLPptr, int, int *, char *, double *),
   chgsense   (CPXLPptr, int, int *, char *),
   chgctype   (CPXLPptr, int, int *, char *),
   chgprtype  (CPXLPptr, int);

/* udisplay.c */

int
   degxcnt  (CPXLPptr, int *, double, int),
   degdjcnt (CPXLPptr, int *, double, int);

double
   checkax  (CPXLPptr, int *, int),
   checkpib (CPXLPptr, int *, int),
   checkcb  (CPXLPptr, int *, int),
   checkrb  (CPXLPptr, int *, int);

/* uset.c */

void
   getagclen  (int *),
   getitlim   (int *),
   getreinv   (int *),
   getmlim    (int *),
   getnlim    (int *),
   getnzlim   (int *),
   getelim    (int *),
   getenzlim  (int *),
   getedlimu  (int *),
   getepopt   (double *),
   getepper   (double *),
   gettilim   (double *),
   getperind  (int *),
   getlogfile (FILE **),
   getitfoind (int *),
   getppriind (int *),
   getdpriind (int *),
   getadvind  (int *),
   getobjulim (double *),
   getobjllim (double *),
   getsinglim (int *),
   getsingtol (double *),
   geteprhs   (double *),
   getepmrk   (double *),
   getcraind  (int *),
   getscaind  (int *),
   getftind   (int *),
   getbasintv (int *),
   getreflind (int *),
   getpreind  (int *),
   getaggind  (int *);

int
   setagclen  (int, int *, int *),
   setitlim   (int, int *, int *),
   setreinv   (int, int *, int *),
   setmlim    (int, int *, int *),
   setnlim    (int, int *, int *),
   setnzlim   (int, int *, int *),
   setelim    (int, int *, int *),
   setenzlim  (int, int *, int *),
   setedlimu  (int, int *, int *),
   setepopt   (double, double *, double *),
   setepper   (double, double *, double *),
   settilim   (double, double *, double *),
   setperind  (int),
   setscr_ind (int),
   setlogfile (FILE *),
   setitfoind (int, int *, int *),
   setppriind (int, int *, int *),
   setdpriind (int, int *, int *),
   setadvind  (int),
   setobjulim (double, double *, double *),
   setobjllim (double, double *, double *),
   setsinglim (int, int *, int *),
   setsingtol  (double, double *, double *),
   seteprhs   (double, double *, double *),
   setepmrk   (double, double *, double *),
   setcraind  (int, int *, int *),
   setscaind  (int, int *, int *),
   setftind   (int),
   setbasintv (int, int *, int *),
   setreflind (int),
   setpreind  (int),
   setaggind  (int);

#endif /* END PROTOTYPE_MAX */

#ifdef  PROTOTYPE_MIN

/***********************************
 * CPLEX Callable Library Routines *
 ***********************************/

/* dualopt.c */

int
   dualopt ();

/* netopt.c */

int
   netopt ();

/* opt.c */

int
   optimize ();

/* pivotin.c */

int
   pivotin ();

/* load.c */

CPXLPptr
   loadprob   ();

void
   unloadprob (),
   freeprob   ();

/* lpread.c */

int
   lpread  (),
   lpmread ();

/* lpwrite.c */

int
   lpwrite   (),
   lprewrite ();

/* mbaserw.c */

int
   mbaseread  (),
   msbaseread (),
   mbasewrite ();

/* message.c */

void
   delchannel        (),
   disconnectchannel (),
   flushchannel      ();

int
   cpxmsg            (),
   addfpdest         (),
   delfpdest         (),
   addfuncdest       (),
   delfuncdest       ();

struct cpxchannel *
   addchannel        ();

/* mipload.c */

CPXLPptr
   loadmprob ();

int
   loadsos(),
   loadorder ();

/* mipopt.c */

int
   mipoptimize ();

/* mipordrd.c */

int
   ordread ();

/* mipquery.c */

int
   getctype    (),
   getprtype   (),
   getbinc     (),
   getintc     (),
   getitcm     (),
   getbobjval  (),
   getcutoff   (),
   getndc      (),
   getndleft   (),
   getndint    ();

/* mipsol.c */

int
   getstat    (),
   getmx      (),
   getmobjval ();

/* mipsosrw.c */

int
   sosread      (),
   soswrite     ();

/* miptrerw.c */

int
   treeread  (),
   treewrite ();


/* mipuset.c */

void
   getbttol     (),
   getbrdir     (),
   getcutlo     (),
   getcutup     (),
   getepagap    (),
   getepgap     (),
   getepint     (),
   getmifo      (),
   getmint      (),
   getndlim     (),
   getndsel     (),
   getobjdif    (),
   getordind    (),
   getmslim     (),
   getsosind    (),
   getsubalg    (),
   gettrelim    (),
   getvarsel    ();

int
   setbttol     (),
   setbrdir     (),
   setcutlo     (),
   setcutup     (),
   setepagap    (),
   setepgap     (),
   setepint     (),
   setmifo      (),
   setmint      (),
   setndlim     (),
   setndsel     (),
   setobjdif    (),
   setordind    (),
   setmslim     (),
   setsosind    (),
   setsubalg    (),
   settrelim    (),
   setvarsel    ();

/* mpsread.c */

int
   mpsread  (),
   mpsmread ();

/* mpsrevis.c */

int
   mpsrevise ();

/* mpswrite.c */

int
   mpswrite   (),
   mpsrewrite (),
   dualwrite  ();

/* oddutil.c */

int
   loadbase   (),
   loadsbase  (),
   loaddnorms (),
   loadpnorms ();

/* presolve.c */

int
   preslvwrite ();

/* query.c */

int
   getprobname (),
   getmac      (),
   getmar      (),
   getmat      (),
   getmae      (),
   getnr       (),
   getnrnz     (),
   getenz      (),
   getobjsen   (),
   getobj      (),
   getrhs      (),
   getsense    (),
   getcols     (),
   getrows     (),
   getnrows    (),
   getextra    (),
   getbdl      (),
   getbdu      (),
   getrngval   (),
   getnrind    (),
   getetype    (),
   getdataname (),
   getobjname  (),
   getrhsname  (),
   getrngname  (),
   getbndname  (),
   getcname    (),
   getrname    (),
   getename    (),
   getmacsz    (),
   getmarsz    (),
   getmatsz    (),
   getmaesz    (),
   getenzsz    (),
   getbase     (),
   getdnorms   (),
   getpnorms   (),
   getitc      (),
   getitci     (),
   getgrad     (),
   getcoef     (),
   getbhead    (),
   binvcol     (),
   binvacol    (),
   binvrow     (),
   binvarow    (),
   ftran       (),
   btran       (),
   getsbcnt    (),
   getijdiv    (),
   getijrow    (),
   getweight   ();

unsigned
   getcstorsz  (),
   getrstorsz  (),
   getestorsz  ();

double
   getkappa    ();

/* savread.c */

int
   savread  (),
   savmread ();

/* savwrite.c */

int
   savwrite ();

/* sensit.c */

int
   rhssa  (),
   objsa  (),
   zobjsa ();

/* solution.c */

int
   solution  (),
   getmethod (),
   getobjval (),
   getx      (),
   getpi     (),
   getslack  (),
   getdj     ();

/* solwrite.c */

int
   txtsolwrite (),
   binsolwrite (),
   solwrite    ();

/* uchange.c */

void
   chgobjsen  ();

int
   addrows    (),
   faddrows   (),
   delrows    (),
   delsetrows (),
   addcols    (),
   delcols    (),
   delsetcols (),
   chgcoef    (),
   chgbds     (),
   chgsense   (),
   chgctype   (),
   chgprtype  ();

/* udisplay.c */

int
   degxcnt  (),
   degdjcnt ();

double
   checkax  (),
   checkpib (),
   checkcb  (),
   checkrb  ();

/* uset.c */

void
   getagclen  (),
   getitlim   (),
   getreinv   (),
   getmlim    (),
   getnlim    (),
   getnzlim   (),
   getelim    (),
   getenzlim  (),
   getedlimu  (),
   getepopt   (),
   getepper   (),
   gettilim   (),
   getperind  (),
   getlogfile (),
   getitfoind (),
   getppriind (),
   getdpriind (),
   getadvind  (),
   getobjulim (),
   getobjllim (),
   getsinglim (),
   getsingtol (),
   geteprhs   (),
   getepmrk   (),
   getcraind  (),
   getscaind  (),
   getftind   (),
   getbasintv (),
   getreflind (),
   getpreind  (),
   getaggind  ();

int
   setagclen  (),
   setitlim   (),
   setreinv   (),
   setmlim    (),
   setnlim    (),
   setnzlim   (),
   setelim    (),
   setenzlim  (),
   setedlimu  (),
   setepopt   (),
   setepper   (),
   settilim   (),
   setperind  (),
   setscr_ind (),
   setlogfile (),
   setitfoind (),
   setppriind (),
   setdpriind (),
   setadvind  (),
   setobjulim (),
   setobjllim (),
   setsinglim (),
   setsingtol (),
   seteprhs   (),
   setepmrk   (),
   setcraind  (),
   setscaind  (),
   setftind   (),
   setbasintv (),
   setreflind (),
   setpreind  (),
   setaggind  ();

#endif /* END PROTOTYPE_MIN */

