/*
 * File: bbm.M4.c
 *   By: Dave Hiebeler
 *       hiebeler@turing.cs.rpi.edu
 *       August 1989
 *
 * The "BBM" ("billiard-ball model") as described in the _Cellular
 * Automata Machines_ book by Toffoli and Margolus
 *
 * Particles reside on plane 0 (value of 1), wall cells reside on
 * plane 1 (value of 2).
 */


#include "nborhood.h"

byte BBM_update();

/* a couple of handy definitions */
#define PARTICLE 1	/* particles are on plane 0 (low bit) */
#define WALL 2		/* walls are on the next higher bit */


void
init_function()
{
    update_function = BBM_update;
}

    
byte
BBM_update(nbors)
margolus_nbors *nbors;
{
    unsigned char next; /* new value for cell is computed into this variable */
    int wallsum;	/* how many wall cells are nearby */

    Get_margolus_nbors;

    /* If I'm a wall, I stay a wall */
    if (c & WALL)
	next = WALL;
    /* Clear out next */
    else next = 0;
    /* Count up how many wall-particles are in this
     * block
     */
    wallsum = (!!(c&WALL)) + (!!(ccw&WALL)) +
	(!!(opp&WALL)) + (!!(cw&WALL));
    switch (wallsum) {
      case 0:	/* just do particle collisions */
	if ((c == opp) && (cw == ccw))
	    next |= cw&PARTICLE;
	else
	    next |= opp&PARTICLE;
	break;
      case 1:
	next |= c&PARTICLE;
	break;
      case 2:
	/* If hitting a flat wall, bounce off with specular reflection */
	if ((cw&WALL) && (opp&WALL))
	    next |= ccw&PARTICLE;
	else if ((ccw&WALL) && (opp&WALL))
	    next |= cw&PARTICLE;
	/* otherwise, just bounce back where we came from */
	else next |= c&PARTICLE;
	break;
      case 3:
	next |= c&PARTICLE;
	break;
      default:
	break;
    }
    return next;
}
