/* $Id: grtool.c,v 1.61 90/05/09 22:10:54 pturner Exp Locker: pturner $
 *
 *  Canvas event proc and do_main_loop()
 */

#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <suntool/sunview.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <sunwindow/attr.h>
#include <sunwindow/defaults.h>
#include <pixrect/pixrect.h>
#include "globals.h"
#include "defines.h"
#include "objdefs.h"

#ifdef D3D
void define_grid_popup();
extern Frame grid_frame;

#endif				/* D3D */

/*
 * variables for the canvas event proc
 */
static int sx, sy;
static int old_x, old_y;
static int xs, ys;
static int action_flag = 0;

/*
 * variables for the new text handling routine
 */
static int strx = 0, stry = 0;
static int drawx = 0, drawy = 0;
static char tmpstr[256];
static int justflag = 0;
extern double charsize, sviewcharsize;
extern int string_pen, string_font, string_rot, string_just, string_loctype;
extern double string_size;
extern plotstr pstr[];
static double si = 0.0;
static double co = 1.0;

/*
 * for area and perimeter computation
 */
#define MAX_AREA_POLY 200
int narea_pts = 0;
double area_polyx[MAX_AREA_POLY];
double area_polyy[MAX_AREA_POLY];
Panel_item comparea_item;
Panel_item compperi_item;

static short grtool_icon[] = {
#include "icon.h"
};

DEFINE_ICON_FROM_IMAGE(frame_icon, grtool_icon);

#define PIX_XOR PIX_SRC^PIX_DST

#define define_select_set_panel3(panel,panel_item,x,y) \
				panel_item=panel_create_item( panel,\
				PANEL_CYCLE,\
				PANEL_LABEL_STRING,"Select set:",\
	 			PANEL_CHOICE_STRINGS,\
			"Set 0", "Set 1", "Set 2", "Set 3", "Set 4", "Set 5",\
			"Set 6", "Set 7", "Set 8", "Set 9", "Set 10", "Set 11",\
			"Set 12", "Set 13", "Set 14", 0,\
	    		PANEL_ITEM_X,x,\
	    		PANEL_ITEM_Y,y,\
			0 );

extern int win_h, win_w;	/* dimensions of canvas */

/*
 * locator variables
 */
int deltaflag = 0;		/* used for locator function in get_points(),
				 * 0 = display location in world coordinates
				 * 1 = display [dx,dy] 2 = display [distance] */
int pointset = FALSE;		/* true if locator reference point has been
				 * set */
double dsx, dsy;		/* locator reference point */
Panel_item delta_item;		/* panel item on main_panel for locator
				 * display type */

int auto_redraw = 1;		/* if auto draw when things change */
int force_redraw = 0;		/* if no auto draw and re-draw pressed */
int rectflag = 0;		/* if an xor'ed rectangle is drawn with mouse */
int rubber_flag = 0;		/* set rubber band line */
int mbox_flag = 0;		/* moving box attached to cursor */
int mline_flag = 0;		/* moving line attached to cursor */
int go_locateflag = 1;		/* locator */

Window main_frame, main_panel;	/* main frame and panel */
Canvas canvas;			/* canvas to draw graph and associated pixwin */
Pixwin *pw;
Pixfont *winfont;		/* font to use for all of grtool */

static Panel_item locate_item;	/* locator on main_panel */

static Menu draw_menu;
static Menu compose_menu;
static Menu devices_menu;
static Menu defaults_menu;

/*
 * cursors
 */
Cursor cursor_save;		/* default cursor */
Cursor cursor;			/* cursor for zoom */
Cursor cursor_move;		/* cursor to indicate the moving of lines and
				 * boxes */
Cursor cursor_del;		/* cursor to indicate deletion of objects */
Cursor cursor_wait;		/* for those long running events */
Cursor cursor_line;		/* to indicate line drawing mode */
Cursor cursor_box;		/* to indicate box drawing mode */
Cursor cursor_legloc;		/* to indicate legend locator */
Cursor cursor_strloc;		/* to indicate string locator */
Cursor cursor_selpoint;		/* to indicate select reference point for
				 * locator */
Cursor cursor_locpoint;		/* to indicate point locator */
Cursor cursor_delpoint;		/* to indicate delete point */
Cursor cursor_area;		/* to indicate area computation */

static short int move_bits[] = {
#include <images/move.cursor>
};

static short int del_bits[] = {
#include <images/bullseye.cursor>
};

static short int wait_bits[] = {
#include <images/hglass.cursor>
};

static short int line_bits[] = {
    0xC000, 0xE000, 0x7000, 0x3800, 0x1C00, 0x0E00, 0x0700, 0x0380,
    0x01C0, 0x00E0, 0x0070, 0x0038, 0x001C, 0x000E, 0x0007, 0x0003
};

static short int box_bits[] = {
    0xFFFF, 0xFC01, 0xF801, 0xF801, 0xFC01, 0xCE01, 0x8701, 0x8381,
    0x81C1, 0x80E1, 0x8061, 0x8001, 0x8001, 0x8001, 0x8001, 0xFFFF
};

static short int legloc_bits[] = {
    0xC7BE, 0xC630, 0xC630, 0xC7B6, 0xC636, 0xF632, 0xF7BE, 0x0000,
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF
};

static short int strloc_bits[] = {
    0x67DC, 0x9112, 0x8112, 0x611C, 0x1114, 0x9112, 0x6112, 0x0000,
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF
};

static short int selpoint_bits[] = {
    0x0000, 0xFFFE, 0xC006, 0xA00A, 0x9012, 0x8822, 0x8442, 0x8282,
    0x8102, 0x8282, 0x8442, 0x8822, 0x9012, 0xA00A, 0xC006, 0xFFFE
};

static short int locpoint_bits[] = {
    0xFC00, 0xF800, 0xF000, 0xF8E0, 0xD9F0, 0x8318, 0x0318, 0x0018,
    0x0018, 0x0070, 0x00E0, 0x00C0, 0x00C0, 0x0000, 0x00C0, 0x00C0
};

static short int delpoint_bits[] = {
    0x0000, 0x0F00, 0x0F00, 0x0FFF, 0x0FFF, 0x0FFF, 0x0F00, 0x0F00,
    0x0000, 0x0000, 0x0000, 0x0000, 0x1FC0, 0x0F80, 0x0700, 0x0200
};

static short int area_bits[] = {
    0xFE00, 0xF000, 0xF800, 0xFFFC, 0xBFFC, 0x9FFC, 0x9C1C, 0x1C1C,
    0x1C1C, 0x1FFC, 0x1FFC, 0x1FFC, 0x0000, 0x0000, 0x0000, 0x0000
};

mpr_static(move_cursor, 16, 16, 1, move_bits);
mpr_static(del_cursor, 16, 16, 1, del_bits);
mpr_static(wait_cursor, 16, 16, 1, wait_bits);
mpr_static(line_cursor, 16, 16, 1, line_bits);
mpr_static(box_cursor, 16, 16, 1, box_bits);
mpr_static(legloc_cursor, 16, 16, 1, legloc_bits);
mpr_static(strloc_cursor, 16, 16, 1, strloc_bits);
mpr_static(selpoint_cursor, 16, 16, 1, selpoint_bits);
mpr_static(locpoint_cursor, 16, 16, 1, locpoint_bits);
mpr_static(delpoint_cursor, 16, 16, 1, delpoint_bits);
mpr_static(area_cursor, 16, 16, 1, area_bits);

void define_symbols_popup();	/* define set symbols and legends popup */
void define_compute_popup();	/* transformations */
void updateparms();		/* update world, view windows if any changes
				 * made during mouse controlled zoom */
void updatetics();		/* update tic flags */
void drawgraph();		/* calls plotone(), called any time the graph
				 * needs to be re-drawn not used as a canvas
				 * redraw proc */

void do_files_popup();		/* read data files popup, defined in
				 * fileswin.c */

void define_edit_popup();	/* edit points, defined in ptswin.c */
extern Frame points_frame;

void define_strings_popup();	/* strings popup, routines in strwin.c */
extern Frame strings_frame;	/* in strwin.c */

void define_setops_popup();	/* set operations, routines in setwin.c */
void do_strings_popup();	/* a routine to set WIN_SHOW=TRUE */
extern Frame setops_frame;	/* in setwin.c */

void about_grtool();		/* defined in statuswin.c */

void define_status_popup();	/* status window - information about sets */
void do_status_proc();		/* defined in statuswin.c */
void update_status();
extern Frame status_frame;

Panel_item calc_item;		/* for calculator on top */

void create_readdata_popup();	/* write parameter files */
extern Frame readdata_frame;

void define_compose_popup();	/* transformations, etc. */
extern Frame compose_frame;	/* code in compose.c */

/* world should really be window */
void define_world_popup();	/* define the world dimensions, defined in
				 * worldwin.c */
extern Frame define_world_frame;
extern Panel_item autoscale_type_item;
extern Panel_item auto_redraw_item;

void define_tics_popup();	/* define tics in tickwin.c */
extern Frame define_tics_frame;	/* declared in tickwin.c */

extern Frame define_symbols_frame;	/* declared in symwin.c */
extern Panel_item legend_x_panel;
extern Panel_item legend_y_panel;

static void flipxy();

/* lines and boxes flags */
int box_color = 1;
int line_color = 1;
int line_arrow = 0;
int line_loctype = 1;
int box_loctype = 1;
double line_asize = 1.0;

#ifdef LOCAL
int hpgl_loaded = 0;

#endif

/*
 * for ^X received by the canvas event proc
 */
void bailout()
{

#ifdef LOCAL
    if (hpgl_loaded) {
	if (!yesno("Exit without loading the T3 fonts?", "", "YES", "NO")) {
	    system("dopcl");
	}
    }
#endif

#ifdef FAST_EXIT		/* the old method of exiting */
    window_set(main_frame, FRAME_NO_CONFIRM, TRUE, 0);
    window_destroy(main_frame);
    exit(0);
#else
    window_destroy(main_frame);
#endif

}

static void close_frame(item, event)
    Panel_item item;
    Event *event;
{
    window_set(main_frame, FRAME_CLOSED, TRUE, 0);
    window_set(define_tics_frame, WIN_SHOW, FALSE, 0);
    window_set(define_world_frame, WIN_SHOW, FALSE, 0);
    window_set(setops_frame, WIN_SHOW, FALSE, 0);
    window_set(strings_frame, WIN_SHOW, FALSE, 0);
    window_set(points_frame, WIN_SHOW, FALSE, 0);
    window_set(define_symbols_frame, WIN_SHOW, FALSE, 0);
    window_set(compose_frame, WIN_SHOW, FALSE, 0);
    window_set(status_frame, WIN_SHOW, FALSE, 0);
    window_set(readdata_frame, WIN_SHOW, FALSE, 0);
}

/*
 * exit by button on front panel
 */
static void quit_main_proc(item, event)
    Panel_item item;
    Event *event;
{
    bailout();
}

static void item_is_menu()
{
    errwin("Item is a menu, use the RIGHT mouse button");
}

/*
 * menu for the draw button on main_panel
 */
static void do_draw_pulldown(item, event)
    Panel_item item;
    Event *event;
{
    int choice;

    if ((event_id(event) == MS_RIGHT) && event_is_down(event)) {
	choice = (int) menu_show(draw_menu, main_panel, event, 0);
	switch (choice) {
	case 1:
	    window_set(define_world_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 2:
	    break;
	case 3:
	    window_set(define_tics_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 4:
	    window_set(define_symbols_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 5:
	    window_set(strings_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 7:		/* autoscale */
	    if (activeset()) {
		defaultgraph();
		defaulttics((int) panel_get_value(autoscale_type_item));
		updateparms();
		drawgraph();
	    } else
		errwin("No active sets!");
	    break;
	case 9:		/* zoom */
	    set_action(0);
	    set_action(ZOOM_1ST);
	    window_set(canvas, WIN_CURSOR, cursor, 0);
	    break;
	case 11:		/* flipxy */
	    if (activeset()) {
		flipxy();
		drawgraph();
	    } else
		errwin("No active sets!");
	    break;
#ifdef D3D
	case 13:
	    window_set(grid_frame, WIN_SHOW, TRUE, 0);
	    break;
#endif				/* D3D */
	default:
	    break;
	}
    } else {
	panel_default_handle_event(item, event);
    }
}

/*
 * exchange x and y of all sets as well as parameters associated with
 * each axis
 */
static void flipxy()
{
    int i, j;
    double *x, *y, *getx(), *gety();
    double x1, y1, x2, y2;

    for (i = 0; i < maxplot; i++) {
	if (isactive(i)) {
	    x = getx(i);
	    y = gety(i);
	    for (j = 0; j < getsetlength(i); j++) {
		fswap(&x[j], &y[j]);
	    }
	    getsetminmax(i, &y1, &y2, &x1, &x2);
	    setminmax(i, x1, x2, y1, y2);
	    update_status(i);
	}
    }
    if (pointset) {		/* flip the locator also */
	fswap(&dsx, &dsy);
    }
    fswap(&xg1, &yg1);
    fswap(&xg2, &yg2);
    fswap(&xt1, &yt1);
    fswap(&xt2, &yt2);
    iswap(&xform, &yform);
    iswap(&fformx, &fformy);
    iswap(&xticsintflag, &yticsintflag);
    iswap(&xticlflag, &yticlflag);
    iswap(&xticslog, &yticslog);
    iswap(&xticflag, &yticflag);
    iswap(&xtopflag, &ytopflag);
    iswap(&xabsflag, &yabsflag);
    iswap(&xticinoutflag, &yticinoutflag);
    iswap(&xticopflag, &yticopflag);
    iswap(&xgridflag, &ygridflag);
    iswap(&xgcol, &ygcol);
    iswap(&xglin, &yglin);
    iswap(&xzflag, &yzflag);
    strcpy(buf, xlabel);
    strcpy(xlabel, ylabel);
    strcpy(ylabel, buf);
    (void) updateparms();
}

/*
 * menu for Compose button
 */
static void do_compose_pulldown(item, event)
    Panel_item item;
    Event *event;
{
    int choice;

    if (event_id(event) == MS_RIGHT && event_is_down(event)) {
	choice = (int) menu_show(compose_menu, main_panel, event, 0);
	switch (choice) {
	case 1:
	    window_set(compose_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 2:
	    window_set(setops_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 3:
	    window_set(points_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 4:
	    break;
	default:
	    break;
	}
    } else
	panel_default_handle_event(item, event);
}

static void do_devices_pulldown(item, event)
    Panel_item item;
    Event *event;
{
    int choice;

    if (event_id(event) == MS_RIGHT && event_is_down(event)) {
	choice = (int) menu_show(devices_menu, main_panel, event, 0);
	switch (choice) {
	case 1:
	    printer_setup();
	    break;
	default:
	    break;
	}
    } else
	panel_default_handle_event(item, event);
}

/*
 * opens the About grtool popup
 */
static void do_defaults_pulldown(item, event)
    Panel_item item;
    Event *event;
{
    static void results_file_proc();
    int choice;

    if (event_id(event) == MS_RIGHT && event_is_down(event)) {
	choice = (int) menu_show(defaults_menu, main_panel, event, 0);
	switch (choice) {
	case 1:
	    about_grtool();
	    break;
	default:
	    break;
	}
    } else
	panel_default_handle_event(item, event);
}

/*
 * used when auto redraw is off
 */
static void forcedrawgraph()
{
    force_redraw = 1;
    drawgraph();
}

int noerase = FALSE;		/* if drawing multiple graphs, suppresses
				 * initialization of graphics device each
				 * time a graph is drawn */
char graph_labelstr[80];	/* for labeling the graph */

/*
 * draw all visible graphs
 */
void drawgraph()
{
    static void drawagraph();
    int i, didit = 0;

#ifdef D3D
    extern int griddispflag;
    int savegdisp = griddispflag;

#endif				/* D3D */

    noerase = 1;
    graph_labelstr[0] = 0;

#ifdef D3D
    if (griddispflag >= 2) {
	plotone();
	griddispflag = 0;
    }
#endif				/* D3D */

    for (i = 0; i < MAXGRAPH; i++) {
	if (!ishid_graph(i)) {
	    if (!didit) {
		storegraph(MAXGRAPH + 1);	/* save the current graph */
		didit = 1;
	    }
	    loadgraph(i, 0);	/* load graph i */
	    if (draw_label(i)) {
		sprintf(graph_labelstr, "[Graph %d]", i);
	    }
	    drawagraph();	/* draw it */
	}
    }
    if (didit) {
	loadgraph(MAXGRAPH + 1, 0);	/* if drew a stored graph then
					 * re-load the default */
    }
    /* label the default graph */
    if (showdefault) {
	if (labeldefault) {
	    sprintf(graph_labelstr, "[Default graph]", i);
	} else {
	    graph_labelstr[0] = 0;
	}
	drawagraph();		/* draw the default graph */
    }
    if (showdefault || didit) {
	leavegraphics();
    }
#ifdef D3D
    griddispflag = savegdisp;
#endif				/* D3D */
}

/*
 * draw the current graph
 */
static void drawagraph()
{
    auto_redraw = !((int) panel_get_value(auto_redraw_item));
    if (auto_redraw || hardcopyflag || force_redraw) {
#ifndef D3D
	if (!activeset()) {
	    errwin("Warning, no active sets");
	}
#endif				/* D3D */
	if ((xv1 == xv2 || yv1 == yv2)) {
	    errwin("Viewport improperly defined");
	    hardcopyflag = FALSE;
	    return;
	}
	if ((yg1 == yg2 || xg1 == xg2)) {
	    errwin("World improperly defined");
	    hardcopyflag = FALSE;
	    return;
	}
	if (xt1 == 0.0 && !xticslog) {
	    errwin("X-major tics = 0.0");
	    hardcopyflag = FALSE;
	    return;
	} else if ((xg2 - xg1) / xt1 > 100.0) {
	    if (yesno("Number of X-major tics >100, abort?", "", "YES", "NO")) {
		hardcopyflag = FALSE;
		return;
	    }
	}
	if (yt1 == 0.0) {
	    errwin("Y-major tics = 0.0");
	    hardcopyflag = FALSE;
	    return;
	} else if ((yg2 - yg1) / yt1 > 100.0) {
	    if (yesno("Number of Y-major tics >100, abort?", "", "YES", "NO")) {
		hardcopyflag = FALSE;
		return;
	    }
	}
	/*
	 * if log scaling and xt2 == 0.0 then no minor ticks will be drawn,
	 * likewise with the Y-axis.
	 */
	if (!xticslog && (xt2 == 0.0)) {
	    errwin("X-minor tics = 0.0");
	    hardcopyflag = FALSE;
	    return;
	} else if (!xticslog && ((xg2 - xg1) / xt2 > 200.0)) {
	    if (yesno("Number of X-minor tics >200, abort?", "", "YES", "NO")) {
		hardcopyflag = FALSE;
		return;
	    }
	}
	if (!yticslog && (yt2 == 0.0)) {
	    errwin("Y-minor tics = 0.0");
	    hardcopyflag = FALSE;
	    return;
	} else if (!yticslog && ((yg2 - yg1) / yt2 > 200.0)) {
	    if (yesno("Number of Y-minor tics >200, abort?", "", "YES", "NO")) {
		hardcopyflag = FALSE;
		return;
	    }
	}
	plotone();
	hardcopyflag = FALSE;
    }
    force_redraw = 0;
}

/*
 * rubber band line
 */
void select_line(pw, x1, y1, x2, y2)
    struct pixwin *pw;
    int x1, y1, x2, y2;
{
    pw_vector(pw, x1, y1, x2, y2, PIX_XOR, 1);
}

/*
 * draw a box on the display
 */
void draw_rectangle(x1, y1, x2, y2)
    int x1, y1, x2, y2;
{
    pw_vector(pw, x1, y1, x2, y1, PIX_SRC, 1);
    pw_vector(pw, x2, y1, x2, y2, PIX_SRC, 1);
    pw_vector(pw, x2, y2, x1, y2, PIX_SRC, 1);
    pw_vector(pw, x1, y2, x1, y1, PIX_SRC, 1);
}

/*
 * OK, I stole this from touchup
 */
void select_region(pw, x1, y1, x2, y2)
    struct pixwin *pw;
    int x1, y1, x2, y2;
{
    pw_vector(pw, x1, y1, x2, y1, PIX_XOR, 1);
    pw_vector(pw, x2, y1, x2, y2, PIX_XOR, 1);
    pw_vector(pw, x2, y2, x1, y2, PIX_XOR, 1);
    pw_vector(pw, x1, y2, x1, y1, PIX_XOR, 1);
}

/*
 * locator on main_panel
 */
void getpoints(x, y)
{
    double wx, wy;

    get_world(x, y, &wx, &wy);
    if (deltaflag) {
	switch (deltaflag) {
	case 1:
	    sprintf(buf, "[DX, DY] = [%.6g, %.6g]", wx - dsx, wy - dsy);
	    break;
	case 2:
	    sprintf(buf, "[DIST] = [%.6g]", hypot(dsx - wx, dsy - wy));
	    break;
	case 3:
	    if (dsx - wx != 0.0 && dsy - wy != 0.0) {
		sprintf(buf, "[R, Theta] = [%.6g, %.6g]", hypot(dsx - wx, dsy - wy), 180.0 + 180.0 / M_PI * atan2(dsy - wy, dsx - wx));
	    }
	    break;
	}
    } else {
	sprintf(buf, "[X, Y] = [%.6g, %.6g]", (xticslog) ? pow(10.0, wx) : wx, (yticslog) ? pow(10.0, wy) : wy);
    }
    panel_set(locate_item, PANEL_LABEL_STRING, buf, 0);
}

/*
 * draw a cursor for text writing
 * TODO: fix the rotation problems (cursor doesn't track)
 */
update_text_cursor(s, x, y)
    char *s;
    int x, y;
{
    int hgt, tx;

    hgt = stringextenty(charsize * sviewcharsize, "N") / 2;
    tx = stringextentx(charsize * sviewcharsize, s);
    pw_vector(pw, x + tx, win_h - y + hgt, x + tx, win_h - y - hgt, PIX_XOR, 1);
}

/*
 * set the action_flag to the desired action (actions are
 * defined in defines.h), if 0 then cleanup the results
 * from previous actions.
 */
set_action(act)
    int act;
{
    int i;

    if (action_flag == STR_LOC) {
	double wx, wy;

	update_text_cursor(tmpstr, strx, stry);
	setcharsize(defchar);
	sviewsetfont(curfont);
	sviewsetcolor(defcolor);
	sviewsetlinestyle(defline);
	if (tmpstr[0]) {
	    get_world(strx, win_h - stry, &wx, &wy);
	    define_string(tmpstr, wx, wy);
	    tmpstr[0] = 0;
	}
    }
    if ((action_flag = act) == 0) {	/* clean up */
	window_set(canvas, WIN_CURSOR, cursor_save, 0);
	if (rectflag) {
	    select_region(pw, sx, sy, old_x, old_y);
	    rectflag = 0;
	}
	if (rubber_flag) {
	    pw_vector(pw, sx, sy, old_x, old_y, PIX_XOR, 1);
	    rubber_flag = 0;
	}
	if (mbox_flag) {
	    select_region(pw, sx, sy, xs, ys);
	    mbox_flag = 0;
	}
	if (mline_flag) {
	    select_line(pw, sx, sy, xs, ys);
	    mline_flag = 0;
	}
    }
}

do_text_string(op, c)
    int op;
    int c;

{
    int ilenx;
    int ileny;
    char stmp[2];

    drawx = strx;
    drawy = stry;

    ilenx = stringextentx(charsize * sviewcharsize, tmpstr);
    ileny = stringextenty(charsize * sviewcharsize, tmpstr);

    switch (justflag) {
    case 1:
	drawx = strx - co * ilenx + si * ileny;
	drawy = stry - si * ilenx - co * ileny;
	break;
    case 2:
	drawx = strx - (co * ilenx - si * ileny) / 2;
	drawy = stry - (si * ilenx + co * ileny) / 2;
	break;
    }
    pw_batch_on(pw);
    set_write_mode(PIX_CLR);
    update_text_cursor(tmpstr, drawx, drawy);
    dispstrsview(drawx, drawy, string_rot, tmpstr);
    switch (op) {
    case 0:
	if (strlen(tmpstr) > 0) {
	    tmpstr[strlen(tmpstr) - 1] = 0;
	}
	break;
    case 1:
	sprintf(stmp, "%c", c);
	strcat(tmpstr, stmp);
	break;
    case 2:
	break;
    }

    ilenx = stringextentx(charsize * sviewcharsize, tmpstr);
    ileny = stringextenty(charsize * sviewcharsize, tmpstr);

    switch (justflag) {
    case 1:
	drawx = strx - co * ilenx + si * ileny;
	drawy = stry - si * ilenx - co * ileny;
	break;
    case 2:
	drawx = strx - (co * ilenx - si * ileny) / 2;
	drawy = stry - (si * ilenx + co * ileny) / 2;
	break;
    }
    set_write_mode(PIX_SET);
    dispstrsview(drawx, drawy, string_rot, tmpstr);
    update_text_cursor(tmpstr, drawx, drawy);
    pw_batch_off(pw);
}

/*
 * canvas event proc
 */
void my_proc(canvas, event)
    Canvas canvas;
    Event *event;
{
    static int x, y, boxno, lineno;
    static double wx1, wx2, wy1, wy2;
    static double wx, wy, dx, dy;
    static int ty, no, c;
    extern Panel_item strings_x_item;
    extern Panel_item strings_y_item;
    double xconv(), yconv();

    x = event_x(event);
    y = event_y(event);
    if (event_is_up(event))
	return;
/*
 * hot keys
 */
    if (event_is_ascii(event)) {
	switch (c = event_action(event)) {
	case 1:		/* ^A */
	    if (activeset()) {
		defaultgraph();
		defaulttics((int) panel_get_value(autoscale_type_item));
		updateparms();
		drawgraph();
	    } else
		errwin("No active sets!");
	    break;
	case 2:		/* ^B */
	    do_boxes_proc();
	    break;
	case 3:		/* ^C */
	    window_set(compose_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 4:		/* ^D */
	    do_delete_object_proc();
	    break;
	case 5:		/* ^E */
	    window_set(points_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 6:		/* ^F */
	    window_set(readdata_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 7:		/* ^G */
	    window_set(define_world_frame, WIN_SHOW, TRUE, 0);
	    break;
	    /* stay off 8 (^H) - needed by text routines */
	case 12:		/* ^L */
	    legend_loc_proc();
	    break;
	case 14:		/* ^N */
	    do_move_proc();
	    break;
	case 16:		/* ^P */
	    do_lines_proc();
	    break;
	case 18:		/* ^R */
	    window_set(readdata_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 19:		/* ^S */
	    window_set(setops_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 20:		/* ^T */
	    window_set(define_tics_frame, WIN_SHOW, TRUE, 0);
	    break;
	case 22:		/* ^V */
	    set_action(0);
	    set_action(VIEW_1ST);
	    window_set(canvas, WIN_CURSOR, cursor, 0);
	    break;
	case 23:		/* ^W */
	    strings_loc_proc();
	    break;
	case 24:		/* ^X */
	    bailout();
	    break;
	case 26:		/* ^Z */
	    set_action(0);
	    set_action(ZOOM_1ST);
	    window_set(canvas, WIN_CURSOR, cursor, 0);
	    break;
	case 8:
	case 127:
	    if (action_flag == STR_LOC) {
		do_text_string(0, 0);
	    }
	    break;
	case '\r':
	case '\n':
	    if (action_flag == STR_LOC) {
		int itmp;

		update_text_cursor(tmpstr, drawx, drawy);
		if (tmpstr[0]) {
		    get_world(drawx, win_h - drawy, &wx, &wy);
		    define_string(tmpstr, wx, wy);
		}
		itmp = (int) (1.25 * stringextenty(charsize * sviewcharsize, "Ny"));
		strx = strx + si * itmp;
		stry = stry - co * itmp;
		tmpstr[0] = 0;
		update_text_cursor(tmpstr, strx, stry);
	    }
	    break;
	default:
	    if (action_flag == STR_LOC) {
		if (c >= 32) {
		    do_text_string(1, c);
		}
	    }
	    break;
	}
	return;
    }
    switch (event_id(event)) {
    case MS_RIGHT:		/* cancel all actions */
	if (action_flag == COMP_AREA) {
	    if (narea_pts >= 3) {
		int i;

		move2(area_polyx[0], area_polyy[0]);
		for (i = 1; i < narea_pts; i++) {
		    draw2(area_polyx[i], area_polyy[i]);
		}
		draw2(area_polyx[0], area_polyy[0]);
	    }
	}
	set_action(0);
	break;
    case MS_LEFT:
	switch (action_flag) {
	case DEL_OBJECT:	/* delete a box or a line */
	    set_action(0);
	    get_world(x, y, &wx, &wy);
	    find_item(wx, wy, &ty, &no);
	    window_set(canvas, WIN_CURSOR, cursor_save, 0);
	    if (ty >= 0) {
		switch (ty) {
		case BOX:
		    kill_box(no);
		    drawgraph();
		    break;
		case LINE:
		    kill_line(no);
		    drawgraph();
		    break;
		case STRING:
		    kill_string(no);
		    drawgraph();
		    break;
		}
	    }
	    break;
/*
 * select a box or a line to move
 */
	case MOVE_OBJECT_1ST:
	    set_action(MOVE_OBJECT_2ND);
	    get_world(x, y, &wx, &wy);
	    find_item(wx, wy, &ty, &no);
	    if (ty < 0) {
		window_set(canvas, WIN_CURSOR, cursor_save, 0);
	    } else {
		switch (ty) {
		case BOX:
		    if (boxes[no].loctype) {
			sx = (int) (win_w * boxes[no].x1);
			sy = (int) (win_h - win_h * boxes[no].y1);
			xs = (int) (win_w * boxes[no].x2);
			ys = (int) (win_h - win_h * boxes[no].y2);
		    } else {
			get_device(boxes[no].x1, boxes[no].y1, &sx, &sy);
			get_device(boxes[no].x2, boxes[no].y2, &xs, &ys);
		    }
		    select_region(pw, sx, sy, xs, ys);
		    mbox_flag = 1;
		    break;
		case LINE:
		    if (lines[no].loctype) {
			sx = (int) (win_w * lines[no].x1);
			sy = (int) (win_h - win_h * lines[no].y1);
			xs = (int) (win_w * lines[no].x2);
			ys = (int) (win_h - win_h * lines[no].y2);
		    } else {
			get_device(lines[no].x1, lines[no].y1, &sx, &sy);
			get_device(lines[no].x2, lines[no].y2, &xs, &ys);
		    }
		    select_line(pw, sx, sy, xs, ys);
		    mline_flag = 1;
		    break;
		}
	    }
	    break;
/*
 * box has been selected and new position found
 */
	case MOVE_OBJECT_2ND:
	    dx = sx - x;
	    dy = sy - y;

	    window_set(canvas, WIN_CURSOR, cursor_save, 0);
	    set_action(0);
	    sx = x;
	    sy = y;
	    xs = xs - dx;
	    ys = ys - dy;
	    get_world(sx, sy, &wx1, &wy1);
	    get_world(xs, ys, &wx2, &wy2);
	    switch (ty) {
	    case BOX:
		if (boxes[no].loctype) {
		    wx1 = xconv(wx1);
		    wy1 = yconv(wy1);
		    wx2 = xconv(wx2);
		    wy2 = yconv(wy2);
		}
		boxes[no].x1 = wx1;
		boxes[no].x2 = wx2;
		boxes[no].y1 = wy1;
		boxes[no].y2 = wy2;
		break;
	    case LINE:
		if (lines[no].loctype) {
		    wx1 = xconv(wx1);
		    wy1 = yconv(wy1);
		    wx2 = xconv(wx2);
		    wy2 = yconv(wy2);
		}
		lines[no].x1 = wx1;
		lines[no].x2 = wx2;
		lines[no].y1 = wy1;
		lines[no].y2 = wy2;
		break;
	    case STRING:
		if (pstr[no].loctype) {
		    wx1 = xconv(wx1);
		    wy1 = yconv(wy1);
		}
		pstr[no].x = wx1;
		pstr[no].y = wy1;
		break;
	    }
	    drawgraph();
	    break;
/*
 * make a new box, select first corner
 */
	case MAKE_BOX_1ST:
	    set_action(MAKE_BOX_2ND);
	    rectflag = 1;
	    sx = x;
	    sy = y;
	    select_region(pw, sx, sy, x, y);
	    break;
/*
 * make a new box, select opposite corner
 */
	case MAKE_BOX_2ND:
	    set_action(0);
	    if ((boxno = next_box()) >= 0) {
		get_world(sx, sy, &wx1, &wy1);
		get_world(x, y, &wx2, &wy2);
		setcolor(box_color);
		setclipping(FALSE);
		rect(wx1, wy1, wx2, wy2);
		setcolor(1);
		setclipping(TRUE);
		if (box_loctype) {
		    boxes[boxno].loctype = box_loctype;
		    wx1 = xconv(wx1);
		    wy1 = yconv(wy1);
		    wx2 = xconv(wx2);
		    wy2 = yconv(wy2);
		}
		boxes[boxno].x1 = wx1;
		boxes[boxno].x2 = wx2;
		boxes[boxno].y1 = wy1;
		boxes[boxno].y2 = wy2;
		boxes[boxno].color = box_color;
		boxes[boxno].style = 1;
	    }
	    break;
/*
 * make a new line, select start point
 */
	case MAKE_LINE_1ST:
	    set_action(MAKE_LINE_2ND);
	    rubber_flag = 1;
	    sx = x;
	    sy = y;
	    pw_vector(pw, sx, sy, x, y, PIX_XOR, 1);
	    break;
/*
 * make a new line, select end point
 */
	case MAKE_LINE_2ND:
	    set_action(0);
	    if ((lineno = next_line()) >= 0) {
		get_world(sx, sy, &wx1, &wy1);
		get_world(x, y, &wx2, &wy2);
		setcolor(line_color);
		draw_arrow(wx1, wy1, wx2, wy2, line_arrow, line_asize);
		if (line_loctype) {
		    lines[lineno].loctype = line_loctype;
		    wx1 = xconv(wx1);
		    wy1 = yconv(wy1);
		    wx2 = xconv(wx2);
		    wy2 = yconv(wy2);
		}
		lines[lineno].x1 = wx1;
		lines[lineno].x2 = wx2;
		lines[lineno].y1 = wy1;
		lines[lineno].y2 = wy2;
		lines[lineno].color = line_color;
		lines[lineno].arrow = line_arrow;
		setcolor(1);
	    }
	    break;
/*
 * Edit an existing string
 */
	case STR_EDIT:
	    get_world(x, y, &wx, &wy);
	    find_item(wx, wy, &ty, &no);
	    if ((ty >= 0) && (ty == STRING)) {
		int ilenx, ileny;

		wx1 = pstr[no].x;
		wy1 = pstr[no].y;
		if (pstr[no].loctype) {	/* in viewport coords */
		    get_view2world(wx1, wy1, &wx2, &wy2);
		    wx1 = wx2;
		    wy1 = wy2;
		}
		get_device(wx1, wy1, &strx, &stry);
		stry = win_h - stry;
		drawx = strx;
		drawy = stry;
		strcpy(tmpstr, pstr[no].s);
		define_string_defaults();
		setcharsize(pstr[no].size);
		sviewsetfont(pstr[no].font);
		sviewsetcolor(pstr[no].color);
		string_just = pstr[no].just;
		justflag = string_just;
		string_size = pstr[no].size;
		string_font = pstr[no].font;
		string_pen = pstr[no].color;
		string_rot = pstr[no].rot;
		string_loctype = pstr[no].loctype;
		kill_string(no);
		si = sin(M_PI / 180.0 * string_rot);
		co = cos(M_PI / 180.0 * string_rot);

		ilenx = stringextentx(charsize * sviewcharsize, tmpstr);
		ileny = stringextenty(charsize * sviewcharsize, tmpstr);

		switch (justflag) {
		case 1:
		    strx = drawx + co * ilenx - si * ileny;
		    stry = drawy + si * ilenx + co * ileny;
		    break;
		case 2:
		    strx = drawx + (co * ilenx - si * ileny) / 2;
		    stry = drawy + (si * ilenx + co * ileny) / 2;
		    break;
		}
		update_text_cursor(tmpstr, drawx, drawy);
		do_text_string(2, 0);
		action_flag = STR_LOC;
	    }
	    break;
/*
 * locate a string on the canvas
 */
	case STR_LOC:
	    if (tmpstr[0]) {
		get_world(strx, win_h - stry, &wx, &wy);
		define_string(tmpstr, wx, wy);
	    }
	    strx = x;
	    stry = win_h - y;
	    drawx = strx;
	    drawy = stry;
	    tmpstr[0] = 0;
	    define_string_defaults();
	    justflag = string_just;
	    setcharsize(string_size);
	    sviewsetfont(string_font);
	    sviewsetcolor(string_pen);
	    si = sin(M_PI / 180.0 * string_rot);
	    co = cos(M_PI / 180.0 * string_rot);
	    update_text_cursor(tmpstr, strx, stry);
	    break;
/*
 * find a point in a set
 */
	case FIND_POINT:
	    {
		int setno, loc;
		extern Panel_item locate_point_item;

		get_world(x, y, &wx, &wy);
		findpoint(wx, wy, &wx, &wy, &setno, &loc);
		sprintf(buf, "Set %d, loc %d, (%lf, %lf)", setno, loc, wx, wy);
		panel_set_value(locate_point_item, buf);
		set_action(FIND_POINT);
	    }
	    break;
/*
 * Compute the area of a polygon
 */
	case COMP_AREA:
	    {
		double area, comp_area();

		get_world(x, y, &area_polyx[narea_pts], &area_polyy[narea_pts]);
		narea_pts++;
		if (narea_pts <= 2) {
		    area = 0.0;
		} else {
		    area = comp_area(narea_pts, area_polyx, area_polyy);
		}
		sprintf(buf, "[%lf]", fabs(area));
		panel_set(comparea_item, PANEL_LABEL_STRING, buf, 0);
		rubber_flag = 1;
		sx = x;
		sy = y;
		pw_vector(pw, sx, sy, x, y, PIX_XOR, 1);
		set_action(COMP_AREA);
	    }
	    break;
	case COMP_PERIMETER:
	    {
		double area, comp_perimeter();

		get_world(x, y, &area_polyx[narea_pts], &area_polyy[narea_pts]);
		narea_pts++;
		if (narea_pts <= 1) {
		    area = 0.0;
		} else {
		    area = comp_perimeter(narea_pts, area_polyx, area_polyy);
		}
		sprintf(buf, "[%lf]", fabs(area));
		panel_set(compperi_item, PANEL_LABEL_STRING, buf, 0);
		rubber_flag = 1;
		sx = x;
		sy = y;
		pw_vector(pw, sx, sy, x, y, PIX_XOR, 1);
		set_action(COMP_PERIMETER);
	    }
	    break;
/*
 * select a reference point for the locator in main_panel
 */
	case SEL_POINT:
	    get_world(x, y, &wx, &wy);
	    dsx = wx;
	    dsy = wy;
	    set_action(0);
	    break;
/*
 * delete a point in a set
 */
	case DEL_POINT:
	    {
		int setno, loc;

		get_world(x, y, &wx, &wy);
		findpoint(wx, wy, &wx, &wy, &setno, &loc);
		if (setno >= 0) {
		    del_point(setno, loc);
		    update_status(setno);
		}
		set_action(0);
	    }
	    break;
/*
 * locate the graph legend
 */
	case LEG_LOC:
	    get_world(x, y, &wx, &wy);
	    if (legloctype) {
		wx = xconv(wx);
		wy = yconv(wy);
	    }
	    sprintf(buf, "%.6g", wx);
	    panel_set_value(legend_x_panel, buf);
	    sprintf(buf, "%.6g", wy);
	    panel_set_value(legend_y_panel, buf);
	    set_action(0);
	    define_legends_proc();
	    break;
/*
 * set one corner of zoom
 */
	case ZOOM_1ST:
	    set_action(ZOOM_2ND);
	    rectflag = 1;
	    sx = x;
	    sy = y;
	    select_region(pw, x, y, x, y);
	    break;
/*
 * set opposing corner of zoom
 */
	case ZOOM_2ND:
	    set_action(0);
	    select_region(pw, sx, sy, old_x, old_y);
	    get_world(sx, sy, &wx1, &wy1);
	    get_world(old_x, old_y, &wx2, &wy2);
	    if (wx1 > wx2)
		fswap(&wx1, &wx2);
	    if (wy1 > wy2)
		fswap(&wy1, &wy2);
	    xg1 = wx1;
	    xg2 = wx2;
	    yg1 = wy1;
	    yg2 = wy2;
	    defaulttics((int) panel_get_value(autoscale_type_item));
	    drawgraph();
	    break;
/*
 * set one corner of viewport
 */
	case VIEW_1ST:
	    set_action(VIEW_2ND);
	    rectflag = 1;
	    sx = x;
	    sy = y;
	    select_region(pw, x, y, x, y);
	    break;
/*
 * set opposing corner of viewport
 */
	case VIEW_2ND:
	    {
		double vx1, vx2, vy1, vy2;

		set_action(0);
		select_region(pw, sx, sy, old_x, old_y);
		get_world(sx, sy, &wx1, &wy1);
		get_world(old_x, old_y, &wx2, &wy2);
		get_view(wx1, wy1, &vx1, &vy1);
		get_view(wx2, wy2, &vx2, &vy2);
		if (vx1 > vx2)
		    fswap(&vx1, &vx2);
		if (vy1 > vy2)
		    fswap(&vy1, &vy2);
		xv1 = vx1;
		xv2 = vx2;
		yv1 = vy1;
		yv2 = vy2;
		drawgraph();
	    }
	    break;
	}
	break;
    case MS_MIDDLE:		/* not used? */
	break;
    case LOC_MOVE:
    case LOC_WINENTER:
	if (go_locateflag)
	    getpoints(x, y);
	break;
    case LOC_WINEXIT:
	break;
    default:
	break;
    }
/*
 * some mouse tracking stuff
 */
    switch (action_flag) {
    case MOVE_OBJECT_2ND:
	dx = sx - x;
	dy = sy - y;

	switch (ty) {
	case BOX:
	    select_region(pw, sx, sy, xs, ys);
	    sx = x;
	    sy = y;
	    xs = xs - dx;
	    ys = ys - dy;
	    select_region(pw, sx, sy, xs, ys);
	    break;
	case LINE:
	    select_line(pw, sx, sy, xs, ys);
	    sx = x;
	    sy = y;
	    xs = xs - dx;
	    ys = ys - dy;
	    select_line(pw, sx, sy, xs, ys);
	    break;
	}
	break;
    case STR_LOC:
	break;
    case LEG_LOC:
	get_world(x, y, &wx, &wy);
	if (legloctype) {
	    wx = xconv(wx);
	    wy = yconv(wy);
	}
	sprintf(buf, "%.6g", wx);
	panel_set_value(legend_x_panel, buf);
	sprintf(buf, "%.6g", wy);
	panel_set_value(legend_y_panel, buf);
	break;
    }
    if (rectflag) {
	select_region(pw, sx, sy, old_x, old_y);
	select_region(pw, sx, sy, x, y);
    }
    if (rubber_flag) {
	pw_vector(pw, sx, sy, old_x, old_y, PIX_XOR, 1);
	pw_vector(pw, sx, sy, x, y, PIX_XOR, 1);
    }
    old_x = x;
    old_y = y;
}

/*
 * canvas resize proc
 */
static void my_redraw_proc(c, w, h)
    Canvas c;
    int w, h;
{
    win_h = h;
    win_w = w;
    drawgraph();
}

/*
 * set hardcopy flag and if writing to a file, check
 * to see if it exists
 */
static void do_hardcopy()
{
    FILE *fp;
    extern int ptofile;		/* defined in printwin.c */
    extern char printstr[];	/* defined in printwin.c */

    if (ptofile) {
	if (fexists(printstr)) {
	    hardcopyflag = FALSE;
	    return;
	}
	fp = fopen(printstr, "w");
	if (fp == NULL) {
	    sprintf(buf, "Can't open %s for write, hardcopy aborted", printstr);
	    errwin(buf);
	    hardcopyflag = FALSE;
	    return;
	}
	fclose(fp);
    }
    hardcopyflag = TRUE;
    drawgraph();
}

/*
 * set action to SEL_POINT for selecting the locator reference point
 */
static void do_select_point(item, event)
    Panel_item item;
    Event *event;
{
    deltaflag = (int) panel_get_value(delta_item);
    if (deltaflag > 3) {
	pointset = FALSE;
	deltaflag = 0;
	panel_set_value(delta_item, 0);
    } else {
	set_action(0);
	set_action(SEL_POINT);
	pointset = TRUE;
	window_set(canvas, WIN_CURSOR, cursor_selpoint, 0);
    }
}

/*
 * switch on the area calculator
 */
static void do_select_area(item, event)
    Panel_item item;
    Event *event;
{
    narea_pts = 0;
    set_action(0);
    set_action(COMP_AREA);
    window_set(canvas, WIN_CURSOR, cursor_area, 0);
}

/*
 * switch on the perimeter calculator
 */
static void do_select_peri(item, event)
    Panel_item item;
    Event *event;
{
    narea_pts = 0;
    set_action(0);
    set_action(COMP_PERIMETER);
    window_set(canvas, WIN_CURSOR, cursor_area, 0);
}


/*
 * evaluate an expression for the calculator
 */
static void do_calc_proc(item, event)
    Panel_item item;
    Event *event;
{
    static double a = 0.0;
    static double b = 0.0;
    static double c = 0.0;
    static double d = 0.0;
    static double x = 0.0;
    static double y = 0.0;
    static int errpos;
    static char val[128];
    extern double result;

    errpos = 0;
    strcpy(val, (char *) panel_get_value(calc_item));
    fixupstr(val);
    scanner(val, &x, &y, &a, &b, &c, &d, 0, 0, &errpos);
    if (errpos) {
	panel_set_value(calc_item, "error");
    } else {
	sprintf(val, "%.5g", result);
	panel_set_value(calc_item, val);
    }
}

/*
 * select the type of display for locator
 */
static void do_setdeltype(item, value, event)
    Panel_item item;
    Event *event;
    int value;
{
    deltaflag = value;
}

/*
 * here begins SunView
 */
void do_main_loop(argc, argv)
    int argc;
    char **argv;
{
    extern char version[];
    int i;

    winfont = pf_open(GRTOOL_WINFONT);
    if (winfont == NULL) {
	fprintf(stderr, "Error opening default font\n");
    }
    inwin = TRUE;
    main_frame = window_create(NULL, FRAME,
			       FRAME_ARGS, argc, argv,
			       FRAME_ICON, &frame_icon,
			       WIN_WIDTH, WINDOWW,
			       WIN_HEIGHT, WINDOWH,
			       WIN_X, 0,
			       WIN_Y, 0,
			       WIN_FONT, winfont,
			       WIN_ERROR_MSG, "Couldn't create main_frame",
			       FRAME_LABEL, version, 0);
    main_panel = window_create(main_frame, PANEL,
			       WIN_FONT, winfont,
			       0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Files", 0, winfont),
		      PANEL_NOTIFY_PROC, do_files_popup,
		      PANEL_ITEM_X, ATTR_COL(0),
		      PANEL_ITEM_Y, ATTR_ROW(0),
		      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		  panel_button_image(main_panel, "Define plot", 0, winfont),
		      PANEL_EVENT_PROC, do_draw_pulldown,
		      PANEL_NOTIFY_PROC, item_is_menu,
		      PANEL_ITEM_X, ATTR_COL(10),
		      PANEL_ITEM_Y, ATTR_ROW(0),
		      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Compose", 0, winfont),
		      PANEL_EVENT_PROC, do_compose_pulldown,
		      PANEL_NOTIFY_PROC, item_is_menu,
		      PANEL_ITEM_X, ATTR_COL(10),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      0);
    calc_item = panel_create_item(main_panel, PANEL_TEXT,
				  PANEL_VALUE_FONT, winfont,
				  PANEL_LABEL_FONT, winfont,
				  PANEL_LABEL_STRING, "Calc: ",
				  PANEL_ITEM_X, ATTR_COL(10),
				  PANEL_ITEM_Y, ATTR_ROW(2),
				  PANEL_NOTIFY_STRING, "\r\t\n",
				  PANEL_NOTIFY_PROC, do_calc_proc,
				  PANEL_VALUE_DISPLAY_LENGTH, 40,
				  0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Re-draw", 0, winfont),
		      PANEL_NOTIFY_PROC, forcedrawgraph,
		      PANEL_ITEM_X, ATTR_COL(24),
		      PANEL_ITEM_Y, ATTR_ROW(0),
		      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Hardcopy", 0, winfont),
		      PANEL_NOTIFY_PROC, do_hardcopy,
		      PANEL_ITEM_X, ATTR_COL(24),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Printers", 0, winfont),
		      PANEL_EVENT_PROC, do_devices_pulldown,
		      PANEL_NOTIFY_PROC, item_is_menu,
		      PANEL_ITEM_X, ATTR_COL(35),
		      PANEL_ITEM_Y, ATTR_ROW(0),
		      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Status", 0, winfont),
		      PANEL_NOTIFY_PROC, do_status_proc,
		      PANEL_ITEM_X, ATTR_COL(35),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Misc", 0, winfont),
		      PANEL_EVENT_PROC, do_defaults_pulldown,
		      PANEL_NOTIFY_PROC, item_is_menu,
		      PANEL_ITEM_X, ATTR_COL(48),
		      PANEL_ITEM_Y, ATTR_ROW(0),
		      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Close", 0, winfont),
		      PANEL_NOTIFY_PROC, close_frame,
		      PANEL_ITEM_X, ATTR_COL(48),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Exit", 0, winfont),
		      PANEL_NOTIFY_PROC, quit_main_proc,
		      PANEL_ITEM_X, ATTR_COL(0),
		      PANEL_ITEM_Y, ATTR_ROW(2),
		      0);
    locate_item = panel_create_item(main_panel, PANEL_MESSAGE,
				    PANEL_ITEM_X, ATTR_COL(60),
				    PANEL_ITEM_Y, ATTR_ROW(0),
				    PANEL_LABEL_FONT, winfont,
				    PANEL_LABEL_STRING, "[X,Y]",
				    0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		    panel_button_image(main_panel, "Fix point", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(58),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      PANEL_NOTIFY_PROC, do_select_point,
		      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Area", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(58),
		      PANEL_ITEM_Y, ATTR_ROW(2),
		      PANEL_NOTIFY_PROC, do_select_area,
		      0);
    comparea_item = panel_create_item(main_panel, PANEL_MESSAGE,
				      PANEL_ITEM_X, ATTR_COL(65),
				      PANEL_ITEM_Y, ATTR_ROW(2),
				      PANEL_LABEL_FONT, winfont,
				      PANEL_LABEL_STRING, "[Area]",
				      0);
    panel_create_item(main_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(main_panel, "Perim", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(77),
		      PANEL_ITEM_Y, ATTR_ROW(2),
		      PANEL_NOTIFY_PROC, do_select_peri,
		      0);
    compperi_item = panel_create_item(main_panel, PANEL_MESSAGE,
				      PANEL_ITEM_X, ATTR_COL(85),
				      PANEL_ITEM_Y, ATTR_ROW(2),
				      PANEL_LABEL_FONT, winfont,
				      PANEL_LABEL_STRING, "[Perimeter]",
				      0);
    delta_item = panel_create_item(main_panel, PANEL_CYCLE,
				   PANEL_VALUE_FONT, winfont,
				   PANEL_LABEL_FONT, winfont,
				   PANEL_LABEL_STRING,
				   "Locator display type",
				   PANEL_CHOICE_STRINGS,
				   "[X, Y]",
				   "[DX, DY]",
				   "[DISTANCE]",
				   "[R, Theta]",
				   "Clear point",
				   0,
				   PANEL_ITEM_X, ATTR_COL(70),
				   PANEL_ITEM_Y, ATTR_ROW(1),
				   PANEL_NOTIFY_PROC, do_setdeltype,
				   0);
    window_fit_height(main_panel);
    canvas = window_create(main_frame, CANVAS,
			   CANVAS_AUTO_SHRINK, TRUE,
			   CANVAS_WIDTH, WINDOWW,
			   CANVAS_HEIGHT, WINDOWH,
			   CANVAS_RESIZE_PROC, my_redraw_proc,
			   WIN_EVENT_PROC, my_proc,
			   WIN_CONSUME_PICK_EVENT, WIN_IN_TRANSIT_EVENTS,
			   WIN_CONSUME_KBD_EVENT, WIN_ASCII_EVENTS,
			   WIN_CONSUME_KBD_EVENT, WIN_RIGHT_KEYS,
			   0);
    draw_menu = menu_create(MENU_STRINGS,
			    "Define world/view",
			    "",
			    "Tics and labels",
			    "Symbols & legends",
			    "Strings & things",
			    "",
			    "Autoscale",
			    "",
			    "Zoom",
			    "",
			    "Flip X-Y",
#ifdef D3D
			    "",
			    "Grids",
#endif				/* D3D */
			    0, 0);
    compose_menu = menu_create(MENU_STRINGS,
			       "Transformations",
			       "Setops",
			       "Edit points",
			       0, 0);
    devices_menu = menu_create(MENU_STRINGS,
			       "Select printer",
			       0, 0);
    defaults_menu = menu_create(MENU_STRINGS,
				"About grtool",
				0, 0);
    pw = canvas_pixwin(canvas);

    win_h = (int) window_get(canvas, CANVAS_HEIGHT);
    win_w = (int) window_get(canvas, CANVAS_WIDTH);

    create_readdata_popup();

    define_world_popup();
    define_tics_popup();
    define_symbols_popup();
    define_strings_popup();
#ifdef D3D
    define_grid_popup();
#endif				/* D3D */
    define_points_popup();
    define_compose_popup();
    define_setops_popup();
    define_status_popup();

    cursor_save = cursor_copy(window_get(canvas, WIN_CURSOR));
    cursor = cursor_create(CURSOR_SHOW_CROSSHAIRS, TRUE,
			   CURSOR_OP, PIX_SRC ^ PIX_DST,
			   CURSOR_CROSSHAIR_THICKNESS, 1,
			   CURSOR_CROSSHAIR_LENGTH, CURSOR_TO_EDGE,
			   CURSOR_CROSSHAIR_GAP, 0, 0);
    cursor_move = cursor_create(CURSOR_IMAGE, &move_cursor,
				CURSOR_XHOT, 0,
				CURSOR_YHOT, 0,
				CURSOR_OP, PIX_SRC ^ PIX_DST,
				0);
    cursor_del = cursor_create(CURSOR_IMAGE, &del_cursor,
			       CURSOR_XHOT, 0,
			       CURSOR_YHOT, 0,
			       CURSOR_OP, PIX_SRC ^ PIX_DST,
			       0);
    cursor_wait = cursor_create(CURSOR_IMAGE, &wait_cursor,
				CURSOR_XHOT, 0,
				CURSOR_YHOT, 0,
				CURSOR_OP, PIX_SRC ^ PIX_DST,
				0);
    cursor_line = cursor_create(CURSOR_IMAGE, &line_cursor,
				CURSOR_XHOT, 0,
				CURSOR_YHOT, 0,
				CURSOR_OP, PIX_SRC ^ PIX_DST,
				0);
    cursor_box = cursor_create(CURSOR_IMAGE, &box_cursor,
			       CURSOR_XHOT, 0,
			       CURSOR_YHOT, 0,
			       CURSOR_OP, PIX_SRC ^ PIX_DST,
			       0);
    cursor_legloc = cursor_create(CURSOR_IMAGE, &legloc_cursor,
				  CURSOR_XHOT, 0,
				  CURSOR_YHOT, 0,
				  CURSOR_OP, PIX_SRC ^ PIX_DST,
				  0);
    cursor_strloc = cursor_create(CURSOR_IMAGE, &strloc_cursor,
				  CURSOR_XHOT, 0,
				  CURSOR_YHOT, 0,
				  CURSOR_OP, PIX_SRC ^ PIX_DST,
				  0);
    cursor_selpoint = cursor_create(CURSOR_IMAGE, &selpoint_cursor,
				    CURSOR_XHOT, 7,
				    CURSOR_YHOT, 8,
				    CURSOR_OP, PIX_SRC ^ PIX_DST,
				    0);
    cursor_locpoint = cursor_create(CURSOR_IMAGE, &locpoint_cursor,
				    CURSOR_XHOT, 0,
				    CURSOR_YHOT, 0,
				    CURSOR_OP, PIX_SRC ^ PIX_DST,
				    0);
    cursor_delpoint = cursor_create(CURSOR_IMAGE, &delpoint_cursor,
				    CURSOR_XHOT, 7,
				    CURSOR_YHOT, 15,
				    CURSOR_OP, PIX_SRC ^ PIX_DST,
				    0);
    cursor_area = cursor_create(CURSOR_IMAGE, &area_cursor,
				CURSOR_XHOT, 0,
				CURSOR_YHOT, 0,
				CURSOR_OP, PIX_SRC ^ PIX_DST,
				0);
    updateparms();
    updatetics();
    for (i = 0; i < maxplot; i++) {
	update_status(i);
    }
    window_main_loop(main_frame);
}
