/* Kernel includes */
#include <linux/config.h>
#include <linux/module.h>

extern int base(int, char *);

static void
dummy_base(int level, char *s)
{
	printk("calling base from level %d with string='%s'\n", level +1, s);
	base(level + 1, s);
	printk("returned from base, at level %d\n", level + 1);
}

/*
 * Note that we are not exporting any really _new_ symbols here!
 * The only purpose is to export an alias to a symbol that was
 * exported by another module.
 *
 * This also means then we do not need to run "genksyms" on this
 * source file!
 *
 * Had we exported some _new_ symbols from this module, then these
 * symbols would have been exported with "X(a_symbol)".
 * In _that_ case we would have had to run "genksyms" on this source
 * as well, in order to generate symbol versioning info for all the
 * _new_ symbols!
 */
static struct symbol_table mid_syms = {
#include "symtab_begin.h"
	Xalias(dummy_base, base),
#include "symtab_end.h"
};

int
init_module(void)
{
	register_symtab(&mid_syms);
	return 0;
}

void
cleanup_module(void)
{
	return;
}
