# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Action(_serialization.Model):
    """The action that will be executed.

    :ivar action_type: The type of the action. Known values are: "EmailContacts" and "AutoRenew".
    :vartype action_type: str or ~azure.keyvault.v2016_10_01.models.ActionType
    """

    _attribute_map = {
        "action_type": {"key": "action_type", "type": "str"},
    }

    def __init__(self, *, action_type: Optional[Union[str, "_models.ActionType"]] = None, **kwargs):
        """
        :keyword action_type: The type of the action. Known values are: "EmailContacts" and
         "AutoRenew".
        :paramtype action_type: str or ~azure.keyvault.v2016_10_01.models.ActionType
        """
        super().__init__(**kwargs)
        self.action_type = action_type


class AdministratorDetails(_serialization.Model):
    """Details of the organization administrator of the certificate issuer.

    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar email_address: Email address.
    :vartype email_address: str
    :ivar phone: Phone number.
    :vartype phone: str
    """

    _attribute_map = {
        "first_name": {"key": "first_name", "type": "str"},
        "last_name": {"key": "last_name", "type": "str"},
        "email_address": {"key": "email", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        phone: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        :keyword email_address: Email address.
        :paramtype email_address: str
        :keyword phone: Phone number.
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.phone = phone


class Attributes(_serialization.Model):
    """The object attributes managed by the KeyVault service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "not_before": {"key": "nbf", "type": "unix-time"},
        "expires": {"key": "exp", "type": "unix-time"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword enabled: Determines whether the object is enabled.
        :paramtype enabled: bool
        :keyword not_before: Not before date in UTC.
        :paramtype not_before: ~datetime.datetime
        :keyword expires: Expiry date in UTC.
        :paramtype expires: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.not_before = not_before
        self.expires = expires
        self.created = None
        self.updated = None


class BackupKeyResult(_serialization.Model):
    """The backup key result, containing the backup blob.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The backup blob containing the backed up key.
    :vartype value: bytes
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "base64"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class BackupSecretResult(_serialization.Model):
    """The backup secret result, containing the backup blob.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The backup blob containing the backed up secret.
    :vartype value: bytes
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "base64"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class CertificateAttributes(Attributes):
    """The certificate management attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    :ivar recovery_level: Reflects the deletion recovery level currently in effect for certificates
     in the current vault. If it contains 'Purgeable', the certificate can be permanently deleted by
     a privileged user; otherwise, only the system can purge the certificate, at the end of the
     retention interval. Known values are: "Purgeable", "Recoverable+Purgeable", "Recoverable", and
     "Recoverable+ProtectedSubscription".
    :vartype recovery_level: str or ~azure.keyvault.v2016_10_01.models.DeletionRecoveryLevel
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
        "recovery_level": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "not_before": {"key": "nbf", "type": "unix-time"},
        "expires": {"key": "exp", "type": "unix-time"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
        "recovery_level": {"key": "recoveryLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword enabled: Determines whether the object is enabled.
        :paramtype enabled: bool
        :keyword not_before: Not before date in UTC.
        :paramtype not_before: ~datetime.datetime
        :keyword expires: Expiry date in UTC.
        :paramtype expires: ~datetime.datetime
        """
        super().__init__(enabled=enabled, not_before=not_before, expires=expires, **kwargs)
        self.recovery_level = None


class CertificateBundle(_serialization.Model):
    """A certificate bundle consists of a certificate (X509) plus its attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar kid: The key id.
    :vartype kid: str
    :ivar sid: The secret id.
    :vartype sid: str
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar policy: The management policy.
    :vartype policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :ivar cer: CER contents of x509 certificate.
    :vartype cer: bytes
    :ivar content_type: The content type of the secret.
    :vartype content_type: str
    :ivar attributes: The certificate attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "kid": {"readonly": True},
        "sid": {"readonly": True},
        "x509_thumbprint": {"readonly": True},
        "policy": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "kid": {"key": "kid", "type": "str"},
        "sid": {"key": "sid", "type": "str"},
        "x509_thumbprint": {"key": "x5t", "type": "base64"},
        "policy": {"key": "policy", "type": "CertificatePolicy"},
        "cer": {"key": "cer", "type": "bytearray"},
        "content_type": {"key": "contentType", "type": "str"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        cer: Optional[bytes] = None,
        content_type: Optional[str] = None,
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword cer: CER contents of x509 certificate.
        :paramtype cer: bytes
        :keyword content_type: The content type of the secret.
        :paramtype content_type: str
        :keyword attributes: The certificate attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.kid = None
        self.sid = None
        self.x509_thumbprint = None
        self.policy = None
        self.cer = cer
        self.content_type = content_type
        self.attributes = attributes
        self.tags = tags


class CertificateCreateParameters(_serialization.Model):
    """The certificate create parameters.

    :ivar certificate_policy: The management policy for the certificate.
    :vartype certificate_policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "certificate_policy": {"key": "policy", "type": "CertificatePolicy"},
        "certificate_attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        certificate_policy: Optional["_models.CertificatePolicy"] = None,
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword certificate_policy: The management policy for the certificate.
        :paramtype certificate_policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :keyword certificate_attributes: The attributes of the certificate (optional).
        :paramtype certificate_attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.certificate_policy = certificate_policy
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CertificateImportParameters(_serialization.Model):
    """The certificate import parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar base64_encoded_certificate: Base64 encoded representation of the certificate object to
     import. This certificate needs to contain the private key. Required.
    :vartype base64_encoded_certificate: str
    :ivar password: If the private key in base64EncodedCertificate is encrypted, the password used
     for encryption.
    :vartype password: str
    :ivar certificate_policy: The management policy for the certificate.
    :vartype certificate_policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "base64_encoded_certificate": {"required": True},
    }

    _attribute_map = {
        "base64_encoded_certificate": {"key": "value", "type": "str"},
        "password": {"key": "pwd", "type": "str"},
        "certificate_policy": {"key": "policy", "type": "CertificatePolicy"},
        "certificate_attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        base64_encoded_certificate: str,
        password: Optional[str] = None,
        certificate_policy: Optional["_models.CertificatePolicy"] = None,
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword base64_encoded_certificate: Base64 encoded representation of the certificate object to
         import. This certificate needs to contain the private key. Required.
        :paramtype base64_encoded_certificate: str
        :keyword password: If the private key in base64EncodedCertificate is encrypted, the password
         used for encryption.
        :paramtype password: str
        :keyword certificate_policy: The management policy for the certificate.
        :paramtype certificate_policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :keyword certificate_attributes: The attributes of the certificate (optional).
        :paramtype certificate_attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.base64_encoded_certificate = base64_encoded_certificate
        self.password = password
        self.certificate_policy = certificate_policy
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CertificateIssuerItem(_serialization.Model):
    """The certificate issuer item containing certificate issuer metadata.

    :ivar id: Certificate Identifier.
    :vartype id: str
    :ivar provider: The issuer provider.
    :vartype provider: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
    }

    def __init__(
        self, *, id: Optional[str] = None, provider: Optional[str] = None, **kwargs  # pylint: disable=redefined-builtin
    ):
        """
        :keyword id: Certificate Identifier.
        :paramtype id: str
        :keyword provider: The issuer provider.
        :paramtype provider: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.provider = provider


class CertificateIssuerListResult(_serialization.Model):
    """The certificate issuer list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of certificate issuers in the key vault along
     with a link to the next page of certificate issuers.
    :vartype value: list[~azure.keyvault.v2016_10_01.models.CertificateIssuerItem]
    :ivar next_link: The URL to get the next set of certificate issuers.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CertificateIssuerItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class CertificateIssuerSetParameters(_serialization.Model):
    """The certificate issuer set parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar provider: The issuer provider. Required.
    :vartype provider: str
    :ivar credentials: The credentials to be used for the issuer.
    :vartype credentials: ~azure.keyvault.v2016_10_01.models.IssuerCredentials
    :ivar organization_details: Details of the organization as provided to the issuer.
    :vartype organization_details: ~azure.keyvault.v2016_10_01.models.OrganizationDetails
    :ivar attributes: Attributes of the issuer object.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.IssuerAttributes
    """

    _validation = {
        "provider": {"required": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "credentials": {"key": "credentials", "type": "IssuerCredentials"},
        "organization_details": {"key": "org_details", "type": "OrganizationDetails"},
        "attributes": {"key": "attributes", "type": "IssuerAttributes"},
    }

    def __init__(
        self,
        *,
        provider: str,
        credentials: Optional["_models.IssuerCredentials"] = None,
        organization_details: Optional["_models.OrganizationDetails"] = None,
        attributes: Optional["_models.IssuerAttributes"] = None,
        **kwargs
    ):
        """
        :keyword provider: The issuer provider. Required.
        :paramtype provider: str
        :keyword credentials: The credentials to be used for the issuer.
        :paramtype credentials: ~azure.keyvault.v2016_10_01.models.IssuerCredentials
        :keyword organization_details: Details of the organization as provided to the issuer.
        :paramtype organization_details: ~azure.keyvault.v2016_10_01.models.OrganizationDetails
        :keyword attributes: Attributes of the issuer object.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.IssuerAttributes
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.credentials = credentials
        self.organization_details = organization_details
        self.attributes = attributes


class CertificateIssuerUpdateParameters(_serialization.Model):
    """The certificate issuer update parameters.

    :ivar provider: The issuer provider.
    :vartype provider: str
    :ivar credentials: The credentials to be used for the issuer.
    :vartype credentials: ~azure.keyvault.v2016_10_01.models.IssuerCredentials
    :ivar organization_details: Details of the organization as provided to the issuer.
    :vartype organization_details: ~azure.keyvault.v2016_10_01.models.OrganizationDetails
    :ivar attributes: Attributes of the issuer object.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.IssuerAttributes
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "credentials": {"key": "credentials", "type": "IssuerCredentials"},
        "organization_details": {"key": "org_details", "type": "OrganizationDetails"},
        "attributes": {"key": "attributes", "type": "IssuerAttributes"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        credentials: Optional["_models.IssuerCredentials"] = None,
        organization_details: Optional["_models.OrganizationDetails"] = None,
        attributes: Optional["_models.IssuerAttributes"] = None,
        **kwargs
    ):
        """
        :keyword provider: The issuer provider.
        :paramtype provider: str
        :keyword credentials: The credentials to be used for the issuer.
        :paramtype credentials: ~azure.keyvault.v2016_10_01.models.IssuerCredentials
        :keyword organization_details: Details of the organization as provided to the issuer.
        :paramtype organization_details: ~azure.keyvault.v2016_10_01.models.OrganizationDetails
        :keyword attributes: Attributes of the issuer object.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.IssuerAttributes
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.credentials = credentials
        self.organization_details = organization_details
        self.attributes = attributes


class CertificateItem(_serialization.Model):
    """The certificate item containing certificate metadata.

    :ivar id: Certificate identifier.
    :vartype id: str
    :ivar attributes: The certificate management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "x509_thumbprint": {"key": "x5t", "type": "base64"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        x509_thumbprint: Optional[bytes] = None,
        **kwargs
    ):
        """
        :keyword id: Certificate identifier.
        :paramtype id: str
        :keyword attributes: The certificate management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword x509_thumbprint: Thumbprint of the certificate.
        :paramtype x509_thumbprint: bytes
        """
        super().__init__(**kwargs)
        self.id = id
        self.attributes = attributes
        self.tags = tags
        self.x509_thumbprint = x509_thumbprint


class CertificateListResult(_serialization.Model):
    """The certificate list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of certificates in the key vault along with a
     link to the next page of certificates.
    :vartype value: list[~azure.keyvault.v2016_10_01.models.CertificateItem]
    :ivar next_link: The URL to get the next set of certificates.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CertificateItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class CertificateMergeParameters(_serialization.Model):
    """The certificate merge parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar x509_certificates: The certificate or the certificate chain to merge. Required.
    :vartype x509_certificates: list[bytes]
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "x509_certificates": {"required": True},
    }

    _attribute_map = {
        "x509_certificates": {"key": "x5c", "type": "[bytearray]"},
        "certificate_attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        x509_certificates: List[bytes],
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword x509_certificates: The certificate or the certificate chain to merge. Required.
        :paramtype x509_certificates: list[bytes]
        :keyword certificate_attributes: The attributes of the certificate (optional).
        :paramtype certificate_attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.x509_certificates = x509_certificates
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CertificateOperation(_serialization.Model):
    """A certificate operation is returned in case of asynchronous requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
    :vartype issuer_parameters: ~azure.keyvault.v2016_10_01.models.IssuerParameters
    :ivar csr: The certificate signing request (CSR) that is being used in the certificate
     operation.
    :vartype csr: bytes
    :ivar cancellation_requested: Indicates if cancellation was requested on the certificate
     operation.
    :vartype cancellation_requested: bool
    :ivar status: Status of the certificate operation.
    :vartype status: str
    :ivar status_details: The status details of the certificate operation.
    :vartype status_details: str
    :ivar error: Error encountered, if any, during the certificate operation.
    :vartype error: ~azure.keyvault.v2016_10_01.models.Error
    :ivar target: Location which contains the result of the certificate operation.
    :vartype target: str
    :ivar request_id: Identifier for the certificate operation.
    :vartype request_id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "issuer_parameters": {"key": "issuer", "type": "IssuerParameters"},
        "csr": {"key": "csr", "type": "bytearray"},
        "cancellation_requested": {"key": "cancellation_requested", "type": "bool"},
        "status": {"key": "status", "type": "str"},
        "status_details": {"key": "status_details", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "target": {"key": "target", "type": "str"},
        "request_id": {"key": "request_id", "type": "str"},
    }

    def __init__(
        self,
        *,
        issuer_parameters: Optional["_models.IssuerParameters"] = None,
        csr: Optional[bytes] = None,
        cancellation_requested: Optional[bool] = None,
        status: Optional[str] = None,
        status_details: Optional[str] = None,
        error: Optional["_models.Error"] = None,
        target: Optional[str] = None,
        request_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
        :paramtype issuer_parameters: ~azure.keyvault.v2016_10_01.models.IssuerParameters
        :keyword csr: The certificate signing request (CSR) that is being used in the certificate
         operation.
        :paramtype csr: bytes
        :keyword cancellation_requested: Indicates if cancellation was requested on the certificate
         operation.
        :paramtype cancellation_requested: bool
        :keyword status: Status of the certificate operation.
        :paramtype status: str
        :keyword status_details: The status details of the certificate operation.
        :paramtype status_details: str
        :keyword error: Error encountered, if any, during the certificate operation.
        :paramtype error: ~azure.keyvault.v2016_10_01.models.Error
        :keyword target: Location which contains the result of the certificate operation.
        :paramtype target: str
        :keyword request_id: Identifier for the certificate operation.
        :paramtype request_id: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.issuer_parameters = issuer_parameters
        self.csr = csr
        self.cancellation_requested = cancellation_requested
        self.status = status
        self.status_details = status_details
        self.error = error
        self.target = target
        self.request_id = request_id


class CertificateOperationUpdateParameter(_serialization.Model):
    """The certificate operation update parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar cancellation_requested: Indicates if cancellation was requested on the certificate
     operation. Required.
    :vartype cancellation_requested: bool
    """

    _validation = {
        "cancellation_requested": {"required": True},
    }

    _attribute_map = {
        "cancellation_requested": {"key": "cancellation_requested", "type": "bool"},
    }

    def __init__(self, *, cancellation_requested: bool, **kwargs):
        """
        :keyword cancellation_requested: Indicates if cancellation was requested on the certificate
         operation. Required.
        :paramtype cancellation_requested: bool
        """
        super().__init__(**kwargs)
        self.cancellation_requested = cancellation_requested


class CertificatePolicy(_serialization.Model):
    """Management policy for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar key_properties: Properties of the key backing a certificate.
    :vartype key_properties: ~azure.keyvault.v2016_10_01.models.KeyProperties
    :ivar secret_properties: Properties of the secret backing a certificate.
    :vartype secret_properties: ~azure.keyvault.v2016_10_01.models.SecretProperties
    :ivar x509_certificate_properties: Properties of the X509 component of a certificate.
    :vartype x509_certificate_properties:
     ~azure.keyvault.v2016_10_01.models.X509CertificateProperties
    :ivar lifetime_actions: Actions that will be performed by Key Vault over the lifetime of a
     certificate.
    :vartype lifetime_actions: list[~azure.keyvault.v2016_10_01.models.LifetimeAction]
    :ivar issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
    :vartype issuer_parameters: ~azure.keyvault.v2016_10_01.models.IssuerParameters
    :ivar attributes: The certificate attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "key_properties": {"key": "key_props", "type": "KeyProperties"},
        "secret_properties": {"key": "secret_props", "type": "SecretProperties"},
        "x509_certificate_properties": {"key": "x509_props", "type": "X509CertificateProperties"},
        "lifetime_actions": {"key": "lifetime_actions", "type": "[LifetimeAction]"},
        "issuer_parameters": {"key": "issuer", "type": "IssuerParameters"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
    }

    def __init__(
        self,
        *,
        key_properties: Optional["_models.KeyProperties"] = None,
        secret_properties: Optional["_models.SecretProperties"] = None,
        x509_certificate_properties: Optional["_models.X509CertificateProperties"] = None,
        lifetime_actions: Optional[List["_models.LifetimeAction"]] = None,
        issuer_parameters: Optional["_models.IssuerParameters"] = None,
        attributes: Optional["_models.CertificateAttributes"] = None,
        **kwargs
    ):
        """
        :keyword key_properties: Properties of the key backing a certificate.
        :paramtype key_properties: ~azure.keyvault.v2016_10_01.models.KeyProperties
        :keyword secret_properties: Properties of the secret backing a certificate.
        :paramtype secret_properties: ~azure.keyvault.v2016_10_01.models.SecretProperties
        :keyword x509_certificate_properties: Properties of the X509 component of a certificate.
        :paramtype x509_certificate_properties:
         ~azure.keyvault.v2016_10_01.models.X509CertificateProperties
        :keyword lifetime_actions: Actions that will be performed by Key Vault over the lifetime of a
         certificate.
        :paramtype lifetime_actions: list[~azure.keyvault.v2016_10_01.models.LifetimeAction]
        :keyword issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
        :paramtype issuer_parameters: ~azure.keyvault.v2016_10_01.models.IssuerParameters
        :keyword attributes: The certificate attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
        """
        super().__init__(**kwargs)
        self.id = None
        self.key_properties = key_properties
        self.secret_properties = secret_properties
        self.x509_certificate_properties = x509_certificate_properties
        self.lifetime_actions = lifetime_actions
        self.issuer_parameters = issuer_parameters
        self.attributes = attributes


class CertificateUpdateParameters(_serialization.Model):
    """The certificate update parameters.

    :ivar certificate_policy: The management policy for the certificate.
    :vartype certificate_policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "certificate_policy": {"key": "policy", "type": "CertificatePolicy"},
        "certificate_attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        certificate_policy: Optional["_models.CertificatePolicy"] = None,
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword certificate_policy: The management policy for the certificate.
        :paramtype certificate_policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :keyword certificate_attributes: The attributes of the certificate (optional).
        :paramtype certificate_attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.certificate_policy = certificate_policy
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class Contact(_serialization.Model):
    """The contact information for the vault certificates.

    :ivar email_address: Email address.
    :vartype email_address: str
    :ivar name: Name.
    :vartype name: str
    :ivar phone: Phone number.
    :vartype phone: str
    """

    _attribute_map = {
        "email_address": {"key": "email", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(
        self, *, email_address: Optional[str] = None, name: Optional[str] = None, phone: Optional[str] = None, **kwargs
    ):
        """
        :keyword email_address: Email address.
        :paramtype email_address: str
        :keyword name: Name.
        :paramtype name: str
        :keyword phone: Phone number.
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.email_address = email_address
        self.name = name
        self.phone = phone


class Contacts(_serialization.Model):
    """The contacts for the vault certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Identifier for the contacts collection.
    :vartype id: str
    :ivar contact_list: The contact list for the vault certificates.
    :vartype contact_list: list[~azure.keyvault.v2016_10_01.models.Contact]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "contact_list": {"key": "contacts", "type": "[Contact]"},
    }

    def __init__(self, *, contact_list: Optional[List["_models.Contact"]] = None, **kwargs):
        """
        :keyword contact_list: The contact list for the vault certificates.
        :paramtype contact_list: list[~azure.keyvault.v2016_10_01.models.Contact]
        """
        super().__init__(**kwargs)
        self.id = None
        self.contact_list = contact_list


class DeletedCertificateBundle(CertificateBundle):  # pylint: disable=too-many-instance-attributes
    """A Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on when it will be purged.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar kid: The key id.
    :vartype kid: str
    :ivar sid: The secret id.
    :vartype sid: str
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar policy: The management policy.
    :vartype policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :ivar cer: CER contents of x509 certificate.
    :vartype cer: bytes
    :ivar content_type: The content type of the secret.
    :vartype content_type: str
    :ivar attributes: The certificate attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     certificate.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the certificate is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the certificate was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "kid": {"readonly": True},
        "sid": {"readonly": True},
        "x509_thumbprint": {"readonly": True},
        "policy": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "kid": {"key": "kid", "type": "str"},
        "sid": {"key": "sid", "type": "str"},
        "x509_thumbprint": {"key": "x5t", "type": "base64"},
        "policy": {"key": "policy", "type": "CertificatePolicy"},
        "cer": {"key": "cer", "type": "bytearray"},
        "content_type": {"key": "contentType", "type": "str"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        cer: Optional[bytes] = None,
        content_type: Optional[str] = None,
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        recovery_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cer: CER contents of x509 certificate.
        :paramtype cer: bytes
        :keyword content_type: The content type of the secret.
        :paramtype content_type: str
        :keyword attributes: The certificate attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         certificate.
        :paramtype recovery_id: str
        """
        super().__init__(cer=cer, content_type=content_type, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class DeletedCertificateItem(CertificateItem):
    """The deleted certificate item containing metadata about the deleted certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Certificate identifier.
    :vartype id: str
    :ivar attributes: The certificate management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     certificate.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the certificate is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the certificate was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "x509_thumbprint": {"key": "x5t", "type": "base64"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        x509_thumbprint: Optional[bytes] = None,
        recovery_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Certificate identifier.
        :paramtype id: str
        :keyword attributes: The certificate management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword x509_thumbprint: Thumbprint of the certificate.
        :paramtype x509_thumbprint: bytes
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         certificate.
        :paramtype recovery_id: str
        """
        super().__init__(id=id, attributes=attributes, tags=tags, x509_thumbprint=x509_thumbprint, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class DeletedCertificateListResult(_serialization.Model):
    """A list of certificates that have been deleted in this vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of deleted certificates in the vault along
     with a link to the next page of deleted certificates.
    :vartype value: list[~azure.keyvault.v2016_10_01.models.DeletedCertificateItem]
    :ivar next_link: The URL to get the next set of deleted certificates.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedCertificateItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class KeyBundle(_serialization.Model):
    """A KeyBundle consisting of a WebKey plus its attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key: The Json web key.
    :vartype key: ~azure.keyvault.v2016_10_01.models.JsonWebKey
    :ivar attributes: The key management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    """

    _validation = {
        "managed": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "JsonWebKey"},
        "attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed": {"key": "managed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        key: Optional["_models.JsonWebKey"] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword key: The Json web key.
        :paramtype key: ~azure.keyvault.v2016_10_01.models.JsonWebKey
        :keyword attributes: The key management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.key = key
        self.attributes = attributes
        self.tags = tags
        self.managed = None


class DeletedKeyBundle(KeyBundle):
    """A DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key: The Json web key.
    :vartype key: ~azure.keyvault.v2016_10_01.models.JsonWebKey
    :ivar attributes: The key management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     key.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the key is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the key was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "managed": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "JsonWebKey"},
        "attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed": {"key": "managed", "type": "bool"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        key: Optional["_models.JsonWebKey"] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        recovery_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key: The Json web key.
        :paramtype key: ~azure.keyvault.v2016_10_01.models.JsonWebKey
        :keyword attributes: The key management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         key.
        :paramtype recovery_id: str
        """
        super().__init__(key=key, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class KeyItem(_serialization.Model):
    """The key item containing key metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar attributes: The key management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    """

    _validation = {
        "managed": {"readonly": True},
    }

    _attribute_map = {
        "kid": {"key": "kid", "type": "str"},
        "attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed": {"key": "managed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword kid: Key identifier.
        :paramtype kid: str
        :keyword attributes: The key management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.kid = kid
        self.attributes = attributes
        self.tags = tags
        self.managed = None


class DeletedKeyItem(KeyItem):
    """The deleted key item containing the deleted key metadata and information about deletion.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar attributes: The key management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     key.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the key is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the key was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "managed": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "kid": {"key": "kid", "type": "str"},
        "attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed": {"key": "managed", "type": "bool"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        recovery_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kid: Key identifier.
        :paramtype kid: str
        :keyword attributes: The key management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         key.
        :paramtype recovery_id: str
        """
        super().__init__(kid=kid, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class DeletedKeyListResult(_serialization.Model):
    """A list of keys that have been deleted in this vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of deleted keys in the vault along with a
     link to the next page of deleted keys.
    :vartype value: list[~azure.keyvault.v2016_10_01.models.DeletedKeyItem]
    :ivar next_link: The URL to get the next set of deleted keys.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedKeyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecretBundle(_serialization.Model):
    """A secret consisting of a value, id and its attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The secret value.
    :vartype value: str
    :ivar id: The secret id.
    :vartype id: str
    :ivar content_type: The content type of the secret.
    :vartype content_type: str
    :ivar attributes: The secret management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar kid: If this is a secret backing a KV certificate, then this field specifies the
     corresponding key backing the KV certificate.
    :vartype kid: str
    :ivar managed: True if the secret's lifetime is managed by key vault. If this is a secret
     backing a certificate, then managed will be true.
    :vartype managed: bool
    """

    _validation = {
        "kid": {"readonly": True},
        "managed": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "attributes": {"key": "attributes", "type": "SecretAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "kid": {"key": "kid", "type": "str"},
        "managed": {"key": "managed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        content_type: Optional[str] = None,
        attributes: Optional["_models.SecretAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword value: The secret value.
        :paramtype value: str
        :keyword id: The secret id.
        :paramtype id: str
        :keyword content_type: The content type of the secret.
        :paramtype content_type: str
        :keyword attributes: The secret management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.value = value
        self.id = id
        self.content_type = content_type
        self.attributes = attributes
        self.tags = tags
        self.kid = None
        self.managed = None


class DeletedSecretBundle(SecretBundle):
    """A Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when it will be purged.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The secret value.
    :vartype value: str
    :ivar id: The secret id.
    :vartype id: str
    :ivar content_type: The content type of the secret.
    :vartype content_type: str
    :ivar attributes: The secret management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar kid: If this is a secret backing a KV certificate, then this field specifies the
     corresponding key backing the KV certificate.
    :vartype kid: str
    :ivar managed: True if the secret's lifetime is managed by key vault. If this is a secret
     backing a certificate, then managed will be true.
    :vartype managed: bool
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     secret.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the secret is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the secret was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "kid": {"readonly": True},
        "managed": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "attributes": {"key": "attributes", "type": "SecretAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "kid": {"key": "kid", "type": "str"},
        "managed": {"key": "managed", "type": "bool"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        content_type: Optional[str] = None,
        attributes: Optional["_models.SecretAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        recovery_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The secret value.
        :paramtype value: str
        :keyword id: The secret id.
        :paramtype id: str
        :keyword content_type: The content type of the secret.
        :paramtype content_type: str
        :keyword attributes: The secret management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         secret.
        :paramtype recovery_id: str
        """
        super().__init__(value=value, id=id, content_type=content_type, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class SecretItem(_serialization.Model):
    """The secret item containing secret metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Secret identifier.
    :vartype id: str
    :ivar attributes: The secret management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar content_type: Type of the secret value such as a password.
    :vartype content_type: str
    :ivar managed: True if the secret's lifetime is managed by key vault. If this is a key backing
     a certificate, then managed will be true.
    :vartype managed: bool
    """

    _validation = {
        "managed": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "attributes": {"key": "attributes", "type": "SecretAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "content_type": {"key": "contentType", "type": "str"},
        "managed": {"key": "managed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        attributes: Optional["_models.SecretAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        content_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Secret identifier.
        :paramtype id: str
        :keyword attributes: The secret management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword content_type: Type of the secret value such as a password.
        :paramtype content_type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.attributes = attributes
        self.tags = tags
        self.content_type = content_type
        self.managed = None


class DeletedSecretItem(SecretItem):
    """The deleted secret item containing metadata about the deleted secret.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Secret identifier.
    :vartype id: str
    :ivar attributes: The secret management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar content_type: Type of the secret value such as a password.
    :vartype content_type: str
    :ivar managed: True if the secret's lifetime is managed by key vault. If this is a key backing
     a certificate, then managed will be true.
    :vartype managed: bool
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     secret.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the secret is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the secret was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "managed": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "attributes": {"key": "attributes", "type": "SecretAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "content_type": {"key": "contentType", "type": "str"},
        "managed": {"key": "managed", "type": "bool"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        attributes: Optional["_models.SecretAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        content_type: Optional[str] = None,
        recovery_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Secret identifier.
        :paramtype id: str
        :keyword attributes: The secret management attributes.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword content_type: Type of the secret value such as a password.
        :paramtype content_type: str
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         secret.
        :paramtype recovery_id: str
        """
        super().__init__(id=id, attributes=attributes, tags=tags, content_type=content_type, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class DeletedSecretListResult(_serialization.Model):
    """The deleted secret list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of the deleted secrets in the vault along
     with a link to the next page of deleted secrets.
    :vartype value: list[~azure.keyvault.v2016_10_01.models.DeletedSecretItem]
    :ivar next_link: The URL to get the next set of deleted secrets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedSecretItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Error(_serialization.Model):
    """The key vault server error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The key vault server error.
    :vartype inner_error: ~azure.keyvault.v2016_10_01.models.Error
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "inner_error": {"key": "innererror", "type": "Error"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.inner_error = None


class IssuerAttributes(_serialization.Model):
    """The attributes of an issuer managed by the Key Vault service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the issuer is enabled.
    :vartype enabled: bool
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs):
        """
        :keyword enabled: Determines whether the issuer is enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.created = None
        self.updated = None


class IssuerBundle(_serialization.Model):
    """The issuer for Key Vault certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Identifier for the issuer object.
    :vartype id: str
    :ivar provider: The issuer provider.
    :vartype provider: str
    :ivar credentials: The credentials to be used for the issuer.
    :vartype credentials: ~azure.keyvault.v2016_10_01.models.IssuerCredentials
    :ivar organization_details: Details of the organization as provided to the issuer.
    :vartype organization_details: ~azure.keyvault.v2016_10_01.models.OrganizationDetails
    :ivar attributes: Attributes of the issuer object.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.IssuerAttributes
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "credentials": {"key": "credentials", "type": "IssuerCredentials"},
        "organization_details": {"key": "org_details", "type": "OrganizationDetails"},
        "attributes": {"key": "attributes", "type": "IssuerAttributes"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        credentials: Optional["_models.IssuerCredentials"] = None,
        organization_details: Optional["_models.OrganizationDetails"] = None,
        attributes: Optional["_models.IssuerAttributes"] = None,
        **kwargs
    ):
        """
        :keyword provider: The issuer provider.
        :paramtype provider: str
        :keyword credentials: The credentials to be used for the issuer.
        :paramtype credentials: ~azure.keyvault.v2016_10_01.models.IssuerCredentials
        :keyword organization_details: Details of the organization as provided to the issuer.
        :paramtype organization_details: ~azure.keyvault.v2016_10_01.models.OrganizationDetails
        :keyword attributes: Attributes of the issuer object.
        :paramtype attributes: ~azure.keyvault.v2016_10_01.models.IssuerAttributes
        """
        super().__init__(**kwargs)
        self.id = None
        self.provider = provider
        self.credentials = credentials
        self.organization_details = organization_details
        self.attributes = attributes


class IssuerCredentials(_serialization.Model):
    """The credentials to be used for the certificate issuer.

    :ivar account_id: The user name/account name/account id.
    :vartype account_id: str
    :ivar password: The password/secret/account key.
    :vartype password: str
    """

    _attribute_map = {
        "account_id": {"key": "account_id", "type": "str"},
        "password": {"key": "pwd", "type": "str"},
    }

    def __init__(self, *, account_id: Optional[str] = None, password: Optional[str] = None, **kwargs):
        """
        :keyword account_id: The user name/account name/account id.
        :paramtype account_id: str
        :keyword password: The password/secret/account key.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.account_id = account_id
        self.password = password


class IssuerParameters(_serialization.Model):
    """Parameters for the issuer of the X509 component of a certificate.

    :ivar name: Name of the referenced issuer object or reserved names; for example, 'Self' or
     'Unknown'.
    :vartype name: str
    :ivar certificate_type: Type of certificate to be requested from the issuer provider.
    :vartype certificate_type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "certificate_type": {"key": "cty", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, certificate_type: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the referenced issuer object or reserved names; for example, 'Self' or
         'Unknown'.
        :paramtype name: str
        :keyword certificate_type: Type of certificate to be requested from the issuer provider.
        :paramtype certificate_type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.certificate_type = certificate_type


class JsonWebKey(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """As of http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar kty: JsonWebKey key type (kty). Known values are: "EC", "EC-HSM", "RSA", "RSA-HSM", and
     "oct".
    :vartype kty: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyType
    :ivar key_ops:
    :vartype key_ops: list[str]
    :ivar n: RSA modulus.
    :vartype n: bytes
    :ivar e: RSA public exponent.
    :vartype e: bytes
    :ivar d: RSA private exponent, or the D component of an EC private key.
    :vartype d: bytes
    :ivar dp: RSA private key parameter.
    :vartype dp: bytes
    :ivar dq: RSA private key parameter.
    :vartype dq: bytes
    :ivar qi: RSA private key parameter.
    :vartype qi: bytes
    :ivar p: RSA secret prime.
    :vartype p: bytes
    :ivar q: RSA secret prime, with p < q.
    :vartype q: bytes
    :ivar k: Symmetric key.
    :vartype k: bytes
    :ivar t: HSM Token, used with 'Bring Your Own Key'.
    :vartype t: bytes
    :ivar crv: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
     "P-256", "P-384", "P-521", and "SECP256K1".
    :vartype crv: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyCurveName
    :ivar x: X component of an EC public key.
    :vartype x: bytes
    :ivar y: Y component of an EC public key.
    :vartype y: bytes
    """

    _attribute_map = {
        "kid": {"key": "kid", "type": "str"},
        "kty": {"key": "kty", "type": "str"},
        "key_ops": {"key": "key_ops", "type": "[str]"},
        "n": {"key": "n", "type": "base64"},
        "e": {"key": "e", "type": "base64"},
        "d": {"key": "d", "type": "base64"},
        "dp": {"key": "dp", "type": "base64"},
        "dq": {"key": "dq", "type": "base64"},
        "qi": {"key": "qi", "type": "base64"},
        "p": {"key": "p", "type": "base64"},
        "q": {"key": "q", "type": "base64"},
        "k": {"key": "k", "type": "base64"},
        "t": {"key": "key_hsm", "type": "base64"},
        "crv": {"key": "crv", "type": "str"},
        "x": {"key": "x", "type": "base64"},
        "y": {"key": "y", "type": "base64"},
    }

    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        kty: Optional[Union[str, "_models.JsonWebKeyType"]] = None,
        key_ops: Optional[List[str]] = None,
        n: Optional[bytes] = None,
        e: Optional[bytes] = None,
        d: Optional[bytes] = None,
        dp: Optional[bytes] = None,
        dq: Optional[bytes] = None,
        qi: Optional[bytes] = None,
        p: Optional[bytes] = None,
        q: Optional[bytes] = None,
        k: Optional[bytes] = None,
        t: Optional[bytes] = None,
        crv: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        x: Optional[bytes] = None,
        y: Optional[bytes] = None,
        **kwargs
    ):
        """
        :keyword kid: Key identifier.
        :paramtype kid: str
        :keyword kty: JsonWebKey key type (kty). Known values are: "EC", "EC-HSM", "RSA", "RSA-HSM",
         and "oct".
        :paramtype kty: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyType
        :keyword key_ops:
        :paramtype key_ops: list[str]
        :keyword n: RSA modulus.
        :paramtype n: bytes
        :keyword e: RSA public exponent.
        :paramtype e: bytes
        :keyword d: RSA private exponent, or the D component of an EC private key.
        :paramtype d: bytes
        :keyword dp: RSA private key parameter.
        :paramtype dp: bytes
        :keyword dq: RSA private key parameter.
        :paramtype dq: bytes
        :keyword qi: RSA private key parameter.
        :paramtype qi: bytes
        :keyword p: RSA secret prime.
        :paramtype p: bytes
        :keyword q: RSA secret prime, with p < q.
        :paramtype q: bytes
        :keyword k: Symmetric key.
        :paramtype k: bytes
        :keyword t: HSM Token, used with 'Bring Your Own Key'.
        :paramtype t: bytes
        :keyword crv: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
         "P-256", "P-384", "P-521", and "SECP256K1".
        :paramtype crv: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyCurveName
        :keyword x: X component of an EC public key.
        :paramtype x: bytes
        :keyword y: Y component of an EC public key.
        :paramtype y: bytes
        """
        super().__init__(**kwargs)
        self.kid = kid
        self.kty = kty
        self.key_ops = key_ops
        self.n = n
        self.e = e
        self.d = d
        self.dp = dp
        self.dq = dq
        self.qi = qi
        self.p = p
        self.q = q
        self.k = k
        self.t = t
        self.crv = crv
        self.x = x
        self.y = y


class KeyAttributes(Attributes):
    """The attributes of a key managed by the key vault service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    :ivar recovery_level: Reflects the deletion recovery level currently in effect for keys in the
     current vault. If it contains 'Purgeable' the key can be permanently deleted by a privileged
     user; otherwise, only the system can purge the key, at the end of the retention interval. Known
     values are: "Purgeable", "Recoverable+Purgeable", "Recoverable", and
     "Recoverable+ProtectedSubscription".
    :vartype recovery_level: str or ~azure.keyvault.v2016_10_01.models.DeletionRecoveryLevel
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
        "recovery_level": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "not_before": {"key": "nbf", "type": "unix-time"},
        "expires": {"key": "exp", "type": "unix-time"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
        "recovery_level": {"key": "recoveryLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword enabled: Determines whether the object is enabled.
        :paramtype enabled: bool
        :keyword not_before: Not before date in UTC.
        :paramtype not_before: ~datetime.datetime
        :keyword expires: Expiry date in UTC.
        :paramtype expires: ~datetime.datetime
        """
        super().__init__(enabled=enabled, not_before=not_before, expires=expires, **kwargs)
        self.recovery_level = None


class KeyCreateParameters(_serialization.Model):
    """The key create parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar kty: The type of key to create. For valid values, see JsonWebKeyType. Required. Known
     values are: "EC", "EC-HSM", "RSA", "RSA-HSM", and "oct".
    :vartype kty: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyType
    :ivar key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
    :vartype key_size: int
    :ivar key_ops:
    :vartype key_ops: list[str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyOperation]
    :ivar key_attributes: The attributes of a key managed by the key vault service.
    :vartype key_attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
     "P-256", "P-384", "P-521", and "SECP256K1".
    :vartype curve: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyCurveName
    """

    _validation = {
        "kty": {"required": True},
    }

    _attribute_map = {
        "kty": {"key": "kty", "type": "str"},
        "key_size": {"key": "key_size", "type": "int"},
        "key_ops": {"key": "key_ops", "type": "[str]"},
        "key_attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "curve": {"key": "crv", "type": "str"},
    }

    def __init__(
        self,
        *,
        kty: Union[str, "_models.JsonWebKeyType"],
        key_size: Optional[int] = None,
        key_ops: Optional[List[Union[str, "_models.JsonWebKeyOperation"]]] = None,
        key_attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        curve: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        **kwargs
    ):
        """
        :keyword kty: The type of key to create. For valid values, see JsonWebKeyType. Required. Known
         values are: "EC", "EC-HSM", "RSA", "RSA-HSM", and "oct".
        :paramtype kty: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyType
        :keyword key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
        :paramtype key_size: int
        :keyword key_ops:
        :paramtype key_ops: list[str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyOperation]
        :keyword key_attributes: The attributes of a key managed by the key vault service.
        :paramtype key_attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values
         are: "P-256", "P-384", "P-521", and "SECP256K1".
        :paramtype curve: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyCurveName
        """
        super().__init__(**kwargs)
        self.kty = kty
        self.key_size = key_size
        self.key_ops = key_ops
        self.key_attributes = key_attributes
        self.tags = tags
        self.curve = curve


class KeyImportParameters(_serialization.Model):
    """The key import parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar hsm: Whether to import as a hardware key (HSM) or software key.
    :vartype hsm: bool
    :ivar key: The Json web key. Required.
    :vartype key: ~azure.keyvault.v2016_10_01.models.JsonWebKey
    :ivar key_attributes: The key management attributes.
    :vartype key_attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "key": {"required": True},
    }

    _attribute_map = {
        "hsm": {"key": "Hsm", "type": "bool"},
        "key": {"key": "key", "type": "JsonWebKey"},
        "key_attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        key: "_models.JsonWebKey",
        hsm: Optional[bool] = None,
        key_attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword hsm: Whether to import as a hardware key (HSM) or software key.
        :paramtype hsm: bool
        :keyword key: The Json web key. Required.
        :paramtype key: ~azure.keyvault.v2016_10_01.models.JsonWebKey
        :keyword key_attributes: The key management attributes.
        :paramtype key_attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.hsm = hsm
        self.key = key
        self.key_attributes = key_attributes
        self.tags = tags


class KeyListResult(_serialization.Model):
    """The key list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of keys in the key vault along with a link to
     the next page of keys.
    :vartype value: list[~azure.keyvault.v2016_10_01.models.KeyItem]
    :ivar next_link: The URL to get the next set of keys.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[KeyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class KeyOperationResult(_serialization.Model):
    """The key operation result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar result:
    :vartype result: bytes
    """

    _validation = {
        "kid": {"readonly": True},
        "result": {"readonly": True},
    }

    _attribute_map = {
        "kid": {"key": "kid", "type": "str"},
        "result": {"key": "value", "type": "base64"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kid = None
        self.result = None


class KeyOperationsParameters(_serialization.Model):
    """The key operations parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar algorithm: algorithm identifier. Required. Known values are: "RSA-OAEP", "RSA-OAEP-256",
     and "RSA1_5".
    :vartype algorithm: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyEncryptionAlgorithm
    :ivar value: Required.
    :vartype value: bytes
    """

    _validation = {
        "algorithm": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "algorithm": {"key": "alg", "type": "str"},
        "value": {"key": "value", "type": "base64"},
    }

    def __init__(self, *, algorithm: Union[str, "_models.JsonWebKeyEncryptionAlgorithm"], value: bytes, **kwargs):
        """
        :keyword algorithm: algorithm identifier. Required. Known values are: "RSA-OAEP",
         "RSA-OAEP-256", and "RSA1_5".
        :paramtype algorithm: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyEncryptionAlgorithm
        :keyword value: Required.
        :paramtype value: bytes
        """
        super().__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value


class KeyProperties(_serialization.Model):
    """Properties of the key pair backing a certificate.

    :ivar exportable: Indicates if the private key can be exported.
    :vartype exportable: bool
    :ivar key_type: The key type.
    :vartype key_type: str
    :ivar key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
    :vartype key_size: int
    :ivar reuse_key: Indicates if the same key pair will be used on certificate renewal.
    :vartype reuse_key: bool
    """

    _attribute_map = {
        "exportable": {"key": "exportable", "type": "bool"},
        "key_type": {"key": "kty", "type": "str"},
        "key_size": {"key": "key_size", "type": "int"},
        "reuse_key": {"key": "reuse_key", "type": "bool"},
    }

    def __init__(
        self,
        *,
        exportable: Optional[bool] = None,
        key_type: Optional[str] = None,
        key_size: Optional[int] = None,
        reuse_key: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword exportable: Indicates if the private key can be exported.
        :paramtype exportable: bool
        :keyword key_type: The key type.
        :paramtype key_type: str
        :keyword key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
        :paramtype key_size: int
        :keyword reuse_key: Indicates if the same key pair will be used on certificate renewal.
        :paramtype reuse_key: bool
        """
        super().__init__(**kwargs)
        self.exportable = exportable
        self.key_type = key_type
        self.key_size = key_size
        self.reuse_key = reuse_key


class KeyRestoreParameters(_serialization.Model):
    """The key restore parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar key_bundle_backup: The backup blob associated with a key bundle. Required.
    :vartype key_bundle_backup: bytes
    """

    _validation = {
        "key_bundle_backup": {"required": True},
    }

    _attribute_map = {
        "key_bundle_backup": {"key": "value", "type": "base64"},
    }

    def __init__(self, *, key_bundle_backup: bytes, **kwargs):
        """
        :keyword key_bundle_backup: The backup blob associated with a key bundle. Required.
        :paramtype key_bundle_backup: bytes
        """
        super().__init__(**kwargs)
        self.key_bundle_backup = key_bundle_backup


class KeySignParameters(_serialization.Model):
    """The key operations parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar algorithm: The signing/verification algorithm identifier. For more information on
     possible algorithm types, see JsonWebKeySignatureAlgorithm. Required. Known values are:
     "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "RSNULL", "ES256", "ES384", "ES512", and
     "ECDSA256".
    :vartype algorithm: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeySignatureAlgorithm
    :ivar value: Required.
    :vartype value: bytes
    """

    _validation = {
        "algorithm": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "algorithm": {"key": "alg", "type": "str"},
        "value": {"key": "value", "type": "base64"},
    }

    def __init__(self, *, algorithm: Union[str, "_models.JsonWebKeySignatureAlgorithm"], value: bytes, **kwargs):
        """
        :keyword algorithm: The signing/verification algorithm identifier. For more information on
         possible algorithm types, see JsonWebKeySignatureAlgorithm. Required. Known values are:
         "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "RSNULL", "ES256", "ES384", "ES512", and
         "ECDSA256".
        :paramtype algorithm: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeySignatureAlgorithm
        :keyword value: Required.
        :paramtype value: bytes
        """
        super().__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value


class KeyUpdateParameters(_serialization.Model):
    """The key update parameters.

    :ivar key_ops: Json web key operations. For more information on possible key operations, see
     JsonWebKeyOperation.
    :vartype key_ops: list[str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyOperation]
    :ivar key_attributes: The attributes of a key managed by the key vault service.
    :vartype key_attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "key_ops": {"key": "key_ops", "type": "[str]"},
        "key_attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        key_ops: Optional[List[Union[str, "_models.JsonWebKeyOperation"]]] = None,
        key_attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword key_ops: Json web key operations. For more information on possible key operations, see
         JsonWebKeyOperation.
        :paramtype key_ops: list[str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyOperation]
        :keyword key_attributes: The attributes of a key managed by the key vault service.
        :paramtype key_attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.key_ops = key_ops
        self.key_attributes = key_attributes
        self.tags = tags


class KeyVaultError(_serialization.Model):
    """The key vault error exception.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The key vault server error.
    :vartype error: ~azure.keyvault.v2016_10_01.models.Error
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.error = None


class KeyVerifyParameters(_serialization.Model):
    """The key verify parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar algorithm: The signing/verification algorithm. For more information on possible algorithm
     types, see JsonWebKeySignatureAlgorithm. Required. Known values are: "PS256", "PS384", "PS512",
     "RS256", "RS384", "RS512", "RSNULL", "ES256", "ES384", "ES512", and "ECDSA256".
    :vartype algorithm: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeySignatureAlgorithm
    :ivar digest: The digest used for signing. Required.
    :vartype digest: bytes
    :ivar signature: The signature to be verified. Required.
    :vartype signature: bytes
    """

    _validation = {
        "algorithm": {"required": True},
        "digest": {"required": True},
        "signature": {"required": True},
    }

    _attribute_map = {
        "algorithm": {"key": "alg", "type": "str"},
        "digest": {"key": "digest", "type": "base64"},
        "signature": {"key": "value", "type": "base64"},
    }

    def __init__(
        self,
        *,
        algorithm: Union[str, "_models.JsonWebKeySignatureAlgorithm"],
        digest: bytes,
        signature: bytes,
        **kwargs
    ):
        """
        :keyword algorithm: The signing/verification algorithm. For more information on possible
         algorithm types, see JsonWebKeySignatureAlgorithm. Required. Known values are: "PS256",
         "PS384", "PS512", "RS256", "RS384", "RS512", "RSNULL", "ES256", "ES384", "ES512", and
         "ECDSA256".
        :paramtype algorithm: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeySignatureAlgorithm
        :keyword digest: The digest used for signing. Required.
        :paramtype digest: bytes
        :keyword signature: The signature to be verified. Required.
        :paramtype signature: bytes
        """
        super().__init__(**kwargs)
        self.algorithm = algorithm
        self.digest = digest
        self.signature = signature


class KeyVerifyResult(_serialization.Model):
    """The key verify result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: True if the signature is verified, otherwise false.
    :vartype value: bool
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class LifetimeAction(_serialization.Model):
    """Action and its trigger that will be performed by Key Vault over the lifetime of a certificate.

    :ivar trigger: The condition that will execute the action.
    :vartype trigger: ~azure.keyvault.v2016_10_01.models.Trigger
    :ivar action: The action that will be executed.
    :vartype action: ~azure.keyvault.v2016_10_01.models.Action
    """

    _attribute_map = {
        "trigger": {"key": "trigger", "type": "Trigger"},
        "action": {"key": "action", "type": "Action"},
    }

    def __init__(
        self, *, trigger: Optional["_models.Trigger"] = None, action: Optional["_models.Action"] = None, **kwargs
    ):
        """
        :keyword trigger: The condition that will execute the action.
        :paramtype trigger: ~azure.keyvault.v2016_10_01.models.Trigger
        :keyword action: The action that will be executed.
        :paramtype action: ~azure.keyvault.v2016_10_01.models.Action
        """
        super().__init__(**kwargs)
        self.trigger = trigger
        self.action = action


class OrganizationDetails(_serialization.Model):
    """Details of the organization of the certificate issuer.

    :ivar id: Id of the organization.
    :vartype id: str
    :ivar admin_details: Details of the organization administrator.
    :vartype admin_details: list[~azure.keyvault.v2016_10_01.models.AdministratorDetails]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "admin_details": {"key": "admin_details", "type": "[AdministratorDetails]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        admin_details: Optional[List["_models.AdministratorDetails"]] = None,
        **kwargs
    ):
        """
        :keyword id: Id of the organization.
        :paramtype id: str
        :keyword admin_details: Details of the organization administrator.
        :paramtype admin_details: list[~azure.keyvault.v2016_10_01.models.AdministratorDetails]
        """
        super().__init__(**kwargs)
        self.id = id
        self.admin_details = admin_details


class PendingCertificateSigningRequestResult(_serialization.Model):
    """The pending certificate signing request result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The pending certificate signing request as Base64 encoded string.
    :vartype value: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class SasDefinitionAttributes(_serialization.Model):
    """The SAS definition management attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: the enabled state of the object.
    :vartype enabled: bool
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs):
        """
        :keyword enabled: the enabled state of the object.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.created = None
        self.updated = None


class SasDefinitionBundle(_serialization.Model):
    """A SAS definition bundle consists of key vault SAS definition details plus its attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The SAS definition id.
    :vartype id: str
    :ivar secret_id: Storage account SAS definition secret id.
    :vartype secret_id: str
    :ivar parameters: The SAS definition metadata in the form of key-value pairs.
    :vartype parameters: dict[str, str]
    :ivar attributes: The SAS definition attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "secret_id": {"readonly": True},
        "parameters": {"readonly": True},
        "attributes": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "secret_id": {"key": "sid", "type": "str"},
        "parameters": {"key": "parameters", "type": "{str}"},
        "attributes": {"key": "attributes", "type": "SasDefinitionAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.secret_id = None
        self.parameters = None
        self.attributes = None
        self.tags = None


class SasDefinitionCreateParameters(_serialization.Model):
    """The SAS definition create parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar parameters: Sas definition creation metadata in the form of key-value pairs. Required.
    :vartype parameters: dict[str, str]
    :ivar sas_definition_attributes: The attributes of the SAS definition.
    :vartype sas_definition_attributes: ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "parameters": {"required": True},
    }

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "{str}"},
        "sas_definition_attributes": {"key": "attributes", "type": "SasDefinitionAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        parameters: Dict[str, str],
        sas_definition_attributes: Optional["_models.SasDefinitionAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword parameters: Sas definition creation metadata in the form of key-value pairs. Required.
        :paramtype parameters: dict[str, str]
        :keyword sas_definition_attributes: The attributes of the SAS definition.
        :paramtype sas_definition_attributes:
         ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.sas_definition_attributes = sas_definition_attributes
        self.tags = tags


class SasDefinitionItem(_serialization.Model):
    """The SAS definition item containing storage SAS definition metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The storage SAS identifier.
    :vartype id: str
    :ivar secret_id: The storage account SAS definition secret id.
    :vartype secret_id: str
    :ivar attributes: The SAS definition management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "secret_id": {"readonly": True},
        "attributes": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "secret_id": {"key": "sid", "type": "str"},
        "attributes": {"key": "attributes", "type": "SasDefinitionAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.secret_id = None
        self.attributes = None
        self.tags = None


class SasDefinitionListResult(_serialization.Model):
    """The storage account SAS definition list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of SAS definitions along with a link to the
     next page of SAS definitions.
    :vartype value: list[~azure.keyvault.v2016_10_01.models.SasDefinitionItem]
    :ivar next_link: The URL to get the next set of SAS definitions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SasDefinitionItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SasDefinitionUpdateParameters(_serialization.Model):
    """The SAS definition update parameters.

    :ivar parameters: Sas definition update metadata in the form of key-value pairs.
    :vartype parameters: dict[str, str]
    :ivar sas_definition_attributes: The attributes of the SAS definition.
    :vartype sas_definition_attributes: ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "{str}"},
        "sas_definition_attributes": {"key": "attributes", "type": "SasDefinitionAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        parameters: Optional[Dict[str, str]] = None,
        sas_definition_attributes: Optional["_models.SasDefinitionAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword parameters: Sas definition update metadata in the form of key-value pairs.
        :paramtype parameters: dict[str, str]
        :keyword sas_definition_attributes: The attributes of the SAS definition.
        :paramtype sas_definition_attributes:
         ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.sas_definition_attributes = sas_definition_attributes
        self.tags = tags


class SecretAttributes(Attributes):
    """The secret management attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    :ivar recovery_level: Reflects the deletion recovery level currently in effect for secrets in
     the current vault. If it contains 'Purgeable', the secret can be permanently deleted by a
     privileged user; otherwise, only the system can purge the secret, at the end of the retention
     interval. Known values are: "Purgeable", "Recoverable+Purgeable", "Recoverable", and
     "Recoverable+ProtectedSubscription".
    :vartype recovery_level: str or ~azure.keyvault.v2016_10_01.models.DeletionRecoveryLevel
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
        "recovery_level": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "not_before": {"key": "nbf", "type": "unix-time"},
        "expires": {"key": "exp", "type": "unix-time"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
        "recovery_level": {"key": "recoveryLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword enabled: Determines whether the object is enabled.
        :paramtype enabled: bool
        :keyword not_before: Not before date in UTC.
        :paramtype not_before: ~datetime.datetime
        :keyword expires: Expiry date in UTC.
        :paramtype expires: ~datetime.datetime
        """
        super().__init__(enabled=enabled, not_before=not_before, expires=expires, **kwargs)
        self.recovery_level = None


class SecretListResult(_serialization.Model):
    """The secret list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of secrets in the key vault along with a link
     to the next page of secrets.
    :vartype value: list[~azure.keyvault.v2016_10_01.models.SecretItem]
    :ivar next_link: The URL to get the next set of secrets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecretItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecretProperties(_serialization.Model):
    """Properties of the key backing a certificate.

    :ivar content_type: The media type (MIME type).
    :vartype content_type: str
    """

    _attribute_map = {
        "content_type": {"key": "contentType", "type": "str"},
    }

    def __init__(self, *, content_type: Optional[str] = None, **kwargs):
        """
        :keyword content_type: The media type (MIME type).
        :paramtype content_type: str
        """
        super().__init__(**kwargs)
        self.content_type = content_type


class SecretRestoreParameters(_serialization.Model):
    """The secret restore parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_bundle_backup: The backup blob associated with a secret bundle. Required.
    :vartype secret_bundle_backup: bytes
    """

    _validation = {
        "secret_bundle_backup": {"required": True},
    }

    _attribute_map = {
        "secret_bundle_backup": {"key": "value", "type": "base64"},
    }

    def __init__(self, *, secret_bundle_backup: bytes, **kwargs):
        """
        :keyword secret_bundle_backup: The backup blob associated with a secret bundle. Required.
        :paramtype secret_bundle_backup: bytes
        """
        super().__init__(**kwargs)
        self.secret_bundle_backup = secret_bundle_backup


class SecretSetParameters(_serialization.Model):
    """The secret set parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The value of the secret. Required.
    :vartype value: str
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar content_type: Type of the secret value such as a password.
    :vartype content_type: str
    :ivar secret_attributes: The secret management attributes.
    :vartype secret_attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "content_type": {"key": "contentType", "type": "str"},
        "secret_attributes": {"key": "attributes", "type": "SecretAttributes"},
    }

    def __init__(
        self,
        *,
        value: str,
        tags: Optional[Dict[str, str]] = None,
        content_type: Optional[str] = None,
        secret_attributes: Optional["_models.SecretAttributes"] = None,
        **kwargs
    ):
        """
        :keyword value: The value of the secret. Required.
        :paramtype value: str
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword content_type: Type of the secret value such as a password.
        :paramtype content_type: str
        :keyword secret_attributes: The secret management attributes.
        :paramtype secret_attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
        """
        super().__init__(**kwargs)
        self.value = value
        self.tags = tags
        self.content_type = content_type
        self.secret_attributes = secret_attributes


class SecretUpdateParameters(_serialization.Model):
    """The secret update parameters.

    :ivar content_type: Type of the secret value such as a password.
    :vartype content_type: str
    :ivar secret_attributes: The secret management attributes.
    :vartype secret_attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "content_type": {"key": "contentType", "type": "str"},
        "secret_attributes": {"key": "attributes", "type": "SecretAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        content_type: Optional[str] = None,
        secret_attributes: Optional["_models.SecretAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword content_type: Type of the secret value such as a password.
        :paramtype content_type: str
        :keyword secret_attributes: The secret management attributes.
        :paramtype secret_attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.content_type = content_type
        self.secret_attributes = secret_attributes
        self.tags = tags


class StorageAccountAttributes(_serialization.Model):
    """The storage account management attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: the enabled state of the object.
    :vartype enabled: bool
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs):
        """
        :keyword enabled: the enabled state of the object.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.created = None
        self.updated = None


class StorageAccountCreateParameters(_serialization.Model):
    """The storage account create parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: Storage account resource id. Required.
    :vartype resource_id: str
    :ivar active_key_name: Current active storage account key name. Required.
    :vartype active_key_name: str
    :ivar auto_regenerate_key: whether keyvault should manage the storage account for the user.
     Required.
    :vartype auto_regenerate_key: bool
    :ivar regeneration_period: The key regeneration time duration specified in ISO-8601 format.
    :vartype regeneration_period: str
    :ivar storage_account_attributes: The attributes of the storage account.
    :vartype storage_account_attributes:
     ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "resource_id": {"required": True},
        "active_key_name": {"required": True},
        "auto_regenerate_key": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "active_key_name": {"key": "activeKeyName", "type": "str"},
        "auto_regenerate_key": {"key": "autoRegenerateKey", "type": "bool"},
        "regeneration_period": {"key": "regenerationPeriod", "type": "str"},
        "storage_account_attributes": {"key": "attributes", "type": "StorageAccountAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        active_key_name: str,
        auto_regenerate_key: bool,
        regeneration_period: Optional[str] = None,
        storage_account_attributes: Optional["_models.StorageAccountAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword resource_id: Storage account resource id. Required.
        :paramtype resource_id: str
        :keyword active_key_name: Current active storage account key name. Required.
        :paramtype active_key_name: str
        :keyword auto_regenerate_key: whether keyvault should manage the storage account for the user.
         Required.
        :paramtype auto_regenerate_key: bool
        :keyword regeneration_period: The key regeneration time duration specified in ISO-8601 format.
        :paramtype regeneration_period: str
        :keyword storage_account_attributes: The attributes of the storage account.
        :paramtype storage_account_attributes:
         ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.active_key_name = active_key_name
        self.auto_regenerate_key = auto_regenerate_key
        self.regeneration_period = regeneration_period
        self.storage_account_attributes = storage_account_attributes
        self.tags = tags


class StorageAccountItem(_serialization.Model):
    """The storage account item containing storage account metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Storage identifier.
    :vartype id: str
    :ivar resource_id: Storage account resource Id.
    :vartype resource_id: str
    :ivar attributes: The storage account management attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "resource_id": {"readonly": True},
        "attributes": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "attributes": {"key": "attributes", "type": "StorageAccountAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.resource_id = None
        self.attributes = None
        self.tags = None


class StorageAccountRegenerteKeyParameters(_serialization.Model):
    """The storage account key regenerate parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: The storage account key name. Required.
    :vartype key_name: str
    """

    _validation = {
        "key_name": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, *, key_name: str, **kwargs):
        """
        :keyword key_name: The storage account key name. Required.
        :paramtype key_name: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name


class StorageAccountUpdateParameters(_serialization.Model):
    """The storage account update parameters.

    :ivar active_key_name: The current active storage account key name.
    :vartype active_key_name: str
    :ivar auto_regenerate_key: whether keyvault should manage the storage account for the user.
    :vartype auto_regenerate_key: bool
    :ivar regeneration_period: The key regeneration time duration specified in ISO-8601 format.
    :vartype regeneration_period: str
    :ivar storage_account_attributes: The attributes of the storage account.
    :vartype storage_account_attributes:
     ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "active_key_name": {"key": "activeKeyName", "type": "str"},
        "auto_regenerate_key": {"key": "autoRegenerateKey", "type": "bool"},
        "regeneration_period": {"key": "regenerationPeriod", "type": "str"},
        "storage_account_attributes": {"key": "attributes", "type": "StorageAccountAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        active_key_name: Optional[str] = None,
        auto_regenerate_key: Optional[bool] = None,
        regeneration_period: Optional[str] = None,
        storage_account_attributes: Optional["_models.StorageAccountAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword active_key_name: The current active storage account key name.
        :paramtype active_key_name: str
        :keyword auto_regenerate_key: whether keyvault should manage the storage account for the user.
        :paramtype auto_regenerate_key: bool
        :keyword regeneration_period: The key regeneration time duration specified in ISO-8601 format.
        :paramtype regeneration_period: str
        :keyword storage_account_attributes: The attributes of the storage account.
        :paramtype storage_account_attributes:
         ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.active_key_name = active_key_name
        self.auto_regenerate_key = auto_regenerate_key
        self.regeneration_period = regeneration_period
        self.storage_account_attributes = storage_account_attributes
        self.tags = tags


class StorageBundle(_serialization.Model):
    """A Storage account bundle consists of key vault storage account details plus its attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The storage account id.
    :vartype id: str
    :ivar resource_id: The storage account resource id.
    :vartype resource_id: str
    :ivar active_key_name: The current active storage account key name.
    :vartype active_key_name: str
    :ivar auto_regenerate_key: whether keyvault should manage the storage account for the user.
    :vartype auto_regenerate_key: bool
    :ivar regeneration_period: The key regeneration time duration specified in ISO-8601 format.
    :vartype regeneration_period: str
    :ivar attributes: The storage account attributes.
    :vartype attributes: ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "resource_id": {"readonly": True},
        "active_key_name": {"readonly": True},
        "auto_regenerate_key": {"readonly": True},
        "regeneration_period": {"readonly": True},
        "attributes": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "active_key_name": {"key": "activeKeyName", "type": "str"},
        "auto_regenerate_key": {"key": "autoRegenerateKey", "type": "bool"},
        "regeneration_period": {"key": "regenerationPeriod", "type": "str"},
        "attributes": {"key": "attributes", "type": "StorageAccountAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.resource_id = None
        self.active_key_name = None
        self.auto_regenerate_key = None
        self.regeneration_period = None
        self.attributes = None
        self.tags = None


class StorageListResult(_serialization.Model):
    """The storage accounts list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of storage accounts in the key vault along
     with a link to the next page of storage accounts.
    :vartype value: list[~azure.keyvault.v2016_10_01.models.StorageAccountItem]
    :ivar next_link: The URL to get the next set of storage accounts.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageAccountItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SubjectAlternativeNames(_serialization.Model):
    """The subject alternate names of a X509 object.

    :ivar emails: Email addresses.
    :vartype emails: list[str]
    :ivar dns_names: Domain names.
    :vartype dns_names: list[str]
    :ivar upns: User principal names.
    :vartype upns: list[str]
    """

    _attribute_map = {
        "emails": {"key": "emails", "type": "[str]"},
        "dns_names": {"key": "dns_names", "type": "[str]"},
        "upns": {"key": "upns", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        emails: Optional[List[str]] = None,
        dns_names: Optional[List[str]] = None,
        upns: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword emails: Email addresses.
        :paramtype emails: list[str]
        :keyword dns_names: Domain names.
        :paramtype dns_names: list[str]
        :keyword upns: User principal names.
        :paramtype upns: list[str]
        """
        super().__init__(**kwargs)
        self.emails = emails
        self.dns_names = dns_names
        self.upns = upns


class Trigger(_serialization.Model):
    """A condition to be satisfied for an action to be executed.

    :ivar lifetime_percentage: Percentage of lifetime at which to trigger. Value should be between
     1 and 99.
    :vartype lifetime_percentage: int
    :ivar days_before_expiry: Days before expiry to attempt renewal. Value should be between 1 and
     validity_in_months multiplied by 27. If validity_in_months is 36, then value should be between
     1 and 972 (36 * 27).
    :vartype days_before_expiry: int
    """

    _validation = {
        "lifetime_percentage": {"maximum": 99, "minimum": 1},
    }

    _attribute_map = {
        "lifetime_percentage": {"key": "lifetime_percentage", "type": "int"},
        "days_before_expiry": {"key": "days_before_expiry", "type": "int"},
    }

    def __init__(
        self, *, lifetime_percentage: Optional[int] = None, days_before_expiry: Optional[int] = None, **kwargs
    ):
        """
        :keyword lifetime_percentage: Percentage of lifetime at which to trigger. Value should be
         between 1 and 99.
        :paramtype lifetime_percentage: int
        :keyword days_before_expiry: Days before expiry to attempt renewal. Value should be between 1
         and validity_in_months multiplied by 27. If validity_in_months is 36, then value should be
         between 1 and 972 (36 * 27).
        :paramtype days_before_expiry: int
        """
        super().__init__(**kwargs)
        self.lifetime_percentage = lifetime_percentage
        self.days_before_expiry = days_before_expiry


class X509CertificateProperties(_serialization.Model):
    """Properties of the X509 component of a certificate.

    :ivar subject: The subject name. Should be a valid X509 distinguished Name.
    :vartype subject: str
    :ivar ekus: The enhanced key usage.
    :vartype ekus: list[str]
    :ivar subject_alternative_names: The subject alternative names.
    :vartype subject_alternative_names: ~azure.keyvault.v2016_10_01.models.SubjectAlternativeNames
    :ivar key_usage: List of key usages.
    :vartype key_usage: list[str or ~azure.keyvault.v2016_10_01.models.KeyUsageType]
    :ivar validity_in_months: The duration that the certificate is valid in months.
    :vartype validity_in_months: int
    """

    _validation = {
        "validity_in_months": {"minimum": 0},
    }

    _attribute_map = {
        "subject": {"key": "subject", "type": "str"},
        "ekus": {"key": "ekus", "type": "[str]"},
        "subject_alternative_names": {"key": "sans", "type": "SubjectAlternativeNames"},
        "key_usage": {"key": "key_usage", "type": "[str]"},
        "validity_in_months": {"key": "validity_months", "type": "int"},
    }

    def __init__(
        self,
        *,
        subject: Optional[str] = None,
        ekus: Optional[List[str]] = None,
        subject_alternative_names: Optional["_models.SubjectAlternativeNames"] = None,
        key_usage: Optional[List[Union[str, "_models.KeyUsageType"]]] = None,
        validity_in_months: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword subject: The subject name. Should be a valid X509 distinguished Name.
        :paramtype subject: str
        :keyword ekus: The enhanced key usage.
        :paramtype ekus: list[str]
        :keyword subject_alternative_names: The subject alternative names.
        :paramtype subject_alternative_names:
         ~azure.keyvault.v2016_10_01.models.SubjectAlternativeNames
        :keyword key_usage: List of key usages.
        :paramtype key_usage: list[str or ~azure.keyvault.v2016_10_01.models.KeyUsageType]
        :keyword validity_in_months: The duration that the certificate is valid in months.
        :paramtype validity_in_months: int
        """
        super().__init__(**kwargs)
        self.subject = subject
        self.ekus = ekus
        self.subject_alternative_names = subject_alternative_names
        self.key_usage = key_usage
        self.validity_in_months = validity_in_months
