/*LINTLIBRARY*/
/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 *	Shape/AtFS
 *
 *	afkeys.c -- handle revision keys
 *
 *	Author: Andreas Lampen, TU-Berlin (andy@coma.UUCP)
 *					  (andy@db0tui62.BITNET)
 *
 *	$Header: afkeys.c[1.9] Fri Jan 31 18:05:23 1992 andy@cs.tu-berlin.de accessed $
 *
 *	EXPORT:
 *	af_buildkey -- build key from generation and revision
 *      af_gbuskey -- get key of busy version
 *      af_glastkey -- get key of last saved version
 *      af_gfreepos -- search free position in revlist
 *      af_glastgenpos -- search list position for new last rev in gen
 */

#include <stdio.h>

#include "afsys.h"
#include "atfs.h"

#ifdef MEMDEBUG
extern FILE *memprot;
#endif

/*================================================================
 *	af_buildkey
 *
 *================================================================*/

EXPORT af_buildkey (list, gen, rev, key)
     Af_revlist *list;
     int 	gen;
     int	rev;
     Af_key	*key; /* out */
{
  register int i = list->af_listlen-1;;
  
  key->af_ldes = list;
  while (!(list->af_list[i].af_class & AF_VALID) ||
	 (list->af_list[i].af_gen != gen) ||
	 (list->af_list[i].af_rev != rev))
    {
      i--;
      if (i == -1)
	SFAIL ("buildkey", "", AF_ENOREV, ERROR);
    }
  key->af_lpos = i;
  return (AF_OK);
}

/*================================================================
 *	af_gbuskey
 *
 *================================================================*/

EXPORT Af_key *af_gbuskey (list)
     Af_revlist *list;
{
  static Af_key busykey;

  busykey.af_ldes = list;
  busykey.af_lpos = 0;
  return (&busykey);
}


 /*================================================================
 *	af_glastkey
 *
 *================================================================*/

EXPORT Af_key *af_glastkey (list)
     Af_revlist *list;
{
  register int i = list->af_listlen-1;
  static Af_key lastkey;

  lastkey.af_ldes = list;
  while (!(list->af_list[i].af_class & AF_VALID))
    {
      i--;
      if (i == 0)
	return ((Af_key *)0);
    }
  lastkey.af_lpos = i;
  return (&lastkey);
}

/*================================================================
 * af_glastgenkey
 *
 *================================================================*/

EXPORT Af_key *af_glastgenkey (list, gen)
     Af_revlist *list;
     int gen;
{
  register int i = list->af_listlen-1;
  static Af_key lastgenkey;

  lastgenkey.af_ldes = list;
  while (!(list->af_list[i].af_class & AF_VALID) ||
	 (list->af_list[i].af_gen != gen))
    {
      i--;
      if (i == 0)
	return ((Af_key *)0);
    }
  lastgenkey.af_lpos = i;
  return (&lastgenkey);
}

/*================================================================
 * af_gfreepos -- search space for new list entry
 *                preserve increasing order
 *
 *================================================================*/

EXPORT af_gfreepos (list)
     Af_revlist *list;
{
  register int i = list->af_listlen-1;

  while (!(list->af_list[i].af_class & AF_VALID) && (i >= 0))
    i--;

  if (i == list->af_listlen-1)
    return (ERROR);

  if (!(list->af_list[i].af_class & AF_VALID) && (i == 0))
    return (0);

  return (i+1);
}

/*================================================================
 * af_glastgenpos
 *
 *================================================================*/

EXPORT af_glastgenpos (list, gen)
     Af_revlist *list;
     int gen;
{
  register int i = list->af_listlen-1;

  while (!(list->af_list[i].af_class & AF_VALID) ||
	 (list->af_list[i].af_gen != gen))
    {
      i--;
      if (i == 0)
	return (ERROR);
    }
  return (i);
}

/*================================================================
 * af_dropkey
 *
 *================================================================*/

EXPORT af_dropkey (key)
     Af_key *key;
{
  if (afAccessAso (key, 0))
    SFAIL ("dropkey", "", AF_EINVKEY, ERROR);

  /* decrease reference count in corresponding archive and in attrbuf */
  (key->af_ldes)->af_access--;
  VATTR(key).af_nrefs--;
#ifdef MEMDEBUG
  fprintf (memprot, "Access: %x,%d -1 (dropkey)\ttotal: %d\n", 
	   key->af_ldes, key->af_lpos, key->af_ldes->af_access);
#endif

  return (AF_OK);
}

/*================================================================
 * af_dropall
 *
 *================================================================*/

extern Af_revlist *af_lists;

EXPORT int af_dropall ()
{
  Af_revlist *list;
  register int i;

  list = af_lists;
  while (list != (Af_revlist *)0)
    {
      for (i=0; i<list->af_listlen; i++)
	list->af_list[i].af_nrefs = 0;
      list->af_access = 0;
    }
  return (AF_OK);
}
