/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 *	Shape/AtFS
 *
 *	aftime.c -- time handling
 *
 *	Author: Andreas Lampen, TU-Berlin (andy@coma.UUCP)
 *					  (andy@db0tui62.BITNET)
 *
 *	$Header: aftime.c[1.4] Fri Jan 31 18:04:54 1992 andy@cs.tu-berlin.de accessed $
 *
 *	EXPORT:
 *      af_asctime -- get time as ascii string
 *      af_acttime -- get actual time
 */

#include <stdio.h>

#include "afsys.h"
#include "atfs.h"

#include <sys/file.h>

/*================================================================
 *	af_asctime
 *
 *================================================================*/

EXPORT char *af_asctime ()
{
  char *asctime();  
  time_t seconds, time();

  seconds = time ((time_t *)0);
  return (asctime (localtime (&seconds)));
}

/*================================================================
 *	af_acttime -- return actual time (in seconds after ...)
 *
 *================================================================*/

EXPORT time_t af_acttime ()
{
  time_t time();

  return (time ((time_t *)0));
}
