/* LINTLIBRARY */
/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * ParseArgs.c
 */
/*
 * $Header: ParseArgs.c[1.9] Wed Feb  5 18:08:58 1992 axel@cs.tu-berlin.de accessed $
 */

#ifndef lint
static char *ATFSid = "$Header: ParseArgs.c[1.9] Wed Feb  5 18:08:58 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
  static char *Cflags = CFFLGS;
#endif
#endif
#include <stdio.h>
#include <sys/types.h>
#include "atfsapp.h"
#include "ParseArgs.h"

extern char *malloc(), *rindex();

#define MINUS_CHAR_REQUIRED 1

#ifdef DEBUG_PARSE
static int debug_parse = 0;
#endif /* DEBUG_PARSE */

char *ParseArgs_version () {
  static char ConfID[] = "1.9 (Wed Feb  5 18:08:58 1992 by $__auuid$)";
  return ConfID;
}

/****************************************************************************/

static int
GetNextToken (str, odesc, minus_char_required)
     char *str;
     OptDesc odesc[];
     int minus_char_required;
{
  int i;

  if (!str) return -1;

  if (minus_char_required && (*str != '-')) return -1;

  if (*str == '-') str++;

  for (i = 0; odesc[i].OptName; i++) {
    if (!strncmp(odesc[i].OptName, str, strlen(odesc[i].OptName)))
      return i;
  }
  return -1;
}

static int
IsOption (str, odesc, minus_char_required)
     char *str;
     OptDesc odesc[];
     int minus_char_required;
{
  return (GetNextToken(str, odesc, minus_char_required) >= 0 ? 1 : 0);
}

static char*
SkipThisToken (str, length)
     char *str;
     int length;
{
  if (*str == '-') str++;
  return (str + length);
}

static int
cmp_length (left, right)
     OptDesc *left, *right;
{
  return (strlen(right->OptName) - strlen(left->OptName));
}

static int
cmp_alpha (left, right)
     OptDesc *left, *right;
{
  return (strcmp(left->OptName, right->OptName));
}

static void
RearrangeOptDesc (odesc, cmp_function)
     OptDesc odesc[];
     int (*cmp_function)();	/* function that compares */
{
  int nelem;

  for (nelem = 0; odesc[nelem].OptName; nelem++) ;
  (void) qsort((char *) odesc, nelem, sizeof (struct __optdesc), cmp_function);
}

static int
ShortUsage (progname, odesc, extra_text)
     char *progname;
     OptDesc odesc[];
     char *extra_text;
{
  int i;
  int twidth = 80;
  int c_printed = 6;
  int length = 0;
  int nextlineoff;
  char buf[MSGLEN];

  RearrangeOptDesc (odesc, cmp_alpha);

#define GetTerminalWidth() 80
  twidth = GetTerminalWidth();

  (void) fprintf(stderr, "usage:");

  if (progname && *progname) {
    (void) fprintf(stderr, " %s:", progname);
    c_printed += strlen(progname) + 2;
  }

  nextlineoff = c_printed + 3;

  /* first switches than option requiring an agrument */
  (void) fprintf(stderr, " [-");
  c_printed += 3;

  for (i = 0; odesc[i].OptName; i++) {
    if ((odesc[i].OptKind & PATTRS) == PHIDDEN) continue;

    if ((odesc[i].OptKind & PKIND) == PSWITCH) {
      length = strlen(odesc[i].OptName); length++;
      if (c_printed + length > twidth) {
	c_printed = length + nextlineoff;
	(void) sprintf(buf, "\n%%%dc", nextlineoff);
	(void) fprintf(stderr, buf, ' ');
      }
      else {
	c_printed += length;
      }

      (void) fprintf(stderr, " %s", odesc[i].OptName);
    }
  }

  (void) fprintf (stderr, "]"); c_printed++;
  nextlineoff -= 3;

  for (i = 0; odesc[i].OptName; i++) {
    if ((odesc[i].OptKind & PATTRS) == PHIDDEN) continue;

    length = strlen(odesc[i].OptName);

    switch (odesc[i].OptKind & PKIND) {
    case PSWITCH:
        break;
    case POARG:
	if ((c_printed + 14 + length) > 80) {
	  c_printed = length + nextlineoff + 14;
	  (void) sprintf(buf, "\n%%%dc", nextlineoff);
	  (void) fprintf(stderr, buf, ' ');
	}
	else {
	  c_printed += length + 14;
	}

	(void) fprintf(stderr, " [-%s <opt arg>]", odesc[i].OptName);
      break;
    case PARG:
	if ((c_printed + 10 + length) > 80) {
	  c_printed = length + nextlineoff + 10;
	  (void) sprintf(buf, "\n%%%dc", nextlineoff);
	  (void) fprintf(stderr, buf, ' ');
	}
	else {
	  c_printed += length + 10;
	}

	(void) fprintf(stderr, " [-%s <arg>]", odesc[i].OptName);
      break;
    default:
      break;
    }
  }

  if ((strlen(extra_text) + c_printed + 1) > twidth) {
    (void) sprintf(buf, "\n%%%dc", nextlineoff);
    (void) fprintf(stderr, buf, ' ');
  }

  (void) fprintf(stderr, " %s\n", extra_text);
}

pa_ShortUsage (progname, odesc, extra_text)
     char *progname;
     OptDesc odesc[];
     char *extra_text;
{
  ShortUsage(progname, odesc, extra_text);
}

static int
handle (progname, odesc, idx, arg)
     char *progname;
     OptDesc *odesc;
     int idx;
     char *arg;
{

  switch (odesc[idx].OptKind & PACTION) {
  case PCALL:
    return odesc[idx].OptFunc(odesc[idx].OptName, arg);
    break;
  case PSET:
    *odesc[idx].OptVar = 1;
    return 0;
    break;
  case PCLEAR:
    *odesc[idx].OptVar = 0;
    return 0;
    break;
  case PTOGGLE:
    *odesc[idx].OptVar = *odesc[idx].OptVar ? 0 : 1;
    return 0;
    break;
  case PUSAGE:
    ShortUsage(progname, odesc, odesc[idx].OptStr);
    return 0;
    break;
  case PFAIL:
    ShortUsage(progname, odesc, odesc[idx].OptStr);
    return 1;
    break;
  default:
    (void) fprintf(stderr, "ParseArgs: unknown action (%s)\n",
		   odesc[idx].OptName);
    exit(1);
    return 1;			/* to make lint happy */
    break;
  }
  /* NOTREACHED */
}

int ParseArgs (argc, argv, nargc, nargv, odesc)
     int argc; char **argv;
     int *nargc; char *(*nargv[]);
     OptDesc odesc[];
{
  char **ArgV;
  char *tkn, *progname;
  int opt, minus_char_required, opterr = 0;

  *nargc = 0;
  /* allocate some memory for newav */
  if ((ArgV = (char **) malloc((unsigned) (sizeof (char *) * (argc + 1))))
      == (char **) NULL) {
    (void) fprintf(stderr, "%s: out of memory\n", argv[0]);
    exit(1);
  }

  /* sort by length */
  RearrangeOptDesc (odesc, cmp_length);

#ifdef DEBUG_PARSE
  if ((argc > 1) && !strcmp(argv[1], "\001\002")) { /* ^A^B */
    debug_parse++;
    (void) fprintf(stderr, "ParseArgs: debugging enabled.\n");
  }
#endif /* DEBUG_PARSE */

  /* skip program name */
  progname = (tkn = rindex(*argv, '/')) ? ++tkn : *argv;
  argv++;

#ifdef DEBUG_PARSE
  if (debug_parse) argv++;
#endif /* DEBUG_PARSE */

  while (argv && *argv) {
    tkn = *argv;		/* beginning of next argument */
    minus_char_required = 1;	/* require a '-' if argument is a option */

    while (tkn && *tkn) {
      if ((opt = GetNextToken(tkn, odesc, minus_char_required)) >= 0) {
	tkn = SkipThisToken(tkn, strlen (odesc[opt].OptName));
	/* allow joined options */
	minus_char_required = 0;

	switch (odesc[opt].OptKind & PKIND) {
	case PSWITCH:
	  opterr += handle(progname, odesc, opt, "");
	  break;
	case POARG:
	  /*
	   * at this point, tkn points to the next char after
	   * the detected option or tkn has reached the end.
	   */
	  if (!*tkn) {
	    if (*++argv) { /* next arg exists */
	      tkn = *argv;
	      /* always '-' required */
	      if (IsOption(tkn, odesc, MINUS_CHAR_REQUIRED)) {
		opterr += handle(progname, odesc, opt, "");
		tkn = NULL;
		argv--;
	      }
	      else {
		opterr += handle(progname, odesc, opt, tkn);
		tkn = NULL;
	      }
	    }
	    else {
	      /* end of argv reached */
	      opterr += handle(progname, odesc, opt, "");
	      tkn = NULL;
	      argv--;
	    }
	  }
	  else {
	    if (! IsOption(tkn, odesc, (! MINUS_CHAR_REQUIRED))) {
	      /* rest of tkn contains arg */
	      opterr += handle(progname, odesc, opt, tkn);
	      tkn = NULL;
	    }
	    else {
	      opterr += handle(progname, odesc, opt, "");
	    }
	  }
	  break;
	case PARG:
	  if (!*tkn) {
	    /* end of this arg reached */
	    argv++;
	    tkn = *argv;
	    if (!tkn) {
	      /* end of argv reached */
	      opterr += handle(progname, odesc, opt, "");
	      tkn = NULL;
	      argv--;
	    }
	    else {
	      opterr += handle(progname, odesc, opt, tkn);
	      tkn = NULL;
	    }
	  }
	  else {
	    opterr += handle(progname, odesc, opt, tkn);
	    tkn = NULL;
	  }
	  break;
	default:
	  /* fatal */
	  (void) fprintf(stderr,
			 "ParseArgs: Non option detected as option: %s.\n",
			 odesc[opt].OptName);
	  exit(1);
	  break;
	} /* end switch */
      } /* end then */
      else {
	/* argument is not a options */
	ArgV[*nargc] = tkn;
	(*nargc)++;
	tkn = NULL;
      }
    }
    /* select next argument */
    argv++;
  }

  ArgV[*nargc] = (char *) NULL;

#ifdef DEBUG_PARSE
  if (debug_parse) {
    int j;
    (void) fprintf(stderr, "ParseArgs: Pure Arguments are:\nParseArgs:\t");

    if (!*ArgV) (void) fprintf(stderr, "<none>\n");
    else {
      for (j = 0; ArgV[j]; j++) {
	(void) fprintf(stderr, "%s ", ArgV[j]);
      }
      (void) fprintf(stderr, "\n");
    }
    debug_parse = 0;
    (void) fprintf(stderr, "ParseArgs: Debugging disabled.\n");
  }
#endif /* DEBUG_PARSE */

  *nargv = ArgV;
  /* return # of errors. 0 means no error */
  return opterr;
}

int ParseEnv (progname, envar, odesc)
     char *progname;
     char *envar;
     OptDesc *odesc;
{
  int ac, nac;
  char **av, **nav;
  char *enval;
  char *getenv();

  if (!envar || !*envar)
    return 0;

  if ((enval = getenv(envar)) == (char *) NULL)
    return 0;

  if (!*enval)
    return 0;

  if ((av = (char **) malloc((unsigned) (sizeof(char *) * 40))) ==
      (char **) NULL) {
    (void) fprintf(stderr, "ParseArgs: Out of memory\n");
    exit (1);
  }

  /* determine options */
  av[0] = progname;
  av[1] = enval;
  ac = 2;

  while (enval && *enval)
    switch (*enval) {
    case ' ':
    case '\t':
    case '\n':
      *enval = '\0'; enval++;
      while (enval && *enval &&
	     (*enval == ' ' || *enval == '\t' || *enval == '\n'))
	enval++;
      if (enval) {
	if (ac == 40) {
	  (void) fprintf(stderr, "Too many options in env var %s.", envar);
	  exit (1);
	}
	av[ac++] = enval;
	enval++;
      }
      break;
    default:
      enval++;
      break;
    }
    
  av[ac] = (char *) NULL;
  ac--;

  ac = ParseArgs(ac, av, &nac, &nav, odesc);

  (void) free((char *) av); (void) free((char *) nav);

  return ac + nac;
}
