/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: main.c[1.34] Thu Apr 23 22:15:36 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include "shape.h"
#include "ParseArgs.h"
#include "strbuf.h"

#include <stdio.h>

#define MAXCMDTARGETS 32

extern char *getwd();

extern char *mktemp();

extern int yylex(), af_cleanup();

extern Bool is_selrule_name();

extern FILE *vmfopen();

extern int adjust_stdrules(), dump(), hashval(), ruleend(), ruledump();
extern int errexit(), init_ruletab(), init_selruletab(), seldump();
extern int stdrules(), catch_sigs(), cleanup_links();
extern void echo_macro(), addhash(), selruledef_name(), warning();

extern FILE *yyin, *temp;


extern char *firsttarget, *stdsuff, *busy_rule;
extern char ruleset[];

extern struct linkreg *link_reg;

Bool cmd_line_macro_def = FALSE;

char rbfile[MYMAXNAMLEN];
char prev_dir[MYMAXNAMLEN];
char *filenames[] = {"Shapefile", "shapefile", "Makefile", "makefile"};
int main_gen = AF_BUSYVERS, main_rev = AF_BUSYVERS;
char *suffs;

char shapeflags[2048];
char *stdmacros[] = { "ASFLAGS=","AS=as", "SHELL=/bin/sh",
			"RFLAGS=","FFLAGS=","FC=f77","M2FLAGS=",
			"M2C=m2c","PFLAGS=","PC=pc","CFLAGS=",
			"CC=cc","LDFLAGS=","LD=ld","LFLAGS=",
			"LEX=lex","YFLAGS=","YACC=yacc","MAKE=make",
			"$=$$","MFLAGS=-b","MAKEFLAGS=b",
			"SELECTED_AtFS=", "SELECTED_FS=",
			"RESTORED_OBJS=",
		        "@=$@", "?=$?", "<=$<", "*=$*",
			"+=$+", (char *)NULL};

struct linked_list *shapefiles = (struct linked_list *) NIL;
     /* list of names of files from
	command line via the -f option */
struct linked_list *shfiles;

char *cmdtargets[MAXCMDTARGETS];
     /* list of target form the	command line */

int rec_do_depth;

char *newarg[64];
int newargc;

Bool synterrflg = FALSE;
Bool Oldsuffs = FALSE;
Bool Newsuffs = FALSE;

#ifdef MEMDEBUG
FILE *memprot;
#endif

main(argc, argv)
     int argc;
     char **argv;
     
{
int newac = 0;
char **newav, template[20];
static char ShapeMacroDef[] = "SHAPE = shape";
sb_ptr	strbuf = sbnew(128);

register int i, k = 0;
char *xxx;
char shape_cmd_macro[2048], atfsdir[MAXPATHLEN];
Bool cmd_line_macros_seen;
extern OptDesc odesc[];
FILE *logfd;

if (strbuf == 0)
    errexit(10, "sbnew");

#ifdef MEMDEBUG
unlink("/tmp/memprot");
memprot = fopen ("/tmp/memprot", "w");
#endif

rebuildflg = FALSE;
bpoolflg = TRUE;
rec_do_depth = 1;
if ((curvpath[0] = malloc(MAXPATHLEN + 2)) == NIL)
  errexit(10,"malloc");
(void) getwd(curvpath[0]);
catch_sigs(); 


#ifdef MEMDEBUG
malloc_debug(2);
#endif

(void) strcpy (shapeflags, "SHAPEFLAGS=");

if (argc != 1)
  {
    if(ParseArgs (argc, argv, &newac, &newav, odesc))
      {
	pa_ShortUsage(argv[0], odesc, "");
	exit(1);
      }
  }

if (!echoflg) {
  (void) strcpy(prev_dir,curvpath[0]);
  
  (void) strcpy(atfsdir,curvpath[0]);
  (void) strcat(atfsdir,"/AtFS");
  
  if(af_access(af_afpath(atfsdir),af_afname(atfsdir),af_aftype(atfsdir),AF_SOURCE) != 0) {
    (void) strcpy(atfsdir,curvpath[0]);
    (void) strcat(atfsdir,"/AFS");
    if(af_access(af_afpath(atfsdir),af_afname(atfsdir),af_aftype(atfsdir),
		 AF_SOURCE) != 0) {
      warning(4,NIL);
    }
  }
}

if((xxx = rindex(prev_dir,'/')) != NIL)
     *xxx = '\0';
init_ruletab();
init_selruletab();
if (!echoflg) {
  (void) strcpy (template, "/tmp/shapeXXXXXX");
  (void) mktemp(template);
  if((temp = fopen(template,"w")) == (FILE *)NIL)
    errexit(12,template);
}

macrodef(ShapeMacroDef);
  
if(logflg && !echoflg)
  {
    logfd = fopen("SHAPE.LOGFILE","a");
    for (i = 0; i<argc; i++)
      fprintf(logfd,"%s ", argv[i]);
    fprintf(logfd,"\n");
    (void) fclose(logfd);
  }

newargc = newac;
for(i = 0; i < newac; i++)
     newarg[i] = newav[i];

for (i = 0; stdmacros[i]; i++) {
     if (sbcpy(strbuf, stdmacros[i], strlen(stdmacros[i])) == 0)
	errexit(10, "sbcpy");
     macrodef(sbstr(strbuf));
}

sbfree(strbuf);

if  (!rebuildflg)
  {

    if (fileflg)
      {
	shfiles = shapefiles;
	while(shfiles != (struct linked_list *) NIL)
	  {
	    if ((yyin = vmfopen(shfiles->string,"r", main_gen, main_rev)) == (FILE *)NIL)
	      errexit(12,shfiles->string);
	    else
	      {
		get_macros(yyin);
		(void) fclose(yyin);
	      }
	    shfiles = shfiles->nextstring;
	  }
	if (stdinflg == TRUE)
	  get_macros(stdin);
      }
    else
      {
	for ( i = 0; i <= 3; i++)
	  {
	    if ((yyin = vmfopen (filenames[i], "r", main_gen, main_rev)) != (FILE *)NIL) 
	      break;
	  }
	if (yyin == (FILE *)NIL)
	  nostdfile = TRUE;
	else
	  {
	    nostdfile = FALSE;
	    get_macros(yyin);
	    (void) fclose(yyin);
	  }
      }
  }

else {
  if(( yyin = vmfopen(rbfile, "r", main_gen, main_rev)) == (FILE *) NIL)
    errexit(12, rbfile);
  get_macros(yyin);
  (void) fclose(yyin);
}

if (!echoflg) {
  (void) fclose(temp);
}

cmd_line_macros_seen = cmd_line_macro_def;

for (i = 0; i < newac; i++)
{
  if (index(newav[i],'='))
    {
      (void) strcat (shapeflags, newav[i]);
      (void) strcat (shapeflags, " ");
      macrodef(newav[i]);
      cmd_line_macro_def = TRUE;
    }
  else
    {
      if ((cmdtargets[k] = malloc((unsigned) (strlen(newav[i]) + sizeof(char)))) == NIL)
	errexit(10,"malloc");
      (void) strcpy(cmdtargets[k++],newav[i]);
      cmdtargets[k] = NIL;
    }
}

macrodef (shapeflags);

if(echoflg)
{
  echo_macro(echomac);
  (void) unlink(template);
  exit(0);
}

if(rebuildflg && cmd_line_macro_def)
  warning(3, NIL);

add_stdrules();
firsttarget = NIL;

if ((yyin = fopen(template,"r")) == (FILE *)NIL)
  errexit(12,template);
else
  {
    (void) unlink(template);
    (void) yylex();
    (void) fclose(yyin);
  }


if (synterrflg == TRUE)
  errexit(15,NIL);

ruleend();

adjust_stdrules(suffs);

/* add busy rule */

selruledef_name(busy_rule);
(void) is_selrule_name("-STD-");

if(envflg)
  (void) get_env_vals();
if(environment_vars != NIL)
  free(environment_vars);
     
produce();

(void) fclose(yyin);
if (confid)
  {
    finish_confid();
    af_close(cid);
  }
if (debugflg)
  {
    if (suffs_deleted)
      printf("no suffix list");
    dump(stdout);  /* dumping macros */
    ruledump(stdout); /* dumping targets, dependents & commands, resp. */
  }

if (printflg)
  {
    if (suffs_deleted)
      printf("no suffix list");
    dump(stdout);  /* dumping macros */
    ruledump(stdout); /* dumping targets, dependents & commands, resp. */
  }

cleanup_links(link_reg);
af_cleanup();
exit(0);
}
	
get_env_vals()
{
  extern char *getenv(), *get_next_item();
  register char *p, *name, *enventry;
  char line2[1048];
  if(environment_vars == NIL)
    return;
  p = environment_vars;
  while ((*p == ' ') || (*p == '\t'))
    p++;
  while(name = get_next_item(p))
    {
      if (strcmp(p,"") == 0)
	break;
      p = index(p,'\0');
      p++;
      while ((*p == ' ') || (*p == '\t'))
	p++;
      if ((enventry = getenv(name)) != NIL)
	{
	  (void) strcpy(line2,name);
	  (void) strcat(line2,"=");
	  (void) strcat(line2,enventry);
	  macrodef(line2);
	}
    }
}
