/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: dosave.c[3.54] Tue Feb 18 22:45:06 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>
#include <atfs.h>
#include <atfsapp.h>

#include "save.h"

extern char *progname;
extern int StdinFlag;
extern unsigned int options;
extern char tfname[], vcomment[], atr_fname[], symname[], fix_base[];
extern int newvnum, ins_generation;
extern struct Transaction ThisTransaction;

extern int af_errno;
#define checkAtFSerr(obj) \
  if (af_errno != AF_ENOREV) { \
      af_perror (obj); \
      abort_this (TRUE); \
    }

SaveAFile (fname, proj) char *fname; Project *proj; {
/*
 * Save working file with the given name in the project location (syspath)
 * determined by proj. Check for changes before saving.
 * Attributes are also derived from the proj-context.
 * Unless QUIETPLEASE is set, the user will be prompted for a note 
 * describing the changes to be saved.
 * On the locking strategy:
 * An author can save a busy version, only if he holds a lock (update
 * privilege) for the document history. When an archive is newly
 * created from a (busy) file, such a lock is assumed to be set.
 * Upon save operations - which are conceptually local to a user context -
 * the lock is released. 
 * Locks on certain documents can be obtained through means of 'reserve'
 * which is a User <--> Project transaction. Locally created documents
 * are placed under project discipline (or configuration control) the
 * first time they are submitted -- even if they have not been reserved
 * yet. Locks have token-character, i.e. they may be passed around, but
 * never ever be duplicated.
 */
 /*
  *  NOTE: use of variant attribute in af_getkey is not yet functional.
  *        The parameter, however, is necessary to occupy the slot.
  *        Implementation of variant selection may make it necessary
  *        to add another parameter to this procedure.
  */
  char spath[MAXPATHLEN+1], origpath[MAXPATHLEN+1], name[MAXPATHLEN+1], 
  *afname, *aftype, str[MSGLEN], messg[MAXPATHLEN+80], *note, 
  *getnote(), *gettxt(), *vnum(), *getattr(), *as;
  int truth = TRUE, busystate, have_lock = FALSE, fix_generation;
  Af_attrs reqattrs, sattrs;
  Af_key busy, lastsave, skey, *newkey, ngkey, tmpkey;
  Af_set junkset;
  void vc_salvage();

  if (!fname) return;
  
  af_initattrs (&reqattrs);
  getsyspath (fname, proj, spath, origpath, name); 
               /* splits name and pathname prefix */

  afname = af_afname (name);
  aftype = af_aftype (name);
  /* give a little feedback ... */
  if (spath[0]) {
    (void)sprintf (messg, "[%s]%s:", spath, name);
  }
  else {
    (void)sprintf (messg, "%s:", name);
  }
  logmsg (messg);

  if ((options & FIX) && (ins_generation == 0)) {
    int base_version = Symn2Vno (fname, fix_base);
    if (base_version)
      fix_generation = gen(base_version);
    else {
      (void) sprintf (messg, "symbolic name %s not known for %s.", 
		      fix_base, fname);
      logerr (messg);
      abort_this (FALSE);
    }
  }
  else {
    fix_generation = ins_generation;
  }
  
  if (options & SYMNSET) {
    af_initattrs (&sattrs);
    (void)strcpy (sattrs.af_syspath, spath);
    (void)strcpy (sattrs.af_name, afname);
    (void)strcpy (sattrs.af_type, aftype);
    (void)sprintf (str, "%s=%s", SYMNAME, symname);
    sattrs.af_udattrs[0] = str;
    sattrs.af_udattrs[1] = NULL;
    af_find (&sattrs, &junkset);
    if (af_nrofkeys(&junkset)) {
      af_setgkey (&junkset, 0, &tmpkey);
      (void)sprintf (messg, "symbolic name %s already in use by %s[%s]", 
	       symname, fname, vnum(&tmpkey));
      logerr (messg);
      af_dropset (&junkset);
      af_dropkey (&tmpkey);
      abort_this (FALSE);
    }
    else {
      af_cleanup ();		/* ??? */
    }
  }
  if (fail(af_getkey (spath, afname, aftype, AF_BUSYVERS, 
		      AF_BUSYVERS, &busy))) {
    checkAtFSerr(fname);
    if (!(options & NEWGEN) || 
	(fail(af_getkey (spath, afname, aftype, 
			 (options & FIX) ? fix_generation : AF_LASTVERS, 
			 AF_LASTVERS, &busy)))) {
      checkAtFSerr(fname);
      (void)sprintf (messg, "%s", fname);
      if (!(options & QUIETPLEASE)) af_perror (messg);
      abort_this (TRUE);
    }
  }

  busystate = af_rstate (&busy);

  if (fail(af_getkey (spath, afname, aftype, 
		      (options & FIX) ? fix_generation : AF_LASTVERS,
		      AF_LASTVERS, &lastsave))) {
    if (options & FIX) {
      logerr ("No place to insert a version!");
      af_dropkey (&busy);
      abort_this (FALSE);
    }
    checkAtFSerr(fname)
    logmsg ("creating archive");
    if (fail(af_saverev (&busy, &skey, AF_LASTVERS))) {
      af_perror (fname);
      af_dropkey (&busy);
      abort_this(TRUE);
    }
    newkey = &skey;
    ThisTransaction.tr_done = TRUE;
    if (options & TXTFSET) {
      note = gettxt (tfname);
    }
    else {
      note = getnote ("How about describing the purpose of this document ?", 
		      truth, TRUE, (char *)NULL);
    }
  }    /* This was handling of newly created archive */
  else {
    /*
     * if we declare a new major revision, we want to ignore possibly
     * existing copies of versions. These appear as unlocked busyversions.
     * If we detect this case, we set things up to look like no such
     * busyversion would exist.
     */
    if ((options & NEWGEN) &&
	(busystate == AF_BUSY) &&
	!locked (vc_testlock(&lastsave))) {
      af_dropkey (&busy);
      busy = lastsave;
      busystate = af_rstate (&busy);
    }
    if (options & (NEWGEN | SETVNUM)) {
      if (!i_am_owner (&busy)) {
	switch (options & (NEWGEN | SETVNUM)) {
	case NEWGEN:
	  logerr 
	    ("Only the project administrator may create major revisions.");
	  af_dropkey (&busy);
	  abort_this (FALSE);
	  break;
	case SETVNUM:
	  logerr ("Only the project administrator may set version numbers.");
	  af_dropkey (&busy);
	  abort_this (FALSE);
	  break;
	default:
	  logerr ("This is impossible !!");
	}
      }
    }
    if ((busystate == AF_BUSY) &&
	(changed (&busy, &lastsave, &truth)) 
	&& (have_lock = i_locked_gen (&lastsave, (Project *)-1))) {
      Af_key previous_busy;

      if (options & FIX) {
	if (af_setbusy (&busy, &lastsave, &previous_busy) < 0) {
	  (void)sprintf (messg, "WARNING: Can't set predecessor for fixed version of %s.", fname);
	  logerr (messg);
	  af_perror (fname);
	}
      }
      if (fail(af_saverev (&busy, &skey, 
			   (options & FIX) ? fix_generation : 
			   AF_LASTVERS))) {
	af_perror (fname);
	af_dropkey (&busy);
	vc_salvage (note);
	abort_this(TRUE);
      }
      if (options & FIX) {
	Af_key junk;

	if (af_setbusy (&busy, &previous_busy, &junk) < 0) {
	  (void)sprintf (messg, "WARNING: Can't reset original busy version link for %s.", fname);
	  logerr (messg);
	  af_perror (fname);
	}
      }
      newkey = &skey;
      (void) vc_unlock (&lastsave);
      (void) vc_lock (newkey, geteuid());      
      ThisTransaction.tr_done = TRUE;
      af_sudattr (newkey, AF_REMOVE, INTENT);

      if (options & TXTFSET) {
	note = gettxt (tfname);
      }
      else if (options & MSGSET) {
	note = vcomment;
      }
      else {
	char *intent = (char *)0;
	if (!(options & KEEPLOCK))
	  intent = af_rudattr (&lastsave, INTENT);
	note = getnote ("Do you want to comment your modifications ?", truth, 
			FALSE, intent);
	if (intent) free (intent);
	(void)af_sudattr (&lastsave, AF_REMOVE, INTENT);
      }
    }
    else { /* version is unchanged or not locked */
      if (options & NEWGEN) {
	char *intent = af_rnote (&busy);
	if (!i_locked_gen (&lastsave, (Project *)-1)) {
	  af_dropkey (&lastsave);
	  abort_this (TRUE);
	}
	note = getnote ("Do you want to state a comment ?", truth,
			FALSE, intent);
	if (intent) free (intent);
	newkey = &lastsave;
      }
      else {
	(void)sprintf (messg, "%s not saved.", fname);
	if (!(options & KEEPLOCK) && locked (vc_testlock(&lastsave))) {
	  if (busystate == AF_BUSY) {
	    if (fail(af_rm (&busy))) {
	      if (!(options & QUIETPLEASE)) {
		(void) sprintf (messg, "cannot remove %s busy version", fname);
		af_perror (messg);
	      }
	      (void) strcat (messg, " ");
	      (void) strcat (messg, fname);
	      (void) strcat (messg, " not removed.");
	    }
	    else { 
	      (void) vc_unlock (&lastsave);
	      (void) strcat (messg, " ");
	      (void) strcat (messg, fname);
	      (void) strcat (messg, " removed.");
	    }
	  }
	}
	logmsg (messg);
	af_dropkey (&lastsave);
	af_dropkey (&busy);
	abort_this(FALSE);
      }
    }
  }
  /* If we get here, something has been saved -- set note */
  if (fail(af_snote (newkey, note))) {
    af_perror (fname);
    vc_salvage (note);
  }
  if (options & SYMNSET) {
    (void)sprintf (str, "%s=%s", SYMNAME, symname);
    as = str;
    af_sudattr (newkey, AF_ADD, as);
  }
  if (options & NEWGEN) {
    if (fail (af_newgen (newkey, &ngkey))) {
      af_perror (fname);
      af_dropkey (newkey);
      abort_this (TRUE);
    }
    (void)vc_unlock (newkey); 
    af_dropkey (newkey);
    newkey = &ngkey;
  }
  if (options & SETVNUM) {
    if (!(mkvno(vnum(newkey)) == newvnum)) { /* do nothing */
      (void) vc_lock (newkey, geteuid());
      if (af_svnum (newkey, gen(newvnum), rev(newvnum)) < 0) {
	(void)sprintf (messg, "can't set version number %d.%d for %s",
		 gen(newvnum), rev(newvnum), fname );
	af_perror (messg);
      }
    }
  }
  (void)sprintf (messg, "%s[%s] %s%s.", fname, vnum (newkey),
		 "saved", 
		 truth ? "" : " (no changes)");
  logmsg (messg);
  if (options & ATTRDEF) {
    if (as = getattr (atr_fname, proj, aftype, REWIND))
      at_setuda (newkey, as);
    while (as=getattr (atr_fname, proj, aftype, NEXT)) {
      at_setuda (newkey, as);
    }
  }

  /* Take care of old locks and new locks (in case they'll be kept */
  (void) vc_unlock (&lastsave); /* remove previous lock */
  if (!(options & KEEPLOCK)) {
    (void) vc_unlock (newkey);
    if (busystate == AF_BUSY) {
      if (fail(af_rm (&busy))) {
	if (!(options & QUIETPLEASE)) {
	  (void) sprintf (messg, "cannot remove %s", fname);
	  af_perror (messg);
	}
      }
      else { 
	(void) sprintf (messg, "%s removed.", fname);
	logmsg (messg);
      }
    }
  }
  else { /* KEEPLOCK */
    /* if we keep the generation lock, the most recently
     * saved revision within the locked generation must be
     * version-locked. */
    Uid_t myuid = (Uid_t)geteuid ();

    if (lockeruid (vc_lock (newkey, myuid)) != myuid) {
      if (options & FIX)
	(void) sprintf (messg, "Cannot lock generation %d of %s.",
			fix_generation, fname);
      else 
	(void)sprintf (messg, "Cannot lock %s-history.", fname);
      af_perror (messg);
    }
  }

  af_dropkey (newkey);
  af_dropkey (&lastsave);
  af_dropkey (&busy);
}

changed (new, old, realtruth) Af_key *new, *old; int *realtruth; {
/*
 * Return true if new and old are actually different OR deposit is
 * forced OR if user says 'yes' when asked whether an unchanged version
 * shall be saved anyway.
 * As AtFS is still in the tests, this is programmed very defensively.
 */
  FILE *newf, *oldf;
  Af_attrs newat, oldat;
  char *news, *olds, *malloc(), messg[MAXPATHLEN+80];

  *realtruth = TRUE;  /* initially assume that something has act. changed */
  if (fail(af_gattrs (new, &newat))) {
    af_perror ("busy-version");
  }
  if (fail(af_gattrs (old, &oldat))) {
    af_perror ("lastsaved-version");
  }
  if (newat.af_mtime == oldat.af_mtime) {
    *realtruth = FALSE;
    if (options & QUIETPLEASE) {
      return options & FORCE;
    }
    if (isatty (fileno (stdin)) && isatty (fileno (stdout))) {
      (void)sprintf (messg, "There are no changes with respect to the previously saved version.\nSave anyway ?");
      return !ask_confirm (messg, "no");
    }
    else return options & FORCE;
  }

  if (newat.af_size != oldat.af_size) {
    return TRUE;
  }
  else { /* lets have a closer look at 'em */
    if ((news = malloc ((unsigned)newat.af_size)) == NULL) {
      (void)sprintf (messg, "Can't malloc %d bytes.", newat.af_size);
      logmsg (messg);
      abort_this(TRUE);
    }
    if ((olds = malloc ((unsigned)oldat.af_size)) == NULL) {
      (void)sprintf (messg, "Can't malloc %d bytes.", oldat.af_size);
      logmsg (messg);
      free (news);
      abort_this(TRUE);
    }
    if ((newf = af_open (new, "r")) == NULL) {
      af_perror ("busy-version");
      free (news);
      free (olds);
      abort_this(TRUE);
    }
    if ((oldf = af_open (old, "r")) == NULL) {
      af_perror ("lastsaved-version");
      free (news);
      free (olds);
      af_close (newf);
      abort_this(TRUE);
    }

    *news = *olds = '\0';
    
    if (fread (news, sizeof (char), (Size_t)newat.af_size, newf)
	  != newat.af_size) 
      {
      logmsg ("Couldn't read busy version.");
      free (news);
      free (olds);
      af_close (newf);
      af_close (oldf);
      abort_this (TRUE);
    }
    if (fread (olds, sizeof (char), (Size_t)oldat.af_size, oldf)
	!= oldat.af_size) 
      {
      logmsg ("Couldn't read lastsaved version.");
      free (news);
      free (olds);
      af_close (newf);
      af_close (oldf);
      abort_this (TRUE);
    }
    af_close (newf);
    af_close (oldf);
    if (bcmp (olds, news, (int)newat.af_size)) {
      free (news); free (olds);
      return TRUE;
    }
    else {  /* Hmmm, looks like nothing has changed ... */
      free (news); free (olds);
      *realtruth = FALSE; /* return value may be a lie */
      if (options & FORCE) {
	return TRUE;
      }
      else {
	if (options & QUIETPLEASE) {
	  return FALSE;
	}
	if (isatty (fileno (stdin)) && isatty (fileno (stdout))) {
	  (void)sprintf (messg, "There are no changes with respect to the previously saved version.\nSave anyway ?");
	  return !ask_confirm (messg, "no");
	}
	else return FALSE;
      }
    }
  }
}

char *gettxt (fname) char *fname; {
  static char *txt = EMPTYNOTE;
  char *malloc();
  FILE *txtfil;
  struct stat statbuf;
  static int firsttime = TRUE;

  if (firsttime) {
    firsttime = FALSE;
    if ((txtfil = fopen (fname, "r")) == NULL) {
      logwarn ("no descriptive text file");
    }
    else {
      if (fstat (fileno(txtfil), &statbuf) == -1) {
	perror ("couldn't stat");
      }
      else {
	txt = malloc ((unsigned)(statbuf.st_size+1));
	if (!txt) {
	  logwarn ("not enough memory for descriptive text.");
	  txt = EMPTYNOTE;
	}
	else {
	  bzero(txt, (int) statbuf.st_size+1);
	  (void)fread (txt, sizeof (char), (Size_t)statbuf.st_size, txtfil);
	  (void)fclose (txtfil);
	}
      }
    }
  }
  return txt;
}

char *getnote (prompt, changeflg, force, xintent) 
     char *prompt, *xintent; 
     int changeflg, force; 
{
  char *tmpname, *mktemp(), *edname, cmd[MSGLEN], *getenv(), messg[MAXPATHLEN+80],
       tmpfnam[MAXPATHLEN+1], *malloc(), *realloc(), *intent;
  static char *notetxt, *rawnotetxt;
  FILE *tmpfil;
  struct stat statbuf;
  static int firsttime = TRUE;
  int istty;
  extern char *get_from_stdin();

  istty = isatty(fileno(stdin));

  if (xintent) {
    intent = (char *)malloc (strlen (xintent) +1);
    if (!intent) return EMPTYNOTE;
    (void) strcpy (intent, xintent);
  }
  else
    intent = "";

  if (StdinFlag) {
    char *edbuf;

    if (intent && istty && !(options & QUIETPLEASE)) {
      (void) printf("%s\n", intent);
    }

    if (firsttime || (istty && !(options & QUIETPLEASE) && 
		      !ask_confirm ("Use previous log message ?", "yes"))) {
      rawnotetxt = get_from_stdin('.');
      rawnotetxt = rawnotetxt ? rawnotetxt : "";

      if ((notetxt = malloc (strlen (rawnotetxt))) != (char *)NULL)
	(void) strcpy (notetxt, rawnotetxt);
      else 
	notetxt = rawnotetxt; /* not nice but safe */
      firsttime = FALSE;
    }
    if ((edbuf = (char *)malloc (strlen (intent) + 
				 strlen (rawnotetxt) +1)) != (char *)NULL) {
      *edbuf = '\0';
      (void) strcat (edbuf, intent);
      (void) strcat (edbuf, rawnotetxt);
      notetxt = realloc (notetxt, strlen (edbuf));
      (void) strcpy (notetxt, edbuf);
      free (edbuf);
    }
    return notetxt;
  }

  if ((options & QUIETPLEASE) ||
      (!istty)) {
    if (intent) goto retintent;
    else return EMPTYNOTE;
  }
  if ((!force) && (!firsttime) && notetxt) {
    if (ask_confirm ("Use previous log message ?", "yes")) {
      return notetxt;
    }
    else {
      free (notetxt);
    }
  }
  firsttime = FALSE;
  if (changeflg) {
    if (!ask_confirm (prompt, "yes"))
      if (intent) goto retintent;
      else return EMPTYNOTE;
  }
  else {
    if (ask_confirm ("The new version is unmodified. Comment it anyway ?", 
		     "no"))
      if (intent) goto retintent;
      else return EMPTYNOTE;
  }
  
  (void) strcpy (tmpfnam, "/tmp/AtFSXXXXXX");
  tmpname = mktemp (tmpfnam);
  Register (tmpname, TYPEF);
  if (intent) {
    FILE *tfd;
    tfd = fopen (tmpname, "w");
    if (fwrite (intent, sizeof (char), strlen (intent), tfd) != 
	strlen (intent)) {
      logerr ("write failure on tmp-file");
    }
    (void)fclose (tfd);
  }
  edname = getenv ("EDITOR");
  if (!edname) edname = DEFAULT_EDITOR;

  (void)sprintf (cmd, "%s %s", edname, tmpname);
  (void)sprintf (messg, "starting up %s ...", edname);
  logmsg (messg);
  if (system (cmd) == NOSHELL) {
    logerr ("couldn't execute shell");
    UnRegister (tmpname, TYPEF);
  }
  else {
    if ((tmpfil = fopen (tmpname, "r")) == NULL) {
      logwarn ("empty logentry");
      UnRegister (tmpname, TYPEF);
      return EMPTYNOTE;
    }
    else {
      (void)unlink (tmpname);
      UnRegister (tmpname, TYPEF);
      if (fstat (fileno(tmpfil), &statbuf) == -1) {
	perror ("couldn't stat");
	return EMPTYNOTE;
      }
      else {
	notetxt = malloc ((unsigned)(statbuf.st_size+1));
	if (!notetxt) {
	  logwarn ("not enough memory for note text.");
	  return EMPTYNOTE;
	}
	bzero(notetxt, (int) statbuf.st_size+1);
	(void)fread (notetxt, sizeof (char), (Size_t)statbuf.st_size, 
		     tmpfil);
	(void)fclose (tmpfil);
	UnRegister (tmpname, TYPEF);
	return notetxt;
      }
    }
  }
  logwarn ("Couldn't start editor. Please check EDITOR environment variable.");
  UnRegister (tmpname, TYPEF);
  return EMPTYNOTE;   /* maybe we should try to read from stdin */
 retintent:
  if ((notetxt = malloc ((unsigned)(strlen (intent) + 1))) == (char *) NULL){
    UnRegister (tmpname, TYPEF);
    logwarn ("not enough memory for note text.");
    return EMPTYNOTE;
  }
  (void)strcpy (notetxt, intent);
  UnRegister (tmpname, TYPEF);
  return notetxt;
}

void vc_salvage (text) char *text; {
  static int serial = 0;
  FILE *fil;
  char fnam[MSGLEN], messg[MSGLEN];

  (void) sprintf (fnam, "%s%d-%d", progname, getpid(), serial++);
  if (text) {
    if ((fil = fopen (fnam, "w")) != NULL) {
      if (fwrite (text, sizeof (char), strlen (text), fil) != strlen (text))
	logerr ("write failure on salvage file -- sorry!");
      else {
	(void) sprintf (messg, 
			"A temporary copy of your log can be found in %s.",
			fnam);
	logmsg (messg);
      }
    }
    (void) fclose (fil);
  }
}

i_am_owner (key) Af_key *key; {
  /*
   *  This function returns TRUE if we happen to be the owner of the
   *  history (i.e. the AtFS directory) that 'key' belongs to. FALSE
   *  otherwise.
   */
  char path[MAXPATHLEN+1];
  struct stat statbuf;

  (void)strcpy (path, af_rsyspath (key));
  if (strcmp (path, "/") == NULL)
    (void)strcpy (path, "");
  (void)strcat (path, "/AtFS");
  if (stat (path, &statbuf) < 0) {
    *rindex (path, '/') = '\0';
    (void)strcat (path, "/AFS");
    if (stat (path, &statbuf) < 0) {
      perror (path);
      return -1;
    }
  }
  return geteuid () == statbuf.st_uid;
}

i_locked_gen (key, proj) Af_key *key; Project *proj; {
  Af_user *locker;
  Uid_t myuid;
  char messg[MAXPATHLEN+80], *lockerid();
  extern char *at_keygetbndvers();

  myuid = (Uid_t)geteuid();
  if (!locked(locker = vc_testlock(key))) {
    if (firmlocking (proj)) {
      (void)sprintf (messg,
                     "You must lock %s before saving (firm locking required).",
                     at_keygetbndvers(key, 1));
      logerr (messg);
      return FALSE;
    }
    else { /* no firm locking */
      if (lockeruid (vc_lock(key, myuid)) != myuid) {
        af_perror ("cannot lock archive");
        return FALSE;
      }
      return TRUE;
    }
  }
  else { /* there was some lock set */
    if (lockeruid(locker) != myuid) {
      (void)sprintf (messg, "%s already locked by %s.",
                     at_keygetbndvers(key,1),
                     lockerid (locker));
      logerr (messg);
      return FALSE;
    }
    return TRUE;
  }
}
