#include <stdlib.h>

#include <stdio.h>

#include <string.h>
#include <stddef.h>
#include "lexer.fdf"
#include "input.fdf"
#include "parser.fdf"
#include "manager.fdf"
#include "dfa.fdf"
#include "service.fdf"
#include "parser.h"
#include "global.h"
#include "symbol.h"
#include "manager.h"

Descr *proParse_parse( void )
    {
    Descr *descrP;

    cc_newDescr( &descrP, NULL );
    proInput_forget();
    stateP->brackets = 0;
    stateP->quoted   = FALSE;
    stateP->termStarted = FALSE;
	proParse_process( descrP );
    return descrP;
    }

List *proParse_process( Descr *descrP )
	{
	int            remarks  = 0;
	Descr		   *subDescrP;
	List           *valueP, *traverserP = (List *)descrP;

	while ( !(stateP->termStarted  && 
			  stateP->brackets == 0) && 
			  !(stateP->endOfFile))
		{
        stateP->quoted = FALSE;
        proDfa_tokenize( conconDfas, conconRules );
		if (stateP->endOfFile )
			{
			if (stateP->brackets >0)
				printf("ERROR - Brackets still open at end of file...\n");
			return descrP->nextP;
			}
		switch (stateP->token)
			{
			case UNREMARK:
				printf("ERROR - Closing remark without opening...line %d\n", stateP->lineNo );
				/* panic mode ? */
				stateP->termStarted = FALSE;
				stateP->brackets = remarks = 0;
/* clean up should be done here .. */
				return NULL;
			case REMARK:
				remarks++;
				while (remarks > 0 && !(stateP->endOfFile))
					{
					proDfa_tokenize( conconDfas, conconRules );    
					if (stateP->token == REMARK)   remarks++;
					if (stateP->token == UNREMARK) remarks--;
					}	
				if (stateP->endOfFile)
					printf("ERROR - Remark still open at end of file...\n");
				break;
			case BRA:
				stateP->termStarted = TRUE;
				stateP->brackets++;
				traverserP->nextP =proMem_getAvail( );
				traverserP =traverserP->nextP;
                traverserP->u.p.quoted = stateP->quoted;
                stateP->quoted   = FALSE;
                cc_newDescr( &subDescrP, NULL );
				cc_makeSubList( traverserP, 
					proParse_process( subDescrP ) );
				cc_freeDescr( &subDescrP );
				break;
			case KET:
				stateP->termStarted = TRUE;
				if (stateP->brackets==0) 
					{
					printf("ERROR - Closing bracket without opening...line %d\n", stateP->lineNo );
					return NULL;
					}
				else 
					{
					traverserP->nextP = NULL;
					stateP->brackets--;
					return descrP->nextP;
					}
			case INTEGER:
				stateP->termStarted = TRUE;
				traverserP->nextP =proMem_getAvail( );
				traverserP = traverserP->nextP;
				cc_makeInteger( traverserP, atol( lexTailP ) );
				break;
			case REAL:
				stateP->termStarted = TRUE;
				traverserP->nextP =proMem_getAvail( );
				traverserP = traverserP->nextP;
				cc_makeReal( traverserP, (float)atof( lexTailP ) );
				break;
			case ALPHA:
			case LITERAL:
				stateP->termStarted = TRUE;
				if ((valueP=proMem_lookup(lexTailP)) == NULL)
					valueP=proMem_insert();
				else
                    if (valueP->u.p.type != stateP->token)
                        stateP->token = valueP->u.p.type;
				traverserP->nextP =proMem_getAvail( );
				traverserP=traverserP->nextP;
                traverserP->u.p.type = stateP->token;
                traverserP->u.p.quoted = stateP->quoted;
                traverserP->data.dataP=valueP;
				break;			
			default:
                break;
            }
		}
	return descrP->nextP;
	}




