
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Help information.
% Invoked by the command help or help(option).

help :-
	nl,
	write('The compiler is called as plm(filename) or plm(filename,optionlist).'),nl,
	write('The options in optionlist must be a subset of '),
	help_optionlist(OptList),
	write(OptList), write('.'), nl,
	write('Call help(option) for further information on an option.'),nl.
	

help(Option) :-
	nl,
	nonvar(Option),
	help_info(Option, String), 
	put(9),write(String), nl,
	fail.
help(Option) :-
	help_optionlist(OptList),
	(\+(help_member(Option,OptList)); var(Option)),
	put(9),write('The option '''),write(Option),write(''' is unknown.'),nl,
	put(9),write('The known options are in the set '),
	write(OptList), write('.'),nl.
help(_).

help_optionlist([a,l,s,u,q,a(_)]).

help_info(a, 'Compile an allocate instruction without arguments.').
help_info(a, 'The default is to use a single-argument allocate with the').
help_info(a, 'environment size as argument.').
help_info(l, 'Write the output in Prolog-readable list form.').
help_info(l, 'The default is to write the output in human-readable form.').
help_info(u, 'Do not expand calls of is/2 into calls of is/4.').
help_info(u, 'The default is to expand is/2 into is/4 whenever it is possible.').
help_info(u, 'Option u overrides option s.').
help_info(q, 'When output is in human-readable form, quote all atoms.').
help_info(q, 'The default is to quote only those atoms that need it.').
help_info(q, 'Option q has no effect when option l (Prolog-readable form) is used.').
help_info(a(X), 'The parameter of a(_) (which must be atomic) is appended to all').
help_info(a(X), 'labels in the human-readable code.  The default is to append nothing.').
help_info(s, 'Compile the operators +, -, \/, /\ in an expression as builtins,').
help_info(s, 'and only the others with is/4.  The default is to compile all').
help_info(s, 'operators with is/4.').
help_info(s, 'Option s has no effect when option u (unexpanded expression) is used.').

help_member(X, [X|_]).
help_member(X, [_|L]) :- help_member(X, L).
