
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

extern unsigned MODE;

enum {
  MODE_WRITE,
  MODE_READ
  };

enum {
  UNIFY_SUCCESS = 1,
  UNIFY_FAIL = 0
  };

inline void Trail(Cell c)
{
  *TR-- = c;
}

inline void Bind(Cell var, Cell val) 
{
  CellPtr loc = addr(var);
#ifdef WITH_GC
  if (loc >= E0 && (loc < cellp(B[E_CP_OFFSET]) || loc < E2))
    Trail(var);
  else if (loc < cellp(B[H_CP_OFFSET]) || loc < HMIN)
    Trail(var);
#else
  if ((loc >= E0 && loc < cellp(B[E_CP_OFFSET])))
    Trail(var);
  else if (loc < cellp(B[H_CP_OFFSET]))
    Trail(var);
#endif
  *loc = val;
}

extern Cell Deref(Cell c);

inline Cell deref(Cell c) {
  return (get_tag(c) != TAGREF || c == lvalue(c)) ? c : Deref(c);
}

extern void Fail();
extern unsigned unify(Cell, Cell);
