/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.util.core.BI;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.math.BigInteger;
import java.security.Cipher;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.CryptixRSAPrivateKey;
import java.security.interfaces.CryptixRSAPublicKey;
import java.security.interfaces.RSAFactors;

public class TestRSA
extends BaseTest {
    private static final byte[] message = "Je ne veux que du magnifique, et je ne travaille pas pour le vulgaire des lecteurs --Giambattista BODONI (1740-1813)".getBytes();
    private static final SecureRandom prng = new SecureRandom();

    public static void main(String[] stringArray) {
        new TestRSA().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        int n = 4;
        this.setExpectedPasses(n * 9);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        Signature[] signatureArray = new Signature[]{Signature.getInstance("MD2/RSA/PKCS#1"), Signature.getInstance("MD5/RSA/PKCS#1"), Signature.getInstance("SHA-1/RSA/PKCS#1"), Signature.getInstance("RIPEMD160/RSA/PKCS#1")};
        Cipher cipher = Cipher.getInstance((String)"RSA");
        int n2 = 0;
        while (n2 < n) {
            int n3 = 384 + 128 * n2;
            this.out.println("\nTest #" + (n2 + 1) + " (" + n3 + "-bit modulus)\n");
            this.out.print("  Generating keypair ");
            keyPairGenerator.initialize(n3, prng);
            this.out.print(". ");
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.out.print(". ");
            PrivateKey privateKey = keyPair.getPrivate();
            this.out.print(". ");
            PublicKey publicKey = keyPair.getPublic();
            this.out.println(". Done!\n");
            int n4 = 0;
            while (n4 < signatureArray.length) {
                this.testSignature(n3, publicKey, privateKey, signatureArray[n4]);
                ++n4;
            }
            this.testEncryption(n3, publicKey, privateKey, cipher);
            ++n2;
        }
    }

    private void testSignature(int n, PublicKey publicKey, PrivateKey privateKey, Signature signature) {
        try {
            this.out.println("  Signing with a " + n + "-bit key using " + signature.getAlgorithm() + "...");
            signature.initSign(privateKey);
            signature.update(message);
            byte[] byArray = signature.sign();
            this.out.println("  Verifying with same " + n + "-bit key using " + signature.getAlgorithm() + "...");
            signature.initVerify(publicKey);
            signature.update(message);
            boolean bl = signature.verify(byArray);
            this.passIf(bl, "Signature verification");
            if (!bl) {
                this.out.println("---- begin debugging -----\n");
                this.out.println("Computed signature: " + Hex.dumpString((byte[])byArray));
                this.out.println("RSA parameters:");
                BigInteger bigInteger = ((CryptixRSAPublicKey)publicKey).getModulus();
                BigInteger bigInteger2 = ((CryptixRSAPublicKey)publicKey).getExponent();
                this.out.println("   Public key material:");
                this.out.println("   n: " + BI.dumpString((BigInteger)bigInteger));
                this.out.println("   e: " + BI.dumpString((BigInteger)bigInteger2));
                BigInteger bigInteger3 = ((CryptixRSAPrivateKey)privateKey).getModulus();
                BigInteger bigInteger4 = ((CryptixRSAPrivateKey)privateKey).getExponent();
                BigInteger bigInteger5 = ((RSAFactors)((Object)privateKey)).getP();
                BigInteger bigInteger6 = ((RSAFactors)((Object)privateKey)).getQ();
                BigInteger bigInteger7 = ((RSAFactors)((Object)privateKey)).getInverseOfQModP();
                this.out.println("   Private key material:");
                this.out.println("   n: " + BI.dumpString((BigInteger)bigInteger3));
                this.out.println("   d: " + BI.dumpString((BigInteger)bigInteger4));
                this.out.println("   p: " + BI.dumpString((BigInteger)bigInteger5));
                this.out.println("   q: " + BI.dumpString((BigInteger)bigInteger6));
                this.out.println("   u: " + BI.dumpString((BigInteger)bigInteger7));
                BigInteger bigInteger8 = new BigInteger(byArray);
                this.out.println("   The signature as a BigInteger:");
                this.out.println("   x: " + BI.dumpString((BigInteger)bigInteger8));
                this.out.println("RSA correctness tests:");
                try {
                    boolean bl2 = bigInteger.compareTo(bigInteger3) == 0;
                    this.out.println("\t1. Same modulus? " + bl2);
                    if (!bl2) {
                        throw new RuntimeException();
                    }
                    bl2 = bigInteger5.multiply(bigInteger6).compareTo(bigInteger3) == 0;
                    this.out.println("\t2. n = pq? " + bl2);
                    if (!bl2) {
                        throw new RuntimeException();
                    }
                    BigInteger bigInteger9 = bigInteger8.modPow(bigInteger2, bigInteger3);
                    BigInteger bigInteger10 = bigInteger9.modPow(bigInteger4, bigInteger3);
                    bl2 = bigInteger10.compareTo(bigInteger8) == 0;
                    this.out.println("\t3. x = (x ** ed) mod n? " + bl2);
                    if (!bl2) {
                        throw new RuntimeException();
                    }
                    BigInteger bigInteger11 = BigInteger.valueOf(1L);
                    BigInteger bigInteger12 = bigInteger4.mod(bigInteger5.subtract(bigInteger11));
                    BigInteger bigInteger13 = bigInteger4.mod(bigInteger6.subtract(bigInteger11));
                    BigInteger bigInteger14 = bigInteger9.mod(bigInteger5).modPow(bigInteger12, bigInteger5);
                    BigInteger bigInteger15 = bigInteger9.mod(bigInteger6).modPow(bigInteger13, bigInteger6);
                    if ((bigInteger15 = bigInteger15.subtract(bigInteger14)).signum() == -1) {
                        bigInteger15 = bigInteger15.add(bigInteger6);
                    }
                    bl2 = (bigInteger10 = bigInteger14.add(bigInteger5.multiply(bigInteger15.multiply(bigInteger7).mod(bigInteger6)))).compareTo(bigInteger8) == 0;
                    this.out.println("\t4. (x ** e) mod n = (y ** d) mod pq? " + bl2);
                    if (!bl2) {
                        throw new RuntimeException();
                    }
                }
                catch (Throwable throwable) {
                    this.error(throwable);
                }
                this.out.println("---- end debugging -----");
            }
            byArray[0] = (byte)(byArray[0] ^ 1);
            signature.initVerify(publicKey);
            signature.update(message);
            bl = !signature.verify(byArray);
            this.passIf(bl, "Incorrect signature should not verify");
            return;
        }
        catch (Throwable throwable) {
            this.error(throwable);
            return;
        }
    }

    private void testEncryption(int n, PublicKey publicKey, PrivateKey privateKey, Cipher cipher) {
        this.skip("Encryption test not implemented");
    }
}

