/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.Certificate;
import cryptix.pgp.Comment;
import cryptix.pgp.KeyRingEntry;
import cryptix.pgp.KeyRingTrust;
import cryptix.pgp.Packet;
import cryptix.pgp.PacketFactory;
import cryptix.pgp.Signature;
import cryptix.pgp.UserId;
import cryptix.pgp.UserIdCertificate;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class PacketInputStream
extends DataInputStream {
    protected Packet store;
    protected DataInputStream din;

    public PacketInputStream(InputStream inputStream) {
        super(inputStream);
        this.din = new DataInputStream(this.in);
    }

    public PacketInputStream(DataInputStream dataInputStream) {
        super(dataInputStream);
        this.din = dataInputStream;
    }

    public synchronized Packet readAnyPacket() throws IOException {
        if (this.store == null) {
            return PacketFactory.read(this.din);
        }
        Packet packet = this.store;
        this.store = null;
        return packet;
    }

    public synchronized Packet readPacket() throws IOException {
        Packet packet;
        while ((packet = this.readAnyPacket()) != null && packet instanceof Comment) {
        }
        return packet;
    }

    public synchronized void pushback(Packet packet) throws IOException {
        if (this.store == null) {
            this.store = packet;
            return;
        }
        throw new IOException("Only one packet may be pushed back.");
    }

    public synchronized KeyRingEntry readKeyRingEntry(KeyRingTrust keyRingTrust) throws IOException {
        UserIdCertificate userIdCertificate;
        KeyRingTrust keyRingTrust2;
        Vector<UserIdCertificate> vector = new Vector<UserIdCertificate>();
        Packet packet = this.readPacket();
        if (packet == null) {
            return null;
        }
        if (!(packet instanceof Certificate)) {
            throw new IOException("KeyRingEntry must start with a Certificate.");
        }
        Certificate certificate = (Certificate)packet;
        packet = this.readPacket();
        if (packet == null) {
            return null;
        }
        if (!(packet instanceof KeyRingTrust)) {
            keyRingTrust2 = keyRingTrust;
            this.pushback(packet);
        } else {
            keyRingTrust2 = (KeyRingTrust)packet;
        }
        while ((userIdCertificate = this.readUserIdCertificate(keyRingTrust)) != null) {
            vector.addElement(userIdCertificate);
        }
        return new KeyRingEntry(certificate, keyRingTrust2, vector);
    }

    public synchronized UserIdCertificate readUserIdCertificate(KeyRingTrust keyRingTrust) throws IOException {
        KeyRingTrust keyRingTrust2;
        Vector<Packet> vector = new Vector<Packet>();
        Vector<Packet> vector2 = new Vector<Packet>();
        Packet packet = null;
        packet = this.readPacket();
        if (!(packet instanceof UserId)) {
            if (packet != null) {
                this.pushback(packet);
            }
            return null;
        }
        UserId userId = (UserId)packet;
        packet = this.readPacket();
        if (!(packet instanceof KeyRingTrust)) {
            keyRingTrust2 = keyRingTrust;
            if (packet != null) {
                this.pushback(packet);
            }
        } else {
            keyRingTrust2 = (KeyRingTrust)packet;
        }
        while ((packet = this.readPacket()) instanceof Signature) {
            vector.addElement(packet);
            packet = this.readPacket();
            if (!(packet instanceof KeyRingTrust) && (packet = keyRingTrust) != null) {
                this.pushback(packet);
            }
            vector2.addElement(packet);
        }
        if (packet != null) {
            this.pushback(packet);
        }
        return new UserIdCertificate(userId, keyRingTrust2, vector, vector2);
    }

    public boolean markSupported() {
        return false;
    }
}

