/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.atomicterms;

import gnu.prolog.io.ParseException;
import gnu.prolog.io.TermReader;
import gnu.prolog.io.TermWriter;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public class Predicate_number_codes
extends ExecuteOnlyCode {
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        String numStr;
        Term number = args[0];
        Term list = args[1];
        if (!(number instanceof VariableTerm || number instanceof IntegerTerm || number instanceof FloatTerm)) {
            PrologException.typeError(TermConstants.numberAtom, number);
        }
        if ((numStr = Predicate_number_codes.getNumberString(list, number instanceof VariableTerm)) != null) {
            Term res = null;
            try {
                res = TermReader.stringToTerm(numStr, interpreter.getEnvironment());
            }
            catch (ParseException ex) {
                PrologException.syntaxError(ex);
            }
            if (!(res instanceof IntegerTerm) && !(res instanceof FloatTerm)) {
                PrologException.syntaxError(TermConstants.numberExpectedAtom);
            }
            return interpreter.unify(res, number);
        }
        numStr = TermWriter.toString(number);
        Term res = TermConstants.emptyListAtom;
        int i = numStr.length() - 1;
        while (i >= 0) {
            res = CompoundTerm.getList(IntegerTerm.get(numStr.charAt(i)), res);
            --i;
        }
        return interpreter.unify(list, res);
    }

    private static String getNumberString(Term list, boolean numberIsVariable) throws PrologException {
        StringBuffer bu = new StringBuffer();
        Term cur = list;
        while (cur != TermConstants.emptyListAtom) {
            if (cur instanceof VariableTerm) {
                if (numberIsVariable) {
                    PrologException.instantiationError();
                } else {
                    return null;
                }
            }
            if (!CompoundTerm.isListPair(cur)) {
                PrologException.typeError(TermConstants.listAtom, cur);
            }
            CompoundTerm ct = (CompoundTerm)cur;
            Term head = ct.args[0].dereference();
            cur = ct.args[1].dereference();
            if (head instanceof VariableTerm) {
                if (numberIsVariable) {
                    PrologException.instantiationError();
                } else {
                    return null;
                }
            }
            if (!(head instanceof IntegerTerm)) {
                PrologException.representationError(TermConstants.characterCodeAtom);
            }
            IntegerTerm ch = (IntegerTerm)head;
            if (ch.value < 0 || 65535 < ch.value) {
                PrologException.representationError(TermConstants.characterCodeAtom);
            }
            bu.append((char)ch.value);
        }
        return bu.toString();
    }
}

