#
# Command Input Shell
# Dave Clemans
# 12/88-1/89
#
# Makefile
#
# $Id: makefile.st,v 1.6 89/02/25 17:40:14 dclemans Exp $
#
# $Log:	makefile.st,v $
# Revision 1.6  89/02/25  17:40:14  dclemans
# miscellaneous bug fixes/speedups
# 
# Revision 1.5  89/02/20  22:35:39  dclemans
# Add a "clean" action
# 
# Revision 1.4  89/02/20  22:32:09  dclemans
# Add in new file that defines traps
# 
# Revision 1.3  89/02/20  20:12:02  dclemans
# Add RCS identifiers
# 
CFLAGS	= -O -VPEEP -VPSTR -DGEMDOS=1 -DMWC_ARGV=1 -DMWC=1 -DMYMALLOC=1 -DLINED=1
LFLAGS	= -VPSTR
OFILES	= main.o version.o lex.o exec.o var.o cexp_tab.o alias.o io.o \
	cmd1.o cmd2.o cmd3.o trap.o wild.o util.o ndir.o alloca.o malloc.o

shell.ttp: $(OFILES) reader\libreader.a
	$(CC) $(LFLAGS) $(OFILES) reader\libreader.a -o $@

cexp_tab.c:	cexp.y
	f:\gnu\bison\bison.prg cexp.y

cexp_tab.o:	cexp_tab.c shell.h
main.o:		main.c shell.h
version.o:	version.c shell.h
lex.o:		lex.c shell.h
exec.o:		exec.c shell.h
var.o:		var.c shell.h
exp.o:		exp.c shell.h
alias.o:	alias.c shell.h
io.o:		io.c shell.h
cmd1.o:		cmd1.c shell.h
cmd2.o:		cmd2.c shell.h
cmd3.o:		cmd3.c shell.h
trap.o:		trap.c shell.h
wild.o:		wild.c shell.h ndir.h
ndir.o:		ndir.c ndir.h
util.o:		util.c shell.h
alloca.o:	alloca.c
malloc.o:	malloc.c

reader\libreader.a:
	cd reader;make

clean:
	rm -f shell.ttp *.o cexp_tab.c
