/*
 * Data structures for keeping and referencing a "history" of lines
 * input from a user.
 *
 * Dave Clemans, 4/84 (initial version); 1/89 (more generality)
 *
 * Interesting globals:
 *	History:		general structure for "history" information
 *	History.maxSize		maximum number of lines in history list
 *	History.currentSize	current number of lines in history list
 *	History.listTop		top of list of history lines
 *	History.listBottom	bottom of list of history lines
 *	History.currentLine	current entry in history list
 *				if reader is called, a copy of what it
 *				returns will be pointed at by this
 *
 * $Id: history.h,v 1.5 89/02/20 20:20:14 dclemans Exp $
 *
 * $Log:	history.h,v $
 * Revision 1.5  89/02/20  20:20:14  dclemans
 * Add RCS identifiers
 * 
 */
#ifndef DEFAULT_MAXSIZE
#define	DEFAULT_MAXSIZE		16	/* Default History.maxSize */
#endif  DEFAULT_MAXSIZE
#define	HISTORY_BUFFER		512	/* Sizeof a history line */

#include <stdio.h>

struct historyLine
{
	char contents[HISTORY_BUFFER];
	short int size;
	short int cursor;
	short int ttycursor;
	int command;
	struct historyLine *next;
};

extern struct History
{
	int maxSize;
	int currentSize;
	int currentCommand;
	struct historyLine *listTop;
	struct historyLine *listBottom;
	struct historyLine *listPointer;
	struct historyLine *currentLine;
} History;

/*
 * The users "state"; tty attributes, control characters, etc.
 */
extern struct	savedState
{
	short int stream;
#ifndef GEMDOS
	struct sgttyb basicAttributes;
	struct tchars basicCharacters;
#endif  GEMDOS
	short int localAttributes;
#ifndef GEMDOS
	struct ltchars localCharacters;
#endif  GEMDOS
	char *localEditor;
	short int isEmacs;
	short int isVi;
	int sigint;
	int sigquit;
	int sigtstp;
} _savedState;
extern struct	newState
{
#ifndef GEMDOS
	struct sgttyb basicAttributes;
	struct tchars basicCharacters;
#endif  GEMDOS
	short int localAttributes;
#ifndef GEMDOS
	struct ltchars localCharacters;
#endif  GEMDOS
} _newState;

#define	EOF	(-1)		/* end of file */
#define	TTY	2		/* file descriptor for tty access */
